/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.salespoint;

import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.model.profile.SalesPointSpaceVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.salespoint.SalesPointContactsTileHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.salespoint.SalesPointGeneralTileHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.salespoint.SalesPointHandlerConfigurator;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.salespoint.SalesPointOtherParametersTileHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.salespoint.SalesPointOverviewHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.salespoint.SalesPointPccsTileHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.salespoint.SalesPointValidatorsTileHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.salespoint.controllerinterceptors.SalesPointAddressExtraPanelControllerInterceptor;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.salespoint.controllerinterceptors.SalesPointContactsControllerInterceptor;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.salespoint.controllerinterceptors.SalesPointContactsPanelControllerInterceptor;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.salespoint.controllerinterceptors.SalesPointControllerInterceptor;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.salespoint.controllerinterceptors.SalesPointPccPanelControllerInterceptor;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.salespoint.controllerinterceptors.SalesPointValidatorPanelControllerInterceptor;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.rules.RuleFilteringCategory;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;

class StandardSalesPointHandlerConfigurator
implements SalesPointHandlerConfigurator {
    StandardSalesPointHandlerConfigurator() {
    }

    @Override
    public void configureController(List<BiConsumer<DataTransferPackage<SalesPoint, Void>, SalesPointSpaceVM>> toVM, List<BiConsumer<SalesPointSpaceVM, DataTransferPackage<SalesPoint, Void>>> fromVM) {
        ControllersRegistry.register((ControllerInterceptor)new SalesPointControllerInterceptor());
        ControllersRegistry.register((ControllerInterceptor)new SalesPointContactsControllerInterceptor());
        ControllersRegistry.register((ControllerInterceptor)new SalesPointContactsPanelControllerInterceptor());
        ControllersRegistry.register((ControllerInterceptor)new SalesPointAddressExtraPanelControllerInterceptor());
        ControllersRegistry.register((ControllerInterceptor)new SalesPointPccPanelControllerInterceptor());
        ControllersRegistry.register((ControllerInterceptor)new SalesPointValidatorPanelControllerInterceptor());
        toVM.add((dtp, vm) -> {
            SalesPoint model = (SalesPoint)dtp.getContainer().getEntity();
            SalesPointOverviewHelper.toVM(model, vm.getOverview());
            SalesPointGeneralTileHelper.toVM(model, vm.getGeneralFull());
            SalesPointContactsTileHelper.toVM(model, vm.getContactsFull());
            SalesPointPccsTileHelper.toVM(model, vm.getPccsFull());
            SalesPointValidatorsTileHelper.toVM(model, vm.getValidatorsFull());
            SalesPointOtherParametersTileHelper.toVM(model, vm.getOtherParametersFull());
        });
        fromVM.add((vm, dtp) -> {
            SalesPoint model = (SalesPoint)dtp.getContainer().getEntity();
            SalesPointGeneralTileHelper.fromVM(vm.getGeneralFull(), model);
            SalesPointContactsTileHelper.fromVM(vm.getContactsFull(), model);
            SalesPointPccsTileHelper.fromVM(vm.getPccsFull(), model);
            SalesPointValidatorsTileHelper.fromVM(vm.getValidatorsFull(), model);
            SalesPointOtherParametersTileHelper.fromVM(vm.getOtherParametersFull(), model);
        });
    }

    @Override
    public Collection<RuleFilteringCategory> getRuleFilteringCategoriesRegular() {
        return Collections.emptyList();
    }

    @Override
    public Collection<RuleFilteringCategory> getRuleFilteringCategoriesPrivileged() {
        return Collections.emptyList();
    }
}

