/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.settings;

import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.BaseRootEntityHandler;
import com.gridnine.xtrip.client.fx.standard.settings.model.ChartOfAccountsSettingsContainer;
import com.gridnine.xtrip.client.fx.standard.settings.model.ChartOfAccountsSettingsContainerController;
import com.gridnine.xtrip.client.fx.standard.settings.model.ChartOfAccountsSettingsContainerVM;
import com.gridnine.xtrip.client.fx.standard.settings.model.ChartOfAccountsSettingsGridVM;
import com.gridnine.xtrip.client.fx.standard.settings.model.DimensionContainerVM;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.finance.BasicChartOfAccountsElementSettings;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsSettings;
import com.gridnine.xtrip.common.model.finance.DimensionSettings;
import com.gridnine.xtrip.common.model.system.BasicSystemSettingsIndex;
import java.util.List;
import java.util.function.BiConsumer;

public class ChartOfAccountsSettingsHandler
extends BaseRootEntityHandler<ChartOfAccountsSettings, Void, ChartOfAccountsSettingsContainerVM, ChartOfAccountsSettingsContainer> {
    public Class<? extends EntityIndex<?>> getStandardIndexClass() {
        return BasicSystemSettingsIndex.class;
    }

    @Override
    protected void configureController(List<BiConsumer<DataTransferPackage<ChartOfAccountsSettings, Void>, ChartOfAccountsSettingsContainerVM>> toVM, List<BiConsumer<ChartOfAccountsSettingsContainerVM, DataTransferPackage<ChartOfAccountsSettings, Void>>> fromVM) {
        toVM.add((dtp, vm) -> {
            ChartOfAccountsSettings model = (ChartOfAccountsSettings)dtp.getContainer().getEntity();
            ChartOfAccountsSettingsGridVM panel = vm.getGeneralPanel();
            panel.setTitle(model.getName());
            panel.setBalancesDepth(model.getBalancesDepth());
            panel.setOrganization(model.getOrganization());
            panel.setTrackTransactionsChanges(model.isTrackTransactionsChanges());
            this.readDimensions(vm.getSupplierCard(), model.getSupplierSettings());
            this.readDimensions(vm.getCustomerCard(), model.getCustomerSettings());
            this.readDimensions(vm.getAgentCard(), model.getAgentSettings());
            this.readDimensions(vm.getCashRemainsCard(), model.getCashRemainsSettings());
        });
        fromVM.add((vm, dtp) -> {
            ChartOfAccountsSettings model = (ChartOfAccountsSettings)dtp.getContainer().getEntity();
            ChartOfAccountsSettingsGridVM panel = vm.getGeneralPanel();
            model.setName(panel.getTitle());
            model.setTrackTransactionsChanges(panel.isTrackTransactionsChanges());
            model.setOrganization(panel.getOrganization());
            model.setBalancesDepth(panel.getBalancesDepth());
            this.saveDimensions(vm.getSupplierCard(), model.getSupplierSettings());
            this.saveDimensions(vm.getCustomerCard(), model.getCustomerSettings());
            this.saveDimensions(vm.getAgentCard(), model.getAgentSettings());
            this.saveDimensions(vm.getCashRemainsCard(), model.getCashRemainsSettings());
        });
    }

    @Override
    protected ViewController<ChartOfAccountsSettingsContainer, ChartOfAccountsSettingsContainerVM> createSpaceController(boolean readonly) {
        return new ChartOfAccountsSettingsContainerController(readonly);
    }

    @Override
    protected ChartOfAccountsSettingsContainerVM createVM() {
        return new ChartOfAccountsSettingsContainerVM();
    }

    public Class<ChartOfAccountsSettings> getEntityClass() {
        return ChartOfAccountsSettings.class;
    }

    public Class<Void> getSupplementClass() {
        return Void.class;
    }

    private void readDimensions(DimensionContainerVM card, BasicChartOfAccountsElementSettings settings) {
        DimensionSettings dimension = settings.getDimension1();
        if (dimension != null) {
            card.setType1(dimension.getType());
        }
        if ((dimension = settings.getDimension2()) != null) {
            card.setType2(dimension.getType());
        }
        if ((dimension = settings.getDimension3()) != null) {
            card.setType3(dimension.getType());
        }
        card.setActive(settings.isEnabled());
    }

    private void saveDimensions(DimensionContainerVM card, BasicChartOfAccountsElementSettings settings) {
        DimensionSettings dimension;
        if (card.getType1() != null) {
            dimension = settings.getDimension1() != null ? settings.getDimension1() : new DimensionSettings();
            dimension.setType(card.getType1());
            settings.setDimension1(dimension);
        }
        if (card.getType2() != null) {
            dimension = settings.getDimension2() != null ? settings.getDimension2() : new DimensionSettings();
            dimension.setType(card.getType2());
            settings.setDimension2(dimension);
        }
        if (card.getType3() != null) {
            dimension = settings.getDimension3() != null ? settings.getDimension3() : new DimensionSettings();
            dimension.setType(card.getType3());
            settings.setDimension3(dimension);
        }
        settings.setEnabled(card.isActive());
    }
}

