/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.settings;

import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SimpleSuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.restriction.ExtendedSystemRestrictionsWidget;
import com.gridnine.xtrip.client.fx.standard.settings.model.CleanupObjectsSettingsContainerController;
import com.gridnine.xtrip.client.fx.standard.settings.model.CleanupObjectsSettingsContainerVM;
import com.gridnine.xtrip.client.fx.standard.settings.model.CleanupObjectsSettingsGrid;
import com.gridnine.xtrip.common.meta.BaseMetaElement;
import com.gridnine.xtrip.common.meta.IndexType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.assets.SysLogItem;
import com.gridnine.xtrip.common.model.assets.TemporalObject;
import com.gridnine.xtrip.common.model.cache.asset.ModifiedObjectReference;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.system.Message;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javafx.util.StringConverter;

class CleanupObjectsSettingsControllerInterceptor
extends ControllerInterceptor<CleanupObjectsSettingsContainerVM, CleanupObjectsSettingsContainerController> {
    CleanupObjectsSettingsControllerInterceptor() {
    }

    protected Class<CleanupObjectsSettingsContainerController> getControllerClass() {
        return CleanupObjectsSettingsContainerController.class;
    }

    protected void onCreate(CleanupObjectsSettingsContainerController controller) {
        ComboBoxWidget classNameWidget = ((CleanupObjectsSettingsGrid)controller.getView().getGeneralPanelCard().getContent()).getObjectClassNameNode();
        ExtendedSystemRestrictionsWidget restrictionsWidget = (ExtendedSystemRestrictionsWidget)controller.getView().getCriterionsCard().getContent();
        classNameWidget.valueProperty().addListener((s, o, n) -> {
            if (n != null) {
                restrictionsWidget.setRestrictionId((String)n);
            }
        });
        classNameWidget.setItemsSupplier(() -> {
            ArrayList<String> result = new ArrayList<String>(MetaRegistry.get().getIndexes().size() + 5);
            result.add(ModifiedObjectReference.class.getName());
            result.add(TemporalObject.class.getName());
            result.add(SysLogItem.class.getName());
            MetaRegistry.get().getIndexes().values().stream().map(BaseMetaElement::getId).collect(Collectors.toCollection(() -> result));
            return result;
        });
        classNameWidget.setConverter((StringConverter)new StringConverter<String>(){

            public String toString(String object) {
                if (object == null) {
                    return null;
                }
                IndexType indexType = (IndexType)MetaRegistry.get().getIndexes().get(object);
                if (indexType != null) {
                    return indexType.getDisplayName();
                }
                int idx = object.lastIndexOf(".");
                return idx == -1 ? object : object.substring(idx + 1);
            }

            public String fromString(String string) {
                return null;
            }
        });
        classNameWidget.setSuggestionsHandler((SuggestionsHandler)new SimpleSuggestionsHandler(classNameWidget.getConverter(), classNameWidget.getItemsSupplier(), true));
    }

    protected void validateData(CleanupObjectsSettingsContainerController controller, List<Message> messages) {
        if (((CleanupObjectsSettingsGrid)controller.getView().getGeneralPanelCard().getContent()).getObjectClassNameNode().getValue() == null) {
            messages.add(MessageHelper.createErrorMessage((String)Messages.Object_not_specified, (Object[])new Object[0]));
        }
    }
}

