/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.settings;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.settings.model.FTPResourcesProviderSettingsVM;
import com.gridnine.xtrip.client.fx.standard.settings.model.FileResourcesProviderSettingsVM;
import com.gridnine.xtrip.client.fx.standard.settings.model.HttpResourcesProviderSettingsVM;
import com.gridnine.xtrip.client.fx.standard.settings.model.SFTPResourcesProviderSettingsVM;
import com.gridnine.xtrip.client.fx.standard.settings.model.StandardExchangeDocumentParserSettingsContainerVM;
import com.gridnine.xtrip.client.fx.standard.settings.model.StandardExchangeDocumentParserSettingsGridVM;
import com.gridnine.xtrip.common.parsers.model.BaseExchangeDocumentParserSettings;
import com.gridnine.xtrip.common.parsers.model.BaseResourcesProviderSettings;
import com.gridnine.xtrip.common.parsers.model.FileResourcesProviderSettings;
import com.gridnine.xtrip.common.parsers.model.FtpResourcesProviderSettings;
import com.gridnine.xtrip.common.parsers.model.HttpResourcesProviderSettings;
import com.gridnine.xtrip.common.parsers.model.SftpResourcesProviderSettings;
import com.gridnine.xtrip.common.util.TextUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class ExchangeDocumentParserSettingsHelper {
    public static void toVM(BaseExchangeDocumentParserSettings model, StandardExchangeDocumentParserSettingsContainerVM vm) {
        StandardExchangeDocumentParserSettingsGridVM generalPanel = vm.getGeneralPanel();
        BaseResourcesProviderSettings resourceProviderSettings = model.getResourceProviderSettings();
        if (resourceProviderSettings != null) {
            generalPanel.setConnectionType(resourceProviderSettings.getConnectionType());
        }
        generalPanel.setTitle(model.getName());
        generalPanel.setCode(model.getCode());
        ExchangeDocumentParserSettingsHelper.loadResourceProviderSettings(model, vm);
    }

    public static void fromVM(StandardExchangeDocumentParserSettingsContainerVM vm, BaseExchangeDocumentParserSettings model) {
        StandardExchangeDocumentParserSettingsGridVM generalPanel = vm.getGeneralPanel();
        model.setName(generalPanel.getTitle());
        model.setCode(generalPanel.getCode());
        ExchangeDocumentParserSettingsHelper.saveResourceProviderSettings(vm, model);
    }

    private static void loadResourceProviderSettings(BaseExchangeDocumentParserSettings model, StandardExchangeDocumentParserSettingsContainerVM vm) {
        BaseResourcesProviderSettings resourcesProviderSettings = model.getResourceProviderSettings();
        if (resourcesProviderSettings != null && resourcesProviderSettings.getConnectionType() != null) {
            switch (resourcesProviderSettings.getConnectionType()) {
                case HTTP_HOTELBOOK: {
                    HttpResourcesProviderSettingsVM httpConnectionSettings = vm.getHTTPConnectionSettings();
                    HttpResourcesProviderSettings modelResourceProviderSettings = (HttpResourcesProviderSettings)resourcesProviderSettings;
                    httpConnectionSettings.setLogin(modelResourceProviderSettings.getLogin());
                    httpConnectionSettings.setPassword(modelResourceProviderSettings.getPassword());
                    httpConnectionSettings.setUrl(modelResourceProviderSettings.getUrl());
                    httpConnectionSettings.setClientKey(modelResourceProviderSettings.getClientKey());
                    break;
                }
                case FTP: {
                    FTPResourcesProviderSettingsVM ftpConnectionSettings = vm.getFTPConnectionSettings();
                    FtpResourcesProviderSettings modelResourceProviderSettings = (FtpResourcesProviderSettings)resourcesProviderSettings;
                    ftpConnectionSettings.setLogin(modelResourceProviderSettings.getLogin());
                    ftpConnectionSettings.setPassword(modelResourceProviderSettings.getPassword());
                    ftpConnectionSettings.setEncoding(modelResourceProviderSettings.getEncoding());
                    ftpConnectionSettings.setExtensions(modelResourceProviderSettings.getFileExtensions().stream().collect(Collectors.joining(", ")));
                    ftpConnectionSettings.setFileType(modelResourceProviderSettings.getFileType());
                    if (modelResourceProviderSettings.getUrl() != null) {
                        ftpConnectionSettings.setUrl(modelResourceProviderSettings.getUrl().toString());
                    }
                    ftpConnectionSettings.setPassive(modelResourceProviderSettings.isPassiveMode());
                    ftpConnectionSettings.setTlsEnabled(modelResourceProviderSettings.isTlsEnabled());
                    break;
                }
                case SFTP: {
                    SFTPResourcesProviderSettingsVM ftpConnectionSettings = vm.getSFTPConnectionSettings();
                    SftpResourcesProviderSettings modelResourceProviderSettings = (SftpResourcesProviderSettings)resourcesProviderSettings;
                    ftpConnectionSettings.setLogin(modelResourceProviderSettings.getLogin());
                    ftpConnectionSettings.setPassword(modelResourceProviderSettings.getPassword());
                    ftpConnectionSettings.setEncoding(modelResourceProviderSettings.getEncoding());
                    ftpConnectionSettings.setExtensions(modelResourceProviderSettings.getFileExtensions().stream().collect(Collectors.joining(", ")));
                    if (modelResourceProviderSettings.getUrl() != null) {
                        ftpConnectionSettings.setUrl(modelResourceProviderSettings.getUrl().toString());
                    }
                    ftpConnectionSettings.setServerKey(modelResourceProviderSettings.getServerKey());
                    ftpConnectionSettings.setLocalFolder(modelResourceProviderSettings.getLocalFolder());
                    break;
                }
                case FILE: {
                    FileResourcesProviderSettingsVM fileConnectionSettings = vm.getFileConnectionSettings();
                    FileResourcesProviderSettings modelResourceProviderSettings = (FileResourcesProviderSettings)resourcesProviderSettings;
                    fileConnectionSettings.setExtensions(modelResourceProviderSettings.getFileExtensions().stream().collect(Collectors.joining(", ")));
                    fileConnectionSettings.setDirectory(modelResourceProviderSettings.getFolder());
                }
            }
        }
    }

    private static void saveResourceProviderSettings(StandardExchangeDocumentParserSettingsContainerVM vm, BaseExchangeDocumentParserSettings model) {
        if (vm.getGeneralPanel().getConnectionType() == null) {
            return;
        }
        switch (vm.getGeneralPanel().getConnectionType()) {
            case HTTP_HOTELBOOK: {
                HttpResourcesProviderSettingsVM httpConnectionSettings = vm.getHTTPConnectionSettings();
                HttpResourcesProviderSettings resourcesProviderSettings = new HttpResourcesProviderSettings();
                resourcesProviderSettings.setConnectionType(vm.getGeneralPanel().getConnectionType());
                model.setResourceProviderSettings((BaseResourcesProviderSettings)resourcesProviderSettings);
                resourcesProviderSettings.setLogin(httpConnectionSettings.getLogin());
                resourcesProviderSettings.setPassword(httpConnectionSettings.getPassword());
                resourcesProviderSettings.setUrl(httpConnectionSettings.getUrl());
                resourcesProviderSettings.setClientKey(httpConnectionSettings.getClientKey());
                break;
            }
            case FTP: {
                FTPResourcesProviderSettingsVM ftpConnectionSettings = vm.getFTPConnectionSettings();
                FtpResourcesProviderSettings resourcesProviderSettings = new FtpResourcesProviderSettings();
                resourcesProviderSettings.setConnectionType(vm.getGeneralPanel().getConnectionType());
                model.setResourceProviderSettings((BaseResourcesProviderSettings)resourcesProviderSettings);
                resourcesProviderSettings.setLogin(ftpConnectionSettings.getLogin());
                resourcesProviderSettings.setPassword(ftpConnectionSettings.getPassword());
                resourcesProviderSettings.setEncoding(ftpConnectionSettings.getEncoding());
                resourcesProviderSettings.getFileExtensions().clear();
                if (!TextUtil.isBlank((String)ftpConnectionSettings.getExtensions())) {
                    resourcesProviderSettings.getFileExtensions().addAll(Arrays.asList(Pattern.compile(", ").split(ftpConnectionSettings.getExtensions())));
                }
                resourcesProviderSettings.setFileType(ftpConnectionSettings.getFileType());
                if (!TextUtil.isBlank((String)ftpConnectionSettings.getUrl())) {
                    try {
                        String url = ftpConnectionSettings.getUrl();
                        resourcesProviderSettings.setUrl(new URL(url.contains("://") ? url : "ftp://" + url));
                    }
                    catch (MalformedURLException ignored) {
                        Dialog.info((String)Messages.Invalid_URL_parameter);
                    }
                }
                resourcesProviderSettings.setPassiveMode(ftpConnectionSettings.isPassive());
                resourcesProviderSettings.setTlsEnabled(ftpConnectionSettings.isTlsEnabled());
                break;
            }
            case SFTP: {
                SFTPResourcesProviderSettingsVM ftpConnectionSettings = vm.getSFTPConnectionSettings();
                SftpResourcesProviderSettings resourcesProviderSettings = new SftpResourcesProviderSettings();
                resourcesProviderSettings.setConnectionType(vm.getGeneralPanel().getConnectionType());
                model.setResourceProviderSettings((BaseResourcesProviderSettings)resourcesProviderSettings);
                resourcesProviderSettings.setLogin(ftpConnectionSettings.getLogin());
                resourcesProviderSettings.setPassword(ftpConnectionSettings.getPassword());
                resourcesProviderSettings.setEncoding(ftpConnectionSettings.getEncoding());
                resourcesProviderSettings.getFileExtensions().clear();
                if (!TextUtil.isBlank((String)ftpConnectionSettings.getExtensions())) {
                    resourcesProviderSettings.getFileExtensions().addAll(Arrays.asList(Pattern.compile(", ").split(ftpConnectionSettings.getExtensions())));
                }
                if (!TextUtil.isBlank((String)ftpConnectionSettings.getUrl())) {
                    try {
                        String url = ftpConnectionSettings.getUrl();
                        resourcesProviderSettings.setUrl(new URL(url.startsWith("http://") ? url : "http://" + url));
                    }
                    catch (MalformedURLException ignored) {
                        Dialog.info((String)Messages.Invalid_URL_parameter);
                    }
                }
                resourcesProviderSettings.setServerKey(ftpConnectionSettings.getServerKey());
                resourcesProviderSettings.setLocalFolder(ftpConnectionSettings.getLocalFolder());
                break;
            }
            case FILE: {
                FileResourcesProviderSettingsVM fileConnectionSettings = vm.getFileConnectionSettings();
                FileResourcesProviderSettings resourcesProviderSettings = new FileResourcesProviderSettings();
                resourcesProviderSettings.setConnectionType(vm.getGeneralPanel().getConnectionType());
                model.setResourceProviderSettings((BaseResourcesProviderSettings)resourcesProviderSettings);
                resourcesProviderSettings.setFolder(fileConnectionSettings.getDirectory());
                resourcesProviderSettings.getFileExtensions().clear();
                if (TextUtil.isBlank((String)fileConnectionSettings.getExtensions())) break;
                resourcesProviderSettings.getFileExtensions().addAll(Arrays.asList(Pattern.compile(", ").split(fileConnectionSettings.getExtensions())));
            }
        }
    }

    private ExchangeDocumentParserSettingsHelper() {
    }
}

