/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.settings;

import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.widgets.HyperlinkWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog.EntityBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.settings.model.IwayConfigContainerController;
import com.gridnine.xtrip.client.fx.settings.model.IwayConfigContainerVM;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.service.IntegrationBusRpcService;
import com.gridnine.xtrip.common.model.booking.IBusIwayContextKeys;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

class IwayConfigControllerInterceptor
extends ControllerInterceptor<IwayConfigContainerVM, IwayConfigContainerController> {
    IwayConfigControllerInterceptor() {
    }

    protected void onCreate(IwayConfigContainerController controller) {
        EntityBoxWidgetColumn supplierColumn = (EntityBoxWidgetColumn)((TableWidget)controller.getSupplierSettings().getView()).getColumn("supplier");
        supplierColumn.setListParametersSupplier(ControllerInterceptorsHelper::getBlankOwners);
        ((HyperlinkWidget)controller.getView().getTestCell().getPayload()).onActionProperty().setValue(event -> Notifications.get().submitTask(() -> this.testServerConnection(controller), Messages.Test_iway_connection));
        controller.getView().getLoginNode().valueProperty().addListener((s, o, n) -> this.disableTestButton(controller));
        controller.getView().getPasswordNode().valueProperty().addListener((s, o, n) -> this.disableTestButton(controller));
        controller.getView().getUrlNode().valueProperty().addListener((s, o, n) -> this.disableTestButton(controller));
    }

    protected Class<IwayConfigContainerController> getControllerClass() {
        return IwayConfigContainerController.class;
    }

    private void testServerConnection(IwayConfigContainerController controller) {
        String login = controller.getView().getLoginNode().getValue();
        String password = controller.getView().getPasswordNode().getValue();
        String URL2 = controller.getView().getUrlNode().getValue();
        HashMap<String, String> contextMap = new HashMap<String, String>();
        contextMap.put(IBusIwayContextKeys.IWAY_USER_LOGIN.name(), login);
        contextMap.put(IBusIwayContextKeys.IWAY_USER_PASSWORD.name(), password);
        contextMap.put(IBusIwayContextKeys.IWAY_SERVICE_URL.name(), URL2);
        try {
            Map tempMap = ((IntegrationBusRpcService)RpcServiceManager.get().getService(IntegrationBusRpcService.class)).processRouteSync(ServiceInvocationContext.get(), "parsers-iway:test-connection-route", contextMap, Collections.singleton(IBusIwayContextKeys.IWAY_USER_ID.name()));
            if (tempMap.get(IBusIwayContextKeys.IWAY_USER_ID.name()) == null) {
                Notifications.get().showMessages(new Message[]{MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.Connection_failed, (Object[])new Object[0])});
            } else {
                Notifications.get().showMessages(new Message[]{MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.Connection_is_successfully_established, (Object[])new Object[0])});
            }
        }
        catch (Exception e) {
            Notifications.get().showMessages(new Message[]{MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.Connection_failed, (Throwable)e, (Object[])new Object[0])});
        }
    }

    public void disableTestButton(IwayConfigContainerController controller) {
        controller.getView().getTestNode().setDisable(TextUtil.isBlank((String)controller.getView().getLoginNode().getValue()) || TextUtil.isBlank((String)controller.getView().getPasswordNode().getValue()) || TextUtil.isBlank((String)controller.getView().getUrlNode().getValue()));
    }
}

