/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.settings;

import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.settings.model.IwayConfigContainer;
import com.gridnine.xtrip.client.fx.settings.model.IwayConfigContainerController;
import com.gridnine.xtrip.client.fx.settings.model.IwayConfigContainerVM;
import com.gridnine.xtrip.client.fx.settings.model.IwayConfigSupplierSettingsContainerVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.BaseRootEntityHandler;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.settings.IwayConfigControllerInterceptor;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.booking.transfers.IwayConfig;
import com.gridnine.xtrip.common.model.profile.IwaySupplierSettings;
import com.gridnine.xtrip.common.model.system.BasicSystemSettingsIndex;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import java.util.function.BiConsumer;

public class IwayConfigHandler
extends BaseRootEntityHandler<IwayConfig, Void, IwayConfigContainerVM, IwayConfigContainer> {
    @Override
    protected void configureController(List<BiConsumer<DataTransferPackage<IwayConfig, Void>, IwayConfigContainerVM>> toVM, List<BiConsumer<IwayConfigContainerVM, DataTransferPackage<IwayConfig, Void>>> fromVM) {
        ControllersRegistry.register((ControllerInterceptor)new IwayConfigControllerInterceptor());
        toVM.add((dtp, vm) -> {
            IwayConfig model = (IwayConfig)dtp.getContainer().getEntity();
            vm.setName(model.getName());
            vm.setLogin(model.getLogin());
            vm.setPassword(model.getPassword());
            vm.setUrl(model.getServiceUrl());
            vm.setCommissionProperties(model.getCommissionProperties());
            VMHelper.transfer(model.getSupplierSettings(), vm.getSupplierSettings(), settings -> new IwayConfigSupplierSettingsContainerVM(), (settings, settingsVm) -> {
                settingsVm.setStartDate(DateUtils.asLocalDate((Date)settings.getOpened()));
                settingsVm.setEndDate(DateUtils.asLocalDate((Date)settings.getClosed()));
                settingsVm.setSupplier(settings.getSupplier());
            });
        });
        fromVM.add((vm, dtp) -> {
            IwayConfig model = (IwayConfig)dtp.getContainer().getEntity();
            model.setName(vm.getName());
            model.setLogin(vm.getLogin());
            model.setPassword(vm.getPassword());
            model.setServiceUrl(vm.getUrl());
            model.setCommissionProperties(vm.getCommissionProperties());
            VMHelper.transfer(vm.getSupplierSettings(), model.getSupplierSettings(), settings -> new IwaySupplierSettings(), (settingsVm, settings) -> {
                settings.setOpened(DateUtils.asDate((LocalDate)settingsVm.getStartDate()));
                settings.setClosed(DateUtils.asDate((LocalDate)settingsVm.getEndDate()));
                settings.setSupplier(settingsVm.getSupplier());
            });
        });
    }

    @Override
    protected ViewController<IwayConfigContainer, IwayConfigContainerVM> createSpaceController(boolean readonly) {
        return new IwayConfigContainerController(readonly);
    }

    @Override
    protected IwayConfigContainerVM createVM() {
        return new IwayConfigContainerVM();
    }

    public Class<IwayConfig> getEntityClass() {
        return IwayConfig.class;
    }

    public Class<Void> getSupplementClass() {
        return null;
    }

    public Class<? extends EntityIndex<?>> getStandardIndexClass() {
        return BasicSystemSettingsIndex.class;
    }
}

