/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.settings;

import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.BaseRootEntityHandler;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.settings.LongRunningTasksSettingsControllerInterceptor;
import com.gridnine.xtrip.client.fx.standard.settings.model.LongRunningTasksSettingsContainer;
import com.gridnine.xtrip.client.fx.standard.settings.model.LongRunningTasksSettingsContainerController;
import com.gridnine.xtrip.client.fx.standard.settings.model.LongRunningTasksSettingsContainerVM;
import com.gridnine.xtrip.client.fx.standard.settings.model.LongRunningTasksSettingsGridVM;
import com.gridnine.xtrip.client.fx.standard.settings.model.WorkingPeriodVM;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.dict.WeekDay;
import com.gridnine.xtrip.common.model.system.BasicSystemSettingsIndex;
import com.gridnine.xtrip.common.model.system.lrt.LongRunningTasksSettings;
import com.gridnine.xtrip.common.model.system.lrt.WorkingPeriod;
import java.time.LocalTime;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public class LongRunningTasksSettingsHandler
extends BaseRootEntityHandler<LongRunningTasksSettings, Void, LongRunningTasksSettingsContainerVM, LongRunningTasksSettingsContainer> {
    public Class<? extends EntityIndex<?>> getStandardIndexClass() {
        return BasicSystemSettingsIndex.class;
    }

    @Override
    protected void configureController(List<BiConsumer<DataTransferPackage<LongRunningTasksSettings, Void>, LongRunningTasksSettingsContainerVM>> toVM, List<BiConsumer<LongRunningTasksSettingsContainerVM, DataTransferPackage<LongRunningTasksSettings, Void>>> fromVM) {
        ControllersRegistry.register((ControllerInterceptor)new LongRunningTasksSettingsControllerInterceptor());
        toVM.add((dtp, vm) -> {
            LongRunningTasksSettings model = (LongRunningTasksSettings)dtp.getContainer().getEntity();
            LongRunningTasksSettingsGridVM generalPanel = vm.getGeneralPanel();
            generalPanel.setPoolingDelayInSeconds(model.getPoolingDelayInSeconds());
            generalPanel.setPoolingPeriodInSeconds(model.getPoolingPeriodInSeconds());
            generalPanel.setServerId(model.getInstallationId());
            model.getWorkingPeriods().forEach(workingPeriod -> {
                WorkingPeriodVM workingPeriodVM = new WorkingPeriodVM();
                workingPeriodVM.setStart(LocalTime.of(workingPeriod.getBeginHour(), 0));
                workingPeriodVM.setEnd(LocalTime.of(workingPeriod.getEndHour(), 0));
                workingPeriodVM.getWorkingDays().clear();
                workingPeriodVM.getWorkingDays().addAll(workingPeriod.getDaysOfWeek().stream().map(intDay -> WeekDay.values()[intDay]).collect(Collectors.toList()));
                vm.getWorkingPeriods().add(workingPeriodVM);
            });
        });
        fromVM.add((vm, dtp) -> {
            LongRunningTasksSettings model = (LongRunningTasksSettings)dtp.getContainer().getEntity();
            LongRunningTasksSettingsGridVM generalPanel = vm.getGeneralPanel();
            model.setPoolingPeriodInSeconds(generalPanel.getPoolingPeriodInSeconds());
            model.setPoolingDelayInSeconds(generalPanel.getPoolingDelayInSeconds());
            model.setInstallationId(generalPanel.getServerId());
            model.getWorkingPeriods().clear();
            vm.getWorkingPeriods().forEach(workingPeriodVM -> {
                WorkingPeriod workingPeriod = new WorkingPeriod();
                workingPeriod.getDaysOfWeek().clear();
                workingPeriod.getDaysOfWeek().addAll(workingPeriodVM.getWorkingDays().stream().mapToInt(Enum::ordinal).mapToObj(Integer::valueOf).collect(Collectors.toList()));
                int workStart = workingPeriodVM.getStart() != null ? workingPeriodVM.getStart().getHour() : 0;
                int workEnd = workingPeriodVM.getEnd() != null ? workingPeriodVM.getEnd().getHour() : 0;
                workingPeriod.setBeginHour(workStart);
                workingPeriod.setEndHour(workEnd);
                model.getWorkingPeriods().add(workingPeriod);
            });
        });
    }

    @Override
    protected ViewController<LongRunningTasksSettingsContainer, LongRunningTasksSettingsContainerVM> createSpaceController(boolean readonly) {
        return new LongRunningTasksSettingsContainerController(readonly);
    }

    @Override
    protected LongRunningTasksSettingsContainerVM createVM() {
        return new LongRunningTasksSettingsContainerVM();
    }

    public Class<LongRunningTasksSettings> getEntityClass() {
        return LongRunningTasksSettings.class;
    }

    public Class<Void> getSupplementClass() {
        return Void.class;
    }
}

