/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.settings;

import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.ComboBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.settings.model.SabreProfilesComponentPnrTypesSettingsContainerVM;
import com.gridnine.xtrip.client.fx.settings.model.SabreProfilesConnectionSettingsContainer;
import com.gridnine.xtrip.client.fx.settings.model.SabreProfilesConnectionSettingsContainerController;
import com.gridnine.xtrip.client.fx.settings.model.SabreProfilesConnectionSettingsContainerVM;
import com.gridnine.xtrip.client.fx.settings.model.SabreProfilesISuiteSettingsContainerVM;
import com.gridnine.xtrip.client.fx.settings.model.SabreProfilesPccSettingsContainerVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.BaseRootEntityHandler;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.gds.sabre.SabreProfilesConnectionSettings;
import com.gridnine.xtrip.common.model.gds.sabre.SabreProfilesPNRBuilderType;
import com.gridnine.xtrip.common.model.profile.ISuiteCostCodesSyncSettings;
import com.gridnine.xtrip.common.model.profile.SabreProfilesPccSettings;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public class SabreProfilesConnectionSettingsHandler
extends BaseRootEntityHandler<SabreProfilesConnectionSettings, Void, SabreProfilesConnectionSettingsContainerVM, SabreProfilesConnectionSettingsContainer> {
    @Override
    protected void configureController(List<BiConsumer<DataTransferPackage<SabreProfilesConnectionSettings, Void>, SabreProfilesConnectionSettingsContainerVM>> toVM, List<BiConsumer<SabreProfilesConnectionSettingsContainerVM, DataTransferPackage<SabreProfilesConnectionSettings, Void>>> fromVM) {
        ControllersRegistry.register((ControllerInterceptor)new SabreProfilesConnectionSettingsInterceptor());
        toVM.add((dtp, vm) -> {
            SabreProfilesConnectionSettings model = (SabreProfilesConnectionSettings)dtp.getContainer().getEntity();
            vm.setName(model.getName());
            vm.setActive(model.isActive());
            vm.setLoadActive(model.isLoadActive());
            vm.setUrl(model.getServerURL());
            VMHelper.transfer(model.getBuilderTypes(), vm.getPnrBuilderTypes(), builder -> new SabreProfilesComponentPnrTypesSettingsContainerVM(), (builder, builderVM) -> {
                builderVM.setName(builder.getName());
                builderVM.setDescription(builder.getDescription());
            });
            VMHelper.transfer(model.getPccSettings(), vm.getPccSettings(), pccSettings -> new SabreProfilesPccSettingsContainerVM(), (pccSettings, pccSettingsVM) -> {
                pccSettingsVM.setPcc(pccSettings.getPcc());
                pccSettingsVM.setPassword(pccSettings.getPassword());
                pccSettingsVM.setDescription(pccSettings.getDescription());
            });
            VMHelper.transfer(model.getISuiteCostCodesSettings(), vm.getISuiteCostCodesSettings(), pccSettings -> new SabreProfilesISuiteSettingsContainerVM(), (iSuiteSettings, iSuiteSettingsVM) -> {
                iSuiteSettingsVM.setCostCodeType(iSuiteSettings.getCostCodeType());
                iSuiteSettingsVM.setField(iSuiteSettings.getField());
            });
        });
        fromVM.add((vm, dtp) -> {
            SabreProfilesConnectionSettings model = (SabreProfilesConnectionSettings)dtp.getContainer().getEntity();
            model.setName(vm.getName());
            model.setActive(vm.isActive());
            model.setLoadActive(vm.isLoadActive());
            model.setServerURL(vm.getUrl());
            VMHelper.transfer(vm.getPnrBuilderTypes().stream().filter(type -> TextUtil.nonBlank((String)type.getName())).collect(Collectors.toList()), model.getBuilderTypes(), builder -> new SabreProfilesPNRBuilderType(), (builderVM, builder) -> {
                builder.setName(builderVM.getName());
                builder.setDescription(builderVM.getDescription());
            });
            VMHelper.transfer(vm.getPccSettings(), model.getPccSettings(), pccSettings -> new SabreProfilesPccSettings(), (pccSettingsVM, pccSettings) -> {
                pccSettings.setPcc(pccSettingsVM.getPcc());
                pccSettings.setPassword(pccSettingsVM.getPassword());
                pccSettings.setDescription(pccSettingsVM.getDescription());
            });
            VMHelper.transfer(vm.getISuiteCostCodesSettings().stream().filter(set -> set.getCostCodeType() != null && TextUtil.nonBlank((String)set.getField())).collect(Collectors.toList()), model.getISuiteCostCodesSettings(), pccSettings -> new ISuiteCostCodesSyncSettings(), (iSuiteSettingsVM, iSuiteSettings) -> {
                iSuiteSettings.setCostCodeType(iSuiteSettingsVM.getCostCodeType());
                iSuiteSettings.setField(iSuiteSettingsVM.getField());
            });
        });
    }

    @Override
    protected ViewController<SabreProfilesConnectionSettingsContainer, SabreProfilesConnectionSettingsContainerVM> createSpaceController(boolean readonly) {
        return new SabreProfilesConnectionSettingsContainerController(readonly);
    }

    @Override
    protected SabreProfilesConnectionSettingsContainerVM createVM() {
        return new SabreProfilesConnectionSettingsContainerVM();
    }

    public Class<SabreProfilesConnectionSettings> getEntityClass() {
        return SabreProfilesConnectionSettings.class;
    }

    public Class<Void> getSupplementClass() {
        return Void.class;
    }

    public Class<? extends EntityIndex<?>> getStandardIndexClass() {
        return null;
    }

    private static class SabreProfilesConnectionSettingsInterceptor
    extends ControllerInterceptor<SabreProfilesConnectionSettingsContainerVM, SabreProfilesConnectionSettingsContainerController> {
        private SabreProfilesConnectionSettingsInterceptor() {
        }

        protected void onCreate(SabreProfilesConnectionSettingsContainerController controller) {
            controller.getView().getLoadActiveNode().valueProperty().addListener((s, o, n) -> controller.getView().getISuiteCostCodesSettingsCell().setHidden(n == false));
            ComboBoxWidgetColumn costCodeTypeCell = (ComboBoxWidgetColumn)controller.getView().getISuiteCostCodesSettingsNode().getColumn("costCodeType");
            costCodeTypeCell.setSortItems(false);
        }

        protected void afterReadData(SabreProfilesConnectionSettingsContainerController controller, SabreProfilesConnectionSettingsContainerVM model) {
            controller.getView().getISuiteCostCodesSettingsCell().setHidden(!controller.isLoadActive());
        }

        protected Class<SabreProfilesConnectionSettingsContainerController> getControllerClass() {
            return SabreProfilesConnectionSettingsContainerController.class;
        }
    }
}

