/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.stockcontrol;

import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.model.profile.StockBlankHistoryVM;
import com.gridnine.xtrip.client.fx.model.profile.StockBlankMessagesControlVM;
import com.gridnine.xtrip.client.fx.model.profile.StockBlankSpace;
import com.gridnine.xtrip.client.fx.model.profile.StockBlankSpaceController;
import com.gridnine.xtrip.client.fx.model.profile.StockBlankSpaceVM;
import com.gridnine.xtrip.client.fx.model.profile.StockBlankTicketsBindingHistoryVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.BaseRootEntityHandler;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.stockcontrol.controllerinterceptors.StockBlankControllerInterceptor;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.stockcontrol.StockBlank;
import com.gridnine.xtrip.common.model.stockcontrol.StockBlankIndex;
import java.util.Date;
import java.util.List;
import java.util.function.BiConsumer;

public class StockBlankHandler
extends BaseRootEntityHandler<StockBlank, Void, StockBlankSpaceVM, StockBlankSpace> {
    public Class<? extends EntityIndex<?>> getStandardIndexClass() {
        return StockBlankIndex.class;
    }

    @Override
    protected void configureController(List<BiConsumer<DataTransferPackage<StockBlank, Void>, StockBlankSpaceVM>> toVM, List<BiConsumer<StockBlankSpaceVM, DataTransferPackage<StockBlank, Void>>> fromVM) {
        ControllersRegistry.register((ControllerInterceptor)new StockBlankControllerInterceptor());
        toVM.add((dtp, vm) -> {
            StockBlank model = (StockBlank)dtp.getContainer().getEntity();
            vm.getMainFull().getGeneral().setNumber(model.getNumber());
            vm.getMainFull().getGeneral().setType(model.getType());
            vm.getMainFull().getGeneral().setRegistrationDate(DateUtils.asLocalDate((Date)model.getRegistrationDate()));
            vm.getMainFull().getGeneral().setOwner(model.getOwner());
            vm.getMainFull().getGeneral().setSupplier(model.getSupplier());
            vm.getMainFull().getGeneral().setStockHolder(model.getStockHolder());
            vm.getMainFull().getGeneral().setUsageStatus(model.getUsageStatus());
            vm.getMainFull().getGeneral().setOperationDate(DateUtils.asLocalDate((Date)model.getOperationDate()));
            vm.getMainFull().getGeneral().setCurrentLocation(model.getCurrentLocation());
            model.getOrderLogItems().forEach(item -> {
                StockBlankHistoryVM itemVM = new StockBlankHistoryVM();
                itemVM.setOrder(item.getOrder());
                itemVM.setOrderType(item.getOrderType());
                itemVM.setBlankLocation(item.getBlankLocation());
                itemVM.setOperationDate(DateUtils.asLocalDate((Date)item.getOperationDate()));
                vm.getMainFull().getBlankHistory().add(itemVM);
            });
            model.getProductLogItems().forEach(item -> {
                StockBlankTicketsBindingHistoryVM itemVM = new StockBlankTicketsBindingHistoryVM();
                itemVM.setBlankLocation(item.getBlankLocation());
                itemVM.setOperationDate(DateUtils.asLocalDate((Date)item.getOperationDate()));
                itemVM.setProductTitle(item.getProductTitle());
                vm.getMainFull().getTicketsBindingHistory().add(itemVM);
            });
            model.getControlMessages().forEach(message -> {
                StockBlankMessagesControlVM messageVM = new StockBlankMessagesControlVM();
                messageVM.setType(message.getType());
                messageVM.setMessage(message.getMessage().toString());
                messageVM.getDetails().setContent(message.getDetails());
                vm.getMainFull().getControlMessages().add(messageVM);
            });
        });
    }

    public Class<StockBlank> getEntityClass() {
        return StockBlank.class;
    }

    public Class<Void> getSupplementClass() {
        return Void.class;
    }

    @Override
    protected ViewController<StockBlankSpace, StockBlankSpaceVM> createSpaceController(boolean readonly) {
        return new StockBlankSpaceController(readonly);
    }

    @Override
    protected StockBlankSpaceVM createVM() {
        return new StockBlankSpaceVM();
    }
}

