/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.stockcontrol.controllerinterceptors;

import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.Tile;
import com.gridnine.xtrip.client.fx.core.lib.widgets.LongValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableRowEvent;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.ComboBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.LongValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.TextWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog.EntityBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.service.IndexListService;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.MultiProvider;
import com.gridnine.xtrip.client.fx.core.util.MultiSupplier;
import com.gridnine.xtrip.client.fx.core.util.ValueHolder;
import com.gridnine.xtrip.client.fx.model.profile.StockOrderSpace;
import com.gridnine.xtrip.client.fx.model.profile.StockOrderSpaceController;
import com.gridnine.xtrip.client.fx.model.profile.StockOrderSpaceVM;
import com.gridnine.xtrip.client.fx.model.profile.StockOrderTransferGeneralPanel;
import com.gridnine.xtrip.client.fx.model.profile.StockOrderTransferItemsPanelVM;
import com.gridnine.xtrip.client.fx.model.profile.StockOrderTransferMainPanel;
import com.gridnine.xtrip.client.fx.model.profile.StockOrderTransferReferencesPanel;
import com.gridnine.xtrip.client.fx.model.profile.StockOrderVendorGeneralPanel;
import com.gridnine.xtrip.client.fx.model.profile.StockOrderVendorMainPanel;
import com.gridnine.xtrip.client.fx.model.profile.StockOrderVendorReferencesPanel;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.stockcontrol.controllerinterceptors.StockOrderTransferItemsProvider;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.stockcontrol.controllerinterceptors.StockOrderTransferTileActions;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.stockcontrol.controllerinterceptors.StockOrderVendorTileActions;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.stockcontrol.controllerinterceptors.StocksHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.profile.BaseProfile;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.stockcontrol.StockBlankIndex;
import com.gridnine.xtrip.common.model.stockcontrol.StockOrder;
import com.gridnine.xtrip.common.model.stockcontrol.StockOrderIndex;
import com.gridnine.xtrip.common.model.stockcontrol.StockOrderStatus;
import com.gridnine.xtrip.common.model.stockcontrol.StockOrderType;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.FormattedNumberUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.Node;

public class StockOrderControllerInterceptor
extends ControllerInterceptor<StockOrderSpaceVM, StockOrderSpaceController> {
    private static final MultiSupplier<IndexListParameters<BaseProfile, ?>> SENDER_SUPPLIER = new MultiSupplier<IndexListParameters<BaseProfile, ?>>(){
        private final IndexListParameters<?, ?>[] listParameters = new IndexListParameters[]{ControllerInterceptorsHelper.getAgencies(), ControllerInterceptorsHelper.getActiveSalesPoints(), ControllerInterceptorsHelper.getActiveAgents(), ControllerInterceptorsHelper.getCashRegisterWorkplaces()};

        public String getDisplayName(int idx) {
            return MetaRegistryHelper.getDisplayName((Class)this.listParameters[idx].getIndexType());
        }

        public IndexListParameters<BaseProfile, ?> get(int idx) {
            return this.listParameters[idx];
        }

        public int count() {
            return this.listParameters.length;
        }
    };
    private static final MultiSupplier<IndexListParameters<BaseProfile, ?>> RECEIVER_SUPPLIER = new MultiSupplier<IndexListParameters<BaseProfile, ?>>(){
        private final IndexListParameters<?, ?>[] listParameters = new IndexListParameters[]{ControllerInterceptorsHelper.getAgencies(), ControllerInterceptorsHelper.getActiveSalesPoints(), ControllerInterceptorsHelper.getActiveAgents(), ControllerInterceptorsHelper.getCashRegisterWorkplaces(), ControllerInterceptorsHelper.getBlankOwners()};

        public String getDisplayName(int idx) {
            return MetaRegistryHelper.getDisplayName((Class)this.listParameters[idx].getIndexType());
        }

        public IndexListParameters<BaseProfile, ?> get(int idx) {
            return this.listParameters[idx];
        }

        public int count() {
            return this.listParameters.length;
        }
    };

    protected Class<StockOrderSpaceController> getControllerClass() {
        return StockOrderSpaceController.class;
    }

    protected void onCreate(StockOrderSpaceController controller) {
        StockOrderSpace space = controller.getView();
        space.getHiddenTiles().setAll((Object[])new Tile[]{space.getTransferMainTile(), space.getVendorMainTile()});
        TableWidget tableWidget = (TableWidget)((StockOrderVendorMainPanel)space.getVendorMainTile().getFullNode()).getItemsCard().getContent();
        ComboBoxWidgetColumn blankTypeColumn = (ComboBoxWidgetColumn)tableWidget.getColumn("blankType");
        blankTypeColumn.setConverter(StocksHelper.BLANK_TYPE_CONVERTER);
        blankTypeColumn.setLive(true);
        blankTypeColumn.setAsync(true);
        ((EntityBoxWidgetColumn)tableWidget.getColumn("owner")).setListParametersSupplier(ControllerInterceptorsHelper::getBlankOwners);
        ((EntityBoxWidgetColumn)tableWidget.getColumn("destination")).setListParametersSupplier(SENDER_SUPPLIER);
        tableWidget.setOnRowsAction(event -> {
            if (event.getEventType() == TableRowEvent.ROW_ADD) {
                int row = event.getRowIndex();
                EntityBoxWidget ownerWidget = (EntityBoxWidget)((EntityBoxWidgetColumn)tableWidget.getColumn("owner")).getWidget(row);
                ComboBoxWidget blankTypeWidget = (ComboBoxWidget)((ComboBoxWidgetColumn)tableWidget.getColumn("blankType")).getWidget(row);
                blankTypeWidget.setItemsSupplier(StocksHelper.createBlankTypesSupplier((EntityBoxWidget<Organization>)ownerWidget));
                TextFieldWidget firstNumberWidget = (TextFieldWidget)((TextWidgetColumn)tableWidget.getColumn("firstBlankNumber")).getWidget(row);
                TextFieldWidget lastNumberWidget = (TextFieldWidget)((TextWidgetColumn)tableWidget.getColumn("lastBlankNumber")).getWidget(row);
                LongValueWidget countWidget = (LongValueWidget)((LongValueWidgetColumn)tableWidget.getColumn("blanksCount")).getWidget(row);
                StockOrderControllerInterceptor.configureNumbersWidgets(firstNumberWidget, lastNumberWidget, countWidget);
            }
        });
        ((ComboBoxWidgetColumn)((TableWidget)((StockOrderTransferMainPanel)space.getTransferMainTile().getFullNode()).getItemsCard().getContent()).getColumn("blankType")).setConverter(StocksHelper.BLANK_TYPE_CONVERTER);
        ((TableWidget)((StockOrderTransferMainPanel)controller.getView().getTransferMainTile().getFullNode()).getItemsCard().getContent()).setOnRowsAction(event -> {
            if (event.getEventType() == TableRowEvent.ROW_ADD) {
                TextFieldWidget firstNumberWidget = (TextFieldWidget)((TextWidgetColumn)((TableWidget)((StockOrderTransferMainPanel)controller.getView().getTransferMainTile().getFullNode()).getItemsCard().getContent()).getColumn("firstBlankNumber")).getWidget(event.getRowIndex().intValue());
                TextFieldWidget lastNumberWidget = (TextFieldWidget)((TextWidgetColumn)((TableWidget)((StockOrderTransferMainPanel)controller.getView().getTransferMainTile().getFullNode()).getItemsCard().getContent()).getColumn("lastBlankNumber")).getWidget(event.getRowIndex().intValue());
                LongValueWidget countWidget = (LongValueWidget)((LongValueWidgetColumn)((TableWidget)((StockOrderTransferMainPanel)controller.getView().getTransferMainTile().getFullNode()).getItemsCard().getContent()).getColumn("selectedNumber")).getWidget(event.getRowIndex().intValue());
                StockOrderControllerInterceptor.configureNumbersWidgets(firstNumberWidget, lastNumberWidget, countWidget);
            }
        });
    }

    protected void afterReadData(StockOrderSpaceController controller, StockOrderSpaceVM model) {
        StockOrderSpace space = controller.getView();
        StockOrderType type = (StockOrderType)space.getProperties().get((Object)"stock-order-type");
        if (type == null) {
            EntityContainer container;
            RootEntityPane lookup = RootEntityPane.lookup((Node)controller.getView());
            EntityContainer entityContainer = container = lookup == null ? null : lookup.getData().getContainer();
            if (container != null) {
                type = ((StockOrder)container.getEntity()).getType();
            }
        }
        if (type != null) {
            switch (type) {
                case VENDOR: {
                    StockOrderControllerInterceptor.initializeVendorWidgets(controller);
                    space.getHiddenTiles().setAll((Object[])new Tile[]{space.getTransferMainTile()});
                    controller.getView().expand(controller.getView().getVendorMainTile());
                    break;
                }
                case TRANSFER: {
                    StockOrderControllerInterceptor.initializeTransferWidgets(controller);
                    space.getHiddenTiles().setAll((Object[])new Tile[]{space.getVendorMainTile()});
                    controller.getView().expand(controller.getView().getTransferMainTile());
                    break;
                }
            }
        }
    }

    protected void validateData(StockOrderSpaceController controller, List<Message> messages) {
        if (!controller.getView().getHiddenTiles().contains((Object)controller.getView().getVendorMainTile())) {
            if (((StockOrderVendorGeneralPanel)((StockOrderVendorMainPanel)controller.getView().getVendorMainTile().getFullNode()).getGeneralCard().getContent()).getCreatedNode().getValue() == null) {
                messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.Stock_order_date_required, (Object[])new Object[0]));
            }
            this.validateItems((TableWidget)((StockOrderVendorMainPanel)controller.getView().getVendorMainTile().getFullNode()).getItemsCard().getContent(), messages);
        }
        if (!controller.getView().getHiddenTiles().contains((Object)controller.getView().getTransferMainTile())) {
            if (((StockOrderTransferGeneralPanel)((StockOrderTransferMainPanel)controller.getView().getTransferMainTile().getFullNode()).getGeneralCard().getContent()).getCreatedNode().getValue() == null) {
                messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.Stock_order_date_required, (Object[])new Object[0]));
            }
            this.validateItems((TableWidget)((StockOrderTransferMainPanel)controller.getView().getTransferMainTile().getFullNode()).getItemsCard().getContent(), messages);
            this.validateCountBlank((TableWidget)((StockOrderTransferMainPanel)controller.getView().getTransferMainTile().getFullNode()).getItemsCard().getContent(), messages);
        }
    }

    private void validateItems(TableWidget<?> itemsTable, List<Message> messages) {
        TextWidgetColumn firstNumberCol = (TextWidgetColumn)itemsTable.getColumn("firstBlankNumber");
        TextWidgetColumn lastNumberCol = (TextWidgetColumn)itemsTable.getColumn("lastBlankNumber");
        for (int row = 0; row < itemsTable.getRowsCount(); ++row) {
            if (FormattedNumberUtil.diff((String)((TextFieldWidget)lastNumberCol.getWidget(row)).getValue(), (String)((TextFieldWidget)firstNumberCol.getWidget(row)).getValue()) >= 0L) continue;
            messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.Stock_order_incorrect_blank_numbers, (Object[])new Object[0]));
            return;
        }
    }

    private void validateCountBlank(TableWidget<?> itemsTable, List<Message> messages) {
        TableWidgetColumn selectedNumberCol = itemsTable.getColumn("selectedNumber");
        TableWidgetColumn blanksCountCol = itemsTable.getColumn("blanksCount");
        for (int row = 0; row < itemsTable.getRowsCount(); ++row) {
            if ((Long)((LongValueWidget)selectedNumberCol.getWidget(row)).getValue() <= (Long)((LongValueWidget)blanksCountCol.getWidget(row)).getValue()) continue;
            messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.Stock_order_count_blank_greater_selected_number, (Object[])new Object[0]));
            return;
        }
    }

    private static void initializeVendorWidgets(StockOrderSpaceController controller) {
        Tile mainTile = controller.getView().getVendorMainTile();
        StockOrderVendorGeneralPanel generalPanel = (StockOrderVendorGeneralPanel)((StockOrderVendorMainPanel)mainTile.getFullNode()).getGeneralCard().getContent();
        StockOrderVendorReferencesPanel referencesPanel = (StockOrderVendorReferencesPanel)((StockOrderVendorMainPanel)mainTile.getFullNode()).getReferencesCard().getContent();
        TableWidget itemsTable = (TableWidget)((StockOrderVendorMainPanel)mainTile.getFullNode()).getItemsCard().getContent();
        mainTile.getActions().setAll((Object[])StockOrderVendorTileActions.values());
        boolean registered = generalPanel.getStatusNode().getValue() == StockOrderStatus.REGISTERED;
        itemsTable.getViewState().setNotEditable(registered);
        for (TableWidgetColumn col : itemsTable.getColumns()) {
            col.setNotEditable(Boolean.valueOf(registered));
        }
        generalPanel.getNumberNode().getViewState().setNotEditable(registered);
        generalPanel.getReceiverNode().getViewState().setNotEditable(registered);
        generalPanel.getSupplierNode().getViewState().setNotEditable(registered);
        generalPanel.getCreatedNode().getViewState().setNotEditable(registered);
        generalPanel.getRegistrationDateNode().getViewState().setNotEditable(registered);
        generalPanel.getStatusNode().valueProperty().addListener((obj, oldValue, newValue) -> mainTile.revalidateActions());
        generalPanel.getSupplierNode().setListParametersSupplier(ControllerInterceptorsHelper::getSuppliers);
        generalPanel.getReceiverNode().setListParametersSupplier(ControllerInterceptorsHelper::getAgencies);
        referencesPanel.getBlankTransferOrdersNode().setOnAction(event -> {
            EntityContainer<StockOrder> container = StockOrderControllerInterceptor.findStockOrderContainer(controller);
            if (container != null) {
                List<SearchCriterion> search = StockOrderControllerInterceptor.getTransferSearchCriteria(container);
                StockOrderControllerInterceptor.openBlankTransferOrders(controller, (EntityReference<StockOrder>)container.toReference(), search);
            } else {
                Notifications.get().showFlashNotification(Messages.Save_object, null);
            }
        });
        referencesPanel.getBlanksNode().setOnAction(event -> {
            EntityContainer<StockOrder> container = StockOrderControllerInterceptor.findStockOrderContainer(controller);
            if (container != null) {
                List<SearchCriterion> search = StockOrderControllerInterceptor.getReservationOrderCriteria(container);
                StockOrderControllerInterceptor.openStockBlanks(controller, (EntityReference<StockOrder>)container.toReference(), search, "vendor-stock-blanks-");
            } else {
                Notifications.get().showFlashNotification(Messages.Save_object, null);
            }
        });
    }

    private static void initializeTransferWidgets(StockOrderSpaceController controller) {
        Tile mainTile = controller.getView().getTransferMainTile();
        StockOrderTransferGeneralPanel generalPanel = (StockOrderTransferGeneralPanel)((StockOrderTransferMainPanel)mainTile.getFullNode()).getGeneralCard().getContent();
        StockOrderTransferReferencesPanel referencesPanel = (StockOrderTransferReferencesPanel)((StockOrderTransferMainPanel)mainTile.getFullNode()).getReferencesCard().getContent();
        TableWidget itemsTable = (TableWidget)((StockOrderTransferMainPanel)mainTile.getFullNode()).getItemsCard().getContent();
        mainTile.getActions().setAll((Object[])StockOrderTransferTileActions.values());
        boolean registered = generalPanel.getStatusNode().getValue() == StockOrderStatus.REGISTERED;
        itemsTable.getViewState().setNotEditable(registered);
        for (TableWidgetColumn col : itemsTable.getColumns()) {
            if (col.getId().equals("firstBlankNumber") || col.getId().equals("blanksCount")) continue;
            col.setNotEditable(Boolean.valueOf(registered));
        }
        generalPanel.getNumberNode().getViewState().setNotEditable(registered);
        generalPanel.getReceiverNode().getViewState().setNotEditable(registered);
        generalPanel.getRecieverResponsibleNode().getViewState().setNotEditable(registered);
        generalPanel.getSenderNode().getViewState().setNotEditable(registered);
        generalPanel.getSenderResponsibleNode().getViewState().setNotEditable(registered);
        generalPanel.getCreatedNode().getViewState().setNotEditable(registered);
        generalPanel.getTransferDateNode().getViewState().setNotEditable(registered);
        generalPanel.getStatusNode().valueProperty().addListener((obj, oldValue, newValue) -> mainTile.revalidateActions());
        referencesPanel.getBlankTransferOrdersNode().setOnAction(event -> {
            EntityContainer<StockOrder> container = StockOrderControllerInterceptor.findStockOrderContainer(controller);
            if (container != null) {
                List<SearchCriterion> search = StockOrderControllerInterceptor.getVendorSearchCriteria(container);
                StockOrderControllerInterceptor.openBlankTransferOrders(controller, (EntityReference<StockOrder>)container.toReference(), search);
            } else {
                Notifications.get().showFlashNotification(Messages.Save_object, null);
            }
        });
        referencesPanel.getBlanksNode().setOnAction(event -> {
            EntityContainer<StockOrder> container = StockOrderControllerInterceptor.findStockOrderContainer(controller);
            if (container != null) {
                List<SearchCriterion> search = StockOrderControllerInterceptor.getOrdersCriteria(container);
                StockOrderControllerInterceptor.openStockBlanks(controller, (EntityReference<StockOrder>)container.toReference(), search, "transfer-stock-blanks-");
            } else {
                Notifications.get().showFlashNotification(Messages.Save_object, null);
            }
        });
        generalPanel.getSenderNode().setListParametersSupplier(SENDER_SUPPLIER);
        generalPanel.getReceiverNode().setListParametersSupplier(RECEIVER_SUPPLIER);
        itemsTable.setItemsProvider((MultiProvider)new StockOrderTransferItemsProvider((EntityBoxWidget<BaseProfile>)generalPanel.getSenderNode(), (EntityBoxWidget<BaseProfile>)generalPanel.getReceiverNode(), (TableWidget<StockOrderTransferItemsPanelVM>)itemsTable, (StockOrderTransferMainPanel)mainTile.getFullNode()));
    }

    private static EntityContainer<StockOrder> findStockOrderContainer(StockOrderSpaceController controller) {
        DataTransferPackage dtp = RootEntityPane.lookup((Node)controller.getView()).getData();
        return dtp == null ? null : dtp.getContainer();
    }

    private static List<SearchCriterion> getTransferSearchCriteria(EntityContainer<StockOrder> container) {
        ArrayList<SearchCriterion> search = new ArrayList<SearchCriterion>();
        search.add(SearchCriterion.eq((String)StockOrderIndex.Property.type.name(), (Object)StockOrderType.TRANSFER));
        search.add(SearchCriterion.contains((String)StockOrderIndex.Property.relatedOrders.name(), (Object)container.toReference().getUid()));
        return search;
    }

    private static List<SearchCriterion> getVendorSearchCriteria(EntityContainer<StockOrder> container) {
        ArrayList<SearchCriterion> search = new ArrayList<SearchCriterion>();
        search.add(SearchCriterion.eq((String)StockOrderIndex.Property.type.name(), (Object)StockOrderType.VENDOR));
        search.add(SearchCriterion.in((String)"containerUid", (Object[])((StockOrder)container.getEntity()).getRelatedOrders().stream().map(relatedOrder -> relatedOrder.getUid()).toArray(String[]::new)));
        return search;
    }

    private static List<SearchCriterion> getReservationOrderCriteria(EntityContainer<StockOrder> container) {
        ArrayList<SearchCriterion> search = new ArrayList<SearchCriterion>();
        search.add(SearchCriterion.eq((String)StockBlankIndex.Property.reservationOrder.name(), (Object)container.toReference()));
        return search;
    }

    private static List<SearchCriterion> getOrdersCriteria(EntityContainer<StockOrder> container) {
        ArrayList<SearchCriterion> search = new ArrayList<SearchCriterion>();
        search.add(SearchCriterion.contains((String)StockBlankIndex.Property.orders.name(), (Object)container.toReference().getUid()));
        return search;
    }

    private static void openBlankTransferOrders(StockOrderSpaceController controller, EntityReference<StockOrder> ref, List<SearchCriterion> searchCriteria) {
        IndexListParameters params = new IndexListParameters();
        params.setIndexType(StockOrderIndex.class);
        params.getSortings().put(StockOrderIndex.Property.fullNumber.name(), SortOrder.ASC);
        params.getSearchCriterions().addAll(searchCriteria);
        TableColumnSettings filter = new TableColumnSettings();
        filter.setId(StockOrderIndex.Property.fullNumber.name());
        params.getFilters().add(filter);
        filter = new TableColumnSettings();
        filter.setId(StockOrderIndex.Property.receiver.name());
        params.getFilters().add(filter);
        filter = new TableColumnSettings();
        filter.setId(StockOrderIndex.Property.sender.name());
        params.getFilters().add(filter);
        TableColumnSettings column1 = new TableColumnSettings();
        column1.setId(StockOrderIndex.Property.fullNumber.name());
        params.getColumns().add(column1);
        TableColumnSettings column2 = new TableColumnSettings();
        column2.setId(StockOrderIndex.Property.receiver.name());
        params.getColumns().add(column2);
        TableColumnSettings column3 = new TableColumnSettings();
        column3.setId(StockOrderIndex.Property.sender.name());
        params.getColumns().add(column3);
        IndexListService.get().open("stock-blank-transfer-orders-" + ref.getUid(), ((StockOrderTransferReferencesPanel)((StockOrderTransferMainPanel)controller.getView().getTransferMainTile().getFullNode()).getReferencesCard().getContent()).getBlankTransferOrdersNode().getText() + ' ' + ref, params);
    }

    private static void openStockBlanks(StockOrderSpaceController controller, EntityReference<StockOrder> ref, List<SearchCriterion> searchCriteria, String prefix) {
        IndexListParameters params = new IndexListParameters();
        params.setIndexType(StockBlankIndex.class);
        params.getSortings().put(StockBlankIndex.Property.number.name(), SortOrder.ASC);
        params.getSearchCriterions().addAll(searchCriteria);
        TableColumnSettings filter = new TableColumnSettings();
        filter.setId(StockBlankIndex.Property.number.name());
        params.getFilters().add(filter);
        filter = new TableColumnSettings();
        filter.setId(StockBlankIndex.Property.controlStatus.name());
        params.getFilters().add(filter);
        filter = new TableColumnSettings();
        filter.setId(StockBlankIndex.Property.currentLocation.name());
        params.getFilters().add(filter);
        filter = new TableColumnSettings();
        filter.setId(StockBlankIndex.Property.usageStatus.name());
        params.getFilters().add(filter);
        filter = new TableColumnSettings();
        filter.setId(StockBlankIndex.Property.stockHolder.name());
        params.getFilters().add(filter);
        filter = new TableColumnSettings();
        filter.setId(StockBlankIndex.Property.supplier.name());
        params.getFilters().add(filter);
        filter = new TableColumnSettings();
        filter.setId(StockBlankIndex.Property.owner.name());
        params.getFilters().add(filter);
        TableColumnSettings column1 = new TableColumnSettings();
        column1.setId(StockBlankIndex.Property.number.name());
        params.getColumns().add(column1);
        TableColumnSettings column2 = new TableColumnSettings();
        column2.setId(StockBlankIndex.Property.controlStatus.name());
        params.getColumns().add(column2);
        TableColumnSettings column3 = new TableColumnSettings();
        column3.setId(StockBlankIndex.Property.currentLocation.name());
        params.getColumns().add(column3);
        TableColumnSettings column4 = new TableColumnSettings();
        column4.setId(StockBlankIndex.Property.usageStatus.name());
        params.getColumns().add(column4);
        TableColumnSettings column5 = new TableColumnSettings();
        column5.setId(StockBlankIndex.Property.stockHolder.name());
        params.getColumns().add(column5);
        TableColumnSettings column6 = new TableColumnSettings();
        column6.setId(StockBlankIndex.Property.supplier.name());
        params.getColumns().add(column6);
        TableColumnSettings column7 = new TableColumnSettings();
        column7.setId(StockBlankIndex.Property.owner.name());
        params.getColumns().add(column7);
        IndexListService.get().open(prefix + ref.getUid(), ((StockOrderTransferReferencesPanel)((StockOrderTransferMainPanel)controller.getView().getTransferMainTile().getFullNode()).getReferencesCard().getContent()).getBlanksNode().getText() + ' ' + ref, params);
    }

    private static void configureNumbersWidgets(TextFieldWidget firstNumberWidget, TextFieldWidget lastNumberWidget, LongValueWidget countWidget) {
        ValueHolder changeInProgress = new ValueHolder((Object)Boolean.FALSE);
        firstNumberWidget.valueProperty().addListener((s, o, n) -> {
            if (((Boolean)changeInProgress.get()).booleanValue()) {
                return;
            }
            changeInProgress.set((Object)Boolean.TRUE);
            try {
                if (!TextUtil.isBlank((String)n) && FormattedNumberUtil.isValidNumber((String)n) && TextUtil.isBlank((String)lastNumberWidget.getValue()) && countWidget.getValue() != null && ((Long)countWidget.valueProperty().get()).intValue() != 0) {
                    lastNumberWidget.setValue(FormattedNumberUtil.add((String)firstNumberWidget.getValue(), (long)(((Long)countWidget.valueProperty().get()).intValue() - 1)));
                } else if (!TextUtil.isBlank((String)n) && FormattedNumberUtil.isValidNumber((String)n)) {
                    long count = FormattedNumberUtil.diff((String)lastNumberWidget.getValue(), (String)n);
                    if (count <= 0L) {
                        lastNumberWidget.setValue(firstNumberWidget.getValue());
                        countWidget.setValue((Number)1L);
                    } else {
                        countWidget.setValue((Number)(count + 1L));
                    }
                }
            }
            finally {
                changeInProgress.set((Object)Boolean.FALSE);
            }
        });
        lastNumberWidget.valueProperty().addListener((s, o, n) -> {
            if (((Boolean)changeInProgress.get()).booleanValue()) {
                return;
            }
            changeInProgress.set((Object)Boolean.TRUE);
            try {
                if (!TextUtil.isBlank((String)n) && FormattedNumberUtil.isValidNumber((String)n) && TextUtil.isBlank((String)firstNumberWidget.getValue()) && countWidget.getValue() != null && ((Long)countWidget.getValue()).intValue() > 0) {
                    firstNumberWidget.setValue(FormattedNumberUtil.subtract((String)n, (long)(((Long)countWidget.getValue()).intValue() - 1)));
                } else if (!TextUtil.isBlank((String)n) && FormattedNumberUtil.isValidNumber((String)n)) {
                    long count = FormattedNumberUtil.diff((String)n, (String)firstNumberWidget.getValue());
                    if (count <= 0L) {
                        countWidget.setValue(null);
                    } else {
                        countWidget.setValue((Number)(count + 1L));
                    }
                }
            }
            finally {
                changeInProgress.set((Object)Boolean.FALSE);
            }
        });
        countWidget.valueProperty().addListener((s, o, n) -> {
            if (((Boolean)changeInProgress.get()).booleanValue()) {
                return;
            }
            changeInProgress.set((Object)Boolean.TRUE);
            try {
                if (n.intValue() > 0 && !TextUtil.isBlank((String)firstNumberWidget.getValue())) {
                    lastNumberWidget.setValue(FormattedNumberUtil.add((String)firstNumberWidget.getValue(), (long)(n.intValue() - 1)));
                }
            }
            finally {
                changeInProgress.set((Object)Boolean.FALSE);
            }
        });
    }
}

