/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.stockcontrol.controllerinterceptors;

import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.model.profile.BlankTypeVM;
import com.gridnine.xtrip.common.fx.rpc.DictItem;
import com.gridnine.xtrip.common.fx.rpc.DictQuery;
import com.gridnine.xtrip.common.fx.rpc.DictService;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.dict.BlankCategory;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javafx.util.StringConverter;

class StocksHelper {
    static final StringConverter<BlankTypeVM> BLANK_TYPE_CONVERTER = new StringConverter<BlankTypeVM>(){

        public String toString(BlankTypeVM object) {
            if (object != null && object.getBlankNumber() != null) {
                return object.getBlankNumber();
            }
            if (object != null && object.getBlankTypeReference() != null) {
                String[] result = object.getBlankTypeReference().getCode().split(" ");
                return result[result.length - 1];
            }
            return UiUtil.NULL_TEXT;
        }

        public BlankTypeVM fromString(String string) {
            return null;
        }
    };

    static Supplier<List<BlankTypeVM>> createBlankTypesSupplier(EntityBoxWidget<Organization> ownerWidget) {
        return () -> {
            ArrayList<BlankTypeVM> result = new ArrayList<BlankTypeVM>();
            try {
                DictQuery query = new DictQuery();
                query.getFields().add(BlankType.Property.name.name());
                query.getFields().add(BlankType.Property.blankCategory.name());
                query.getCriterions().add(new DictQuery.SearchCriterion(BlankType.Property.blankOwner.name(), new Object[]{ownerWidget.getValue()}));
                List searchResult = ((DictService)RpcServiceManager.get().getService(DictService.class)).search(ServiceInvocationContext.get(), BlankType.class, query);
                for (DictItem item : searchResult) {
                    BlankCategory category = (BlankCategory)item.getFields().get(BlankType.Property.blankCategory.name());
                    if (category == null || category == BlankCategory.ETICKET) continue;
                    BlankTypeVM blankTypeVM = new BlankTypeVM();
                    blankTypeVM.setBlankNumber((String)item.getFields().get(BlankType.Property.name.name()));
                    blankTypeVM.setBlankTypeReference(item.getReference());
                    result.add(blankTypeVM);
                }
            }
            catch (Exception e) {
                ErrorHandler.handle((Throwable)e);
            }
            return result;
        };
    }

    private StocksHelper() {
    }
}

