/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.system;

import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.model.system.EventNotificationMainPaneVM;
import com.gridnine.xtrip.client.fx.model.system.EventNotificationRecipientVM;
import com.gridnine.xtrip.client.fx.model.system.EventNotificationSpace;
import com.gridnine.xtrip.client.fx.model.system.EventNotificationSpaceController;
import com.gridnine.xtrip.client.fx.model.system.EventNotificationSpaceVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.BaseRootEntityHandler;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.system.EventNotificationSpaceControllerInterceptor;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.system.EventNotification;
import com.gridnine.xtrip.common.model.system.EventNotificationIndex;
import com.gridnine.xtrip.common.model.system.EventNotificationRecipient;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.function.BiConsumer;

public class EventNotificationHandler
extends BaseRootEntityHandler<EventNotification, Void, EventNotificationSpaceVM, EventNotificationSpace> {
    public Class<? extends EntityIndex<?>> getStandardIndexClass() {
        return EventNotificationIndex.class;
    }

    @Override
    protected void configureController(List<BiConsumer<DataTransferPackage<EventNotification, Void>, EventNotificationSpaceVM>> toVM, List<BiConsumer<EventNotificationSpaceVM, DataTransferPackage<EventNotification, Void>>> fromVM) {
        ControllersRegistry.register((ControllerInterceptor)new EventNotificationSpaceControllerInterceptor());
        toVM.add((dtp, vm) -> {
            EventNotification model = (EventNotification)dtp.getContainer().getEntity();
            EventNotificationMainPaneVM notifications = vm.getMainFull().getMain();
            notifications.setActive(model.isActive());
            notifications.setTitle(model.getTitle());
            notifications.setEntityReference(model.getEntityReference());
            notifications.setNeedEmail(model.isNeedEmail());
            notifications.setRepeatOnceYear(model.isRepeatOnceYear());
            notifications.setText(model.getText());
            notifications.setEventDate(DateUtils.asLocalDateTime((Date)model.getEventDate()));
            notifications.setAlarmDate(DateUtils.asLocalDateTime((Date)model.getAlarmDate()));
            VMHelper.transfer(model.getRecipients(), vm.getMainFull().getRecipients(), recipient -> new EventNotificationRecipientVM(), (recipient, recipientVM) -> {
                recipientVM.setProfile(recipient.getProfile());
                recipientVM.setLogin(recipient.getLogin());
                recipientVM.setEmail(recipient.getEmail());
                recipientVM.setName(recipient.getName());
            });
        });
        fromVM.add((vm, dtp) -> {
            EventNotification model = (EventNotification)dtp.getContainer().getEntity();
            EventNotificationMainPaneVM notifications = vm.getMainFull().getMain();
            model.setActive(notifications.isActive());
            model.setTitle(notifications.getTitle());
            model.setEntityReference(notifications.getEntityReference());
            model.setNeedEmail(notifications.isNeedEmail());
            model.setRepeatOnceYear(notifications.isRepeatOnceYear());
            model.setText(notifications.getText());
            model.setEventDate(DateUtils.asDate((LocalDateTime)notifications.getEventDate()));
            model.setAlarmDate(DateUtils.asDate((LocalDateTime)notifications.getAlarmDate()));
            model.setViewingDate(null);
            model.setMailingDate(null);
            VMHelper.transfer(vm.getMainFull().getRecipients(), model.getRecipients(), recipientVM -> new EventNotificationRecipient(), (recipientVM, recipient) -> {
                recipient.setProfile(recipientVM.getProfile());
                recipient.setLogin(recipientVM.getLogin());
                recipient.setEmail(recipientVM.getEmail());
                recipient.setName(recipientVM.getName());
            });
        });
    }

    public Class<EventNotification> getEntityClass() {
        return EventNotification.class;
    }

    public Class<Void> getSupplementClass() {
        return Void.class;
    }

    @Override
    protected ViewController<EventNotificationSpace, EventNotificationSpaceVM> createSpaceController(boolean readonly) {
        return new EventNotificationSpaceController(readonly);
    }

    @Override
    protected EventNotificationSpaceVM createVM() {
        return new EventNotificationSpaceVM();
    }
}

