/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.system.document;

import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.model.system.FilledTemplateDocumentPanelVM;
import com.gridnine.xtrip.client.fx.model.system.FilledTemplateDocumentSpace;
import com.gridnine.xtrip.client.fx.model.system.FilledTemplateDocumentSpaceController;
import com.gridnine.xtrip.client.fx.reports.model.FilledTemplateDocumentSpaceVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.BaseRootEntityHandler;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.system.document.FilledTemplateDocumentControllerInterceptor;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.system.BasicDocumentIndex;
import com.gridnine.xtrip.common.model.system.BinaryData;
import com.gridnine.xtrip.common.model.system.FilledTemplateDocument;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.List;
import java.util.function.BiConsumer;
import javax.imageio.ImageIO;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperPrintManager;
import net.sf.jasperreports.engine.util.JRLoader;

public class FilledTemplateDocumentHandler
extends BaseRootEntityHandler<FilledTemplateDocument, Void, FilledTemplateDocumentSpaceVM, FilledTemplateDocumentSpace> {
    public Class<? extends EntityIndex<?>> getStandardIndexClass() {
        return BasicDocumentIndex.class;
    }

    @Override
    protected void configureController(List<BiConsumer<DataTransferPackage<FilledTemplateDocument, Void>, FilledTemplateDocumentSpaceVM>> toVM, List<BiConsumer<FilledTemplateDocumentSpaceVM, DataTransferPackage<FilledTemplateDocument, Void>>> fromVM) {
        ControllersRegistry.register((ControllerInterceptor)new FilledTemplateDocumentControllerInterceptor());
        toVM.add((dtp, vm) -> {
            FilledTemplateDocument model = (FilledTemplateDocument)dtp.getContainer().getEntity();
            FilledTemplateDocumentPanelVM docVM = vm.getMainFull().getDocument();
            docVM.setTitle(model.getTitle());
            vm.getMainFull().setContent(model.getContent());
            docVM.setDescription(model.getDescription());
            docVM.setFilename(model.getName());
            docVM.setOwner(model.getOwner());
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                JasperPrint jprint = (JasperPrint)JRLoader.loadObject((InputStream)new ByteArrayInputStream(model.getContent()));
                Image image = JasperPrintManager.printPageToImage((JasperPrint)jprint, (int)0, (float)2.0f);
                BufferedImage bi = new BufferedImage(image.getWidth(null), image.getHeight(null), 10);
                bi.createGraphics().drawImage(image, 0, 0, null);
                ImageIO.write((RenderedImage)bi, "png", baos);
                baos.flush();
                BinaryData bd = new BinaryData();
                bd.setData(baos.toByteArray());
                vm.getMainFull().setFile(bd);
            }
            catch (Exception e) {
                ErrorHandler.handle((Throwable)e);
            }
        });
        fromVM.add((vm, dtp) -> {
            FilledTemplateDocument model = (FilledTemplateDocument)dtp.getContainer().getEntity();
            FilledTemplateDocumentPanelVM docVM = vm.getMainFull().getDocument();
            model.setTitle(docVM.getTitle());
            model.setContent(vm.getMainFull().getContent());
            model.setDescription(docVM.getDescription());
            model.setName(docVM.getFilename());
            model.setOwner(docVM.getOwner());
        });
    }

    public Class<FilledTemplateDocument> getEntityClass() {
        return FilledTemplateDocument.class;
    }

    public Class<Void> getSupplementClass() {
        return Void.class;
    }

    @Override
    protected ViewController<FilledTemplateDocumentSpace, FilledTemplateDocumentSpaceVM> createSpaceController(boolean readonly) {
        return new FilledTemplateDocumentSpaceController(readonly);
    }

    @Override
    protected FilledTemplateDocumentSpaceVM createVM() {
        return new FilledTemplateDocumentSpaceVM();
    }
}

