/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.system.document;

import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.Tile;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.TileAction;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.ClientSettings;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.model.system.FilledTemplateDocumentContainer;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.system.document.FilledTemplateDocumentControllerInterceptor;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.system.FilledTemplateDocument;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.stage.FileChooser;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrintManager;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public enum ItineraryReceiptTileActions implements TileAction<Node, FilledTemplateDocumentContainer>
{
    OPEN{

        public String getName(Tile<Node, FilledTemplateDocumentContainer> tl) {
            return Messages.Open;
        }

        public String getDescription(Tile<Node, FilledTemplateDocumentContainer> tl) {
            return Messages.Open_routing_receipt_file;
        }

        public double getWeight() {
            return 1.0;
        }

        public boolean isEnabled(Tile<Node, FilledTemplateDocumentContainer> tl) {
            return true;
        }

        public void execute(Control source, Tile<Node, FilledTemplateDocumentContainer> tl, boolean alt) {
            FilledTemplateDocument doc = (FilledTemplateDocument)RootEntityPane.lookup((Node)tl.getFullNode()).getData().getContainer().getEntity();
            String fileName = 1.checkExtension(doc.getName(), ".pdf");
            fileName = TextUtil.normalizeFileName((String)fileName);
            File file = new File(fileName);
            try {
                FileUtils.writeByteArrayToFile((File)file, (byte[])FilledTemplateDocumentControllerInterceptor.convertMethods.get(FilledTemplateDocumentControllerInterceptor.PDF_FILTER).apply(doc.getContent()));
            }
            catch (Exception e) {
                ErrorHandler.handle((Throwable)e);
                return;
            }
            FxUtil.openFile((File)file);
        }
    }
    ,
    EXPORT{

        public String getName(Tile<Node, FilledTemplateDocumentContainer> tl) {
            return Messages.Upload;
        }

        public String getDescription(Tile<Node, FilledTemplateDocumentContainer> tl) {
            return Messages.Save_routing_receipt_file;
        }

        public double getWeight() {
            return 2.0;
        }

        public boolean isEnabled(Tile<Node, FilledTemplateDocumentContainer> tl) {
            return true;
        }

        public void execute(Control source, Tile<Node, FilledTemplateDocumentContainer> tl, boolean alt) {
            FilledTemplateDocument doc = (FilledTemplateDocument)RootEntityPane.lookup((Node)tl.getFullNode()).getData().getContainer().getEntity();
            try {
                FileChooser fc = new FileChooser();
                File dir = ClientSettings.get().getFileChooserDirectory();
                if (UiUtil.isFileValid((File)dir) && dir.isDirectory()) {
                    fc.setInitialDirectory(dir);
                } else {
                    fc.setInitialDirectory(Environment.getDataFolder());
                }
                String fileName = 2.checkExtension(doc.getName(), ".pdf");
                fc.setInitialFileName(fileName);
                fc.getExtensionFilters().addAll(FilledTemplateDocumentControllerInterceptor.convertMethods.keySet());
                fc.setSelectedExtensionFilter(FilledTemplateDocumentControllerInterceptor.PDF_FILTER);
                File file = fc.showSaveDialog(((FilledTemplateDocumentContainer)tl.getFullNode()).getScene().getWindow());
                if (file != null) {
                    ClientSettings.get().setFileChooserDirectory(file.getParentFile());
                    ClientSettings.get().save();
                    FileUtils.writeByteArrayToFile((File)file, (byte[])FilledTemplateDocumentControllerInterceptor.convertMethods.get(fc.getSelectedExtensionFilter()).apply(doc.getContent()));
                    Notifications.get().showFlashNotification(Messages.Route_receipt_is_saved + file, null);
                }
            }
            catch (Exception e) {
                ErrorHandler.handle((Throwable)e);
            }
        }
    }
    ,
    PRINT{

        public String getName(Tile<Node, FilledTemplateDocumentContainer> tl) {
            return Messages.Print;
        }

        public String getDescription(Tile<Node, FilledTemplateDocumentContainer> tl) {
            return Messages.Print_a_routing_receipt_file;
        }

        public double getWeight() {
            return 3.0;
        }

        public boolean isEnabled(Tile<Node, FilledTemplateDocumentContainer> tl) {
            return true;
        }

        public void execute(Control source, Tile<Node, FilledTemplateDocumentContainer> tl, boolean alt) {
            FilledTemplateDocument doc = (FilledTemplateDocument)RootEntityPane.lookup((Node)tl.getFullNode()).getData().getContainer().getEntity();
            try {
                JasperPrintManager.printReport((InputStream)new ByteArrayInputStream(doc.getContent()), (boolean)true);
            }
            catch (JRException e) {
                ErrorHandler.handle((Throwable)e);
            }
        }
    };


    protected static String checkExtension(String fileName, String defaultExtension) {
        String ext = FilenameUtils.getExtension((String)fileName);
        if (!TextUtil.isBlank((String)ext) && !TextUtil.isBlank((String)defaultExtension) && fileName.length() > ext.length() + 1) {
            return fileName.substring(0, fileName.length() - ext.length() - 1) + defaultExtension;
        }
        if (!TextUtil.isBlank((String)defaultExtension)) {
            return fileName + defaultExtension;
        }
        return fileName;
    }
}

