/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.navtool;

import com.gridnine.xtrip.client.fx.core.devtools.api.DevTool;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevToolItem;
import com.gridnine.xtrip.client.fx.core.entity.EntityIndexHandler;
import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SimpleSuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.CardAction;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.StandardTableWidgetCoordinator;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableRowEvent;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.ComboBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.TextWidgetColumn;
import com.gridnine.xtrip.client.fx.core.ui.navigation.NavTool;
import com.gridnine.xtrip.client.fx.core.ui.navigation.NavToolEditor;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.standard.entity.navtool.IndexListNavToolData;
import com.gridnine.xtrip.client.fx.standard.entity.navtool.IndexListNavToolHelper;
import com.gridnine.xtrip.client.fx.standard.entity.navtool.MetaField;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.assets.FxWorkspaceItem;
import com.gridnine.xtrip.common.meta.IndexCollection;
import com.gridnine.xtrip.common.meta.IndexProperty;
import com.gridnine.xtrip.common.meta.IndexType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.layout.StackPane;
import javafx.util.StringConverter;

abstract class IndexListNavToolColumnSettingsEditor
extends StackPane
implements NavToolEditor,
DevTool {
    static final CardAction<Node> RESET_ACTION = new CardAction<Node>(){

        public boolean isEnabled(Card<Node> card) {
            return true;
        }

        public double getWeight() {
            return 0.0;
        }

        public String getName(Card<Node> card) {
            return Messages.Reset;
        }

        public String getDescription(Card<Node> card) {
            return Messages.Restore_default_settings;
        }

        public void execute(Card<Node> card, boolean alt) {
            ((IndexListNavToolColumnSettingsEditor)card.getContent()).reset();
        }
    };
    final TableWidgetController<TableWidget<TableColumnSettingsWrapper>, TableColumnSettingsWrapper> tableController;
    IndexType indexType;

    IndexListNavToolColumnSettingsEditor() {
        final TableWidget<TableColumnSettingsWrapper> tableWidget = this.createTableWidget();
        this.tableController = new TableWidgetController<TableWidget<TableColumnSettingsWrapper>, TableColumnSettingsWrapper>(){

            public TableWidget<TableColumnSettingsWrapper> getView() {
                return tableWidget;
            }
        };
        this.getChildren().setAll((Object[])new Node[]{tableWidget});
        ((TableWidget)this.tableController.getView()).setOnRowsAction(event -> {
            if (event.getEventType() != TableRowEvent.ROW_ADD) {
                return;
            }
            ComboBoxWidgetColumn fieldColumn = (ComboBoxWidgetColumn)((TableWidget)this.tableController.getView()).getColumn("field");
            TextFieldWidget aliasWidget = (TextFieldWidget)((TextWidgetColumn)((TableWidget)this.tableController.getView()).getColumn("alias")).getWidget(event.getRowIndex().intValue());
            ((ComboBoxWidget)fieldColumn.getWidget(event.getRowIndex().intValue())).valueProperty().addListener((observable, oldValue, newValue) -> aliasWidget.setValue(newValue != null ? newValue.getName() : null));
        });
    }

    private TableWidget<TableColumnSettingsWrapper> createTableWidget() {
        TableWidget result = new TableWidget(false);
        result.setPlaceholder(Messages.No_data);
        result.setControlButtonsAvailability(ControlsPane.ADD_REMOVE_REORDERING);
        result.setControlButtonsCoordinator((BiPredicate)new StandardTableWidgetCoordinator(result){

            public boolean test(ControlsPane.ButtonType buttonType, Integer rowNumber) {
                if (buttonType == ControlsPane.ButtonType.ADD) {
                    return IndexListNavToolHelper.getAvailableFields(IndexListNavToolColumnSettingsEditor.this.indexType, IndexListNavToolColumnSettingsEditor.this.getIndexPropertyFilter(), IndexListNavToolColumnSettingsEditor.this.getIndexCollectionFilter()).size() > ((TableWidget)IndexListNavToolColumnSettingsEditor.this.tableController.getView()).getRowsCount();
                }
                return super.test(buttonType, rowNumber);
            }
        });
        result.setItemsProvider(() -> new TableColumnSettingsWrapper());
        ArrayList<ComboBoxWidgetColumn> columns = new ArrayList<ComboBoxWidgetColumn>();
        ComboBoxWidgetColumn column = new ComboBoxWidgetColumn(settings -> settings.field, (settings, value) -> {
            settings.field = value;
        });
        column.setNoNulls(true);
        column.setLive(true);
        column.setItemsSupplier(() -> {
            if (this.indexType == null) {
                return Collections.emptyList();
            }
            Set<String> usedFields = this.getUsedFields();
            return IndexListNavToolHelper.getAvailableFields(this.indexType, this.getIndexPropertyFilter(), this.getIndexCollectionFilter()).stream().filter(item -> !usedFields.contains(item.getId())).collect(Collectors.toList());
        });
        column.setConverter((StringConverter)new StringConverter<MetaField>(){

            public String toString(MetaField object) {
                return object != null ? object.getName() : UiUtil.NULL_TEXT;
            }

            public MetaField fromString(String string) {
                return null;
            }
        });
        column.setCaption(Messages.Name);
        column.setId("field");
        column.setPrefWidth(Double.valueOf(50.0));
        column.setSuggestionsHandler((SuggestionsHandler)new SimpleSuggestionsHandler(column.getConverter(), column.getItemsSupplier(), column.isSortItems()));
        columns.add(column);
        column = new TextWidgetColumn(settings -> settings.allias, (settings, value) -> {
            settings.allias = value;
        });
        column.setCaption(Messages.Display_title);
        column.setId("alias");
        columns.add(column);
        result.setColumns(columns);
        return result;
    }

    private Set<String> getUsedFields() {
        ComboBoxWidgetColumn column = (ComboBoxWidgetColumn)((TableWidget)this.tableController.getView()).getColumn("field");
        HashSet<String> result = new HashSet<String>();
        for (int i = 0; i < ((TableWidget)this.tableController.getView()).getRowsCount(); ++i) {
            ComboBoxWidget indexFieldComboBox = (ComboBoxWidget)column.getWidget(i);
            MetaField value = (MetaField)indexFieldComboBox.getValue();
            if (value == null) continue;
            result.add(((MetaField)indexFieldComboBox.getValue()).getId());
        }
        return result;
    }

    private Collection<TableColumnSettingsWrapper> wrap(List<TableColumnSettings> settingsList) {
        if (this.indexType == null) {
            return Collections.emptyList();
        }
        ArrayList<TableColumnSettingsWrapper> result = new ArrayList<TableColumnSettingsWrapper>();
        Map<String, MetaField> fields = IndexListNavToolHelper.getAvailableFields(this.indexType, this.getIndexPropertyFilter(), this.getIndexCollectionFilter()).stream().collect(Collectors.toMap(value -> value.getId(), value -> value));
        for (TableColumnSettings settings : settingsList) {
            MetaField field = fields.get(settings.getId());
            if (field == null) continue;
            TableColumnSettingsWrapper wrapper = new TableColumnSettingsWrapper();
            wrapper.field = field;
            wrapper.allias = settings.getDisplayName() != null ? settings.getDisplayName() : field.getName();
            result.add(wrapper);
        }
        return result;
    }

    private Collection<TableColumnSettings> unwrap(List<TableColumnSettingsWrapper> wrappersList) {
        if (this.indexType == null) {
            return Collections.emptyList();
        }
        ArrayList<TableColumnSettings> result = new ArrayList<TableColumnSettings>();
        Set fieldIds = IndexListNavToolHelper.getAvailableFields(this.indexType, this.getIndexPropertyFilter(), this.getIndexCollectionFilter()).stream().map(value -> value.getId()).collect(Collectors.toSet());
        for (TableColumnSettingsWrapper wrapper : wrappersList) {
            if (wrapper.field == null || !fieldIds.contains(wrapper.field.getId())) continue;
            TableColumnSettings settings = new TableColumnSettings();
            settings.setId(wrapper.field.getId());
            settings.setDisplayName(!TextUtil.isSame((String)wrapper.allias, (String)wrapper.field.getName()) ? wrapper.allias : null);
            result.add(settings);
        }
        return result;
    }

    public boolean isDataChanged() {
        return this.tableController.isDataChanged();
    }

    public void readData(FxWorkspaceItem item) {
        NavTool tool = NavTool.forId((String)item.getToolId());
        try {
            IndexListNavToolData data = (IndexListNavToolData)tool.cleanParameters(tool.getSerializer().deserialize(item.getParameters()));
            if (data != null) {
                this.indexType = data.getIndexType() != null ? (IndexType)MetaRegistry.get().getIndexes().get(data.getIndexType().getName()) : null;
                this.tableController.readData(this.wrap(this.getSettings(data)));
            } else {
                this.tableController.readData(Collections.emptyList());
            }
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
            this.tableController.readData(Collections.emptyList());
        }
    }

    public void writeData(FxWorkspaceItem item) {
        NavTool tool = NavTool.forId((String)item.getToolId());
        try {
            IndexListNavToolData data;
            IndexListNavToolData indexListNavToolData = data = item.getParameters() != null ? (IndexListNavToolData)tool.cleanParameters(tool.getSerializer().deserialize(item.getParameters())) : (IndexListNavToolData)tool.createParameters();
            if (data != null) {
                ArrayList<TableColumnSettingsWrapper> tableColumnSettingWrappers = new ArrayList<TableColumnSettingsWrapper>();
                this.tableController.writeData(tableColumnSettingWrappers);
                this.getSettings(data).clear();
                this.getSettings(data).addAll(this.unwrap(tableColumnSettingWrappers));
                item.setParameters(tool.getSerializer().serialize((Object)data));
            }
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
    }

    protected void reset() {
        EntityIndexHandler handler;
        if (this.indexType == null) {
            return;
        }
        try {
            handler = EntityIndexHandler.forIndexClass((Class)XSHelper.getClass((String)this.indexType.getId()));
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
            return;
        }
        if (handler == null) {
            return;
        }
        this.tableController.readData(this.wrap(this.getDefaultSettings(handler.createListParameters())));
    }

    public DevToolItem asDevToolItem() {
        return new DevToolItem(){

            public Collection<?> getSubItems() {
                return Collections.singleton(IndexListNavToolColumnSettingsEditor.this.tableController.getView());
            }

            public String getInfo() {
                return ((Object)((Object)IndexListNavToolColumnSettingsEditor.this)).getClass().getSimpleName();
            }
        };
    }

    abstract List<TableColumnSettings> getSettings(IndexListNavToolData var1);

    abstract List<TableColumnSettings> getDefaultSettings(IndexListParameters<?, ?> var1);

    abstract Predicate<IndexProperty> getIndexPropertyFilter();

    abstract Predicate<IndexCollection> getIndexCollectionFilter();

    private static class TableColumnSettingsWrapper {
        MetaField field;
        String allias;

        TableColumnSettingsWrapper() {
        }
    }
}

