/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.navtool;

import com.gridnine.xtrip.common.meta.IndexCollection;
import com.gridnine.xtrip.common.meta.IndexProperty;
import com.gridnine.xtrip.common.xml.XSHelper;

class MetaField {
    private final String id;
    private final String name;
    private final String description;
    private final Class<?> type;

    private static Class<?> getType(String typeName) {
        Class result = MetaField.resolveStandardType(typeName);
        if (result == null) {
            try {
                if (typeName.contains("||")) {
                    String[] classNames = typeName.split("[|]{2}");
                    result = XSHelper.getClass((String)classNames[1]);
                } else {
                    result = XSHelper.getClass((String)typeName);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return result;
    }

    private static Class<?> resolveStandardType(String typeName) {
        if ("String".equals(typeName) || "text".equals(typeName)) {
            return String.class;
        }
        if ("boolean".equals(typeName) || "Boolean".equals(typeName)) {
            return Boolean.class;
        }
        if ("byte".equals(typeName) || "Byte".equals(typeName)) {
            return Byte.class;
        }
        if ("char".equals(typeName) || "Character".equals(typeName)) {
            return Character.class;
        }
        if ("short".equals(typeName) || "Short".equals(typeName)) {
            return Short.class;
        }
        if ("int".equals(typeName) || "Integer".equals(typeName)) {
            return Integer.class;
        }
        if ("long".equals(typeName) || "Long".equals(typeName)) {
            return Long.class;
        }
        if ("float".equals(typeName) || "Float".equals(typeName)) {
            return Float.class;
        }
        if ("double".equals(typeName) || "Double".equals(typeName)) {
            return Double.class;
        }
        return null;
    }

    MetaField(IndexProperty property) {
        this.id = property.getId();
        this.name = property.getDisplayName();
        this.description = property.getDescription();
        this.type = MetaField.getType(property.getType());
    }

    MetaField(IndexCollection collection) {
        this.id = collection.getId();
        this.name = collection.getDisplayName();
        this.description = collection.getDescription();
        this.type = MetaField.getType(collection.getElementType());
    }

    String getId() {
        return this.id;
    }

    String getName() {
        return this.name;
    }

    String getDescription() {
        return this.description;
    }

    Class<?> getType() {
        return this.type;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MetaField)) {
            return false;
        }
        return this.id != null ? this.id.equals(((MetaField)object).id) : false;
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }
}

