/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.factory.basic;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.factory.FactoryTool;
import com.gridnine.xtrip.client.fx.core.factory.FactoryToolCategory;
import com.gridnine.xtrip.client.fx.core.lib.widgets.navigator.CompactNavigatorWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.navigator.NavigatorViewType;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.service.RootEntityEditingService;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductMCOFeesCreationPanelController;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductMCOFeesCreationPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductsFullPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpaceController;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors.BookingFileSpaceControllerInterceptorHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.ProductFXHandler;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.AdditionalServiceProductFXHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.AeroexpressTicketFXHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.AgencyMemoProductFXHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.AirProductFXHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.CarRentalProductFXHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.DeliveryFXHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.InsuranceAccidentFXHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.InsuranceTouristicFXHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.TaxiFXHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.TransferFXHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.VisaProductFXHelper;
import com.gridnine.xtrip.client.fx.standard.factory.StandardCategories;
import com.gridnine.xtrip.client.fx.standard.factory.basic.StandardHotelCreateProcedure;
import com.gridnine.xtrip.client.fx.standard.helpers.CreateBookingHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.AeroexpressTicket;
import com.gridnine.xtrip.common.model.booking.MCOFees;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.additionalservice.AdditionalServiceProduct;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProduct;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.uidata.AeroexpressTicketUIData;
import com.gridnine.xtrip.common.model.booking.air.uidata.AirProductUIData;
import com.gridnine.xtrip.common.model.booking.carrental.CarRentalProduct;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccident;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceTouristic;
import com.gridnine.xtrip.common.model.booking.taxi.TaxiProduct;
import com.gridnine.xtrip.common.model.booking.transfers.Transfer;
import com.gridnine.xtrip.common.model.booking.uidata.AdditionalServiceProductUIData;
import com.gridnine.xtrip.common.model.booking.uidata.AgencyMemoProductUIData;
import com.gridnine.xtrip.common.model.booking.uidata.CarRentalProductUIData;
import com.gridnine.xtrip.common.model.booking.uidata.DeliveryUIData;
import com.gridnine.xtrip.common.model.booking.uidata.InsuranceUIData;
import com.gridnine.xtrip.common.model.booking.uidata.TaxiProductUIData;
import com.gridnine.xtrip.common.model.booking.uidata.TransferProductXtripUIData;
import com.gridnine.xtrip.common.model.booking.uidata.VisaProductUIData;
import com.gridnine.xtrip.common.model.booking.visa.VisaProduct;
import com.gridnine.xtrip.common.model.delivery.Delivery;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.restriction.resource.ModelRestrictionEntityResources;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.ReflectionUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import javafx.beans.binding.BooleanExpression;
import javafx.scene.Node;

enum BookingFactoryTools implements FactoryTool
{
    AEROEXPRESS{

        public String getName() {
            return Messages.Aeroexpress;
        }

        public double getWeight() {
            return 30.0;
        }

        public void execute() {
            CreateBookingHelper.createBookingFile((bookingFile, bookingFileSupplementData, parameters) -> {
                MiscUtil.Pair<AeroexpressTicket, AeroexpressTicketUIData> prototypeData = AeroexpressTicketFXHelper.getPrototypeData();
                AeroexpressTicket product = (AeroexpressTicket)prototypeData.getFirst();
                AeroexpressTicketUIData productSupplementData = (AeroexpressTicketUIData)prototypeData.getSecond();
                Reservation reservation = (Reservation)bookingFile.getReservations().get(0);
                reservation.getProducts().add(product);
                product.setReservation(reservation);
                bookingFileSupplementData.getProducts().add(productSupplementData);
            }, false);
        }

        public AclQuery getACLQuery() {
            return new AclQuery(StandardRestrictionResourceOperations.CREATE.getId(), ModelRestrictionEntityResources.ENTITY_PRODUCT.getId());
        }
    }
    ,
    AGENCY_MEMO{

        public String getName() {
            return Messages.Agency_memo_product;
        }

        public double getWeight() {
            return 120.0;
        }

        public void execute() {
            CreateBookingHelper.createBookingFile((bookingFile, bookingFileSupplementData, parameters) -> {
                MiscUtil.Pair<AgencyMemoProduct, AgencyMemoProductUIData> prototypeData = AgencyMemoProductFXHelper.getPrototypeData();
                AgencyMemoProduct product = (AgencyMemoProduct)prototypeData.getFirst();
                AgencyMemoProductUIData productSupplementData = (AgencyMemoProductUIData)prototypeData.getSecond();
                Reservation reservation = (Reservation)bookingFile.getReservations().get(0);
                reservation.getProducts().add(product);
                product.setReservation(reservation);
                bookingFileSupplementData.getProducts().add(productSupplementData);
            }, false);
        }

        public AclQuery getACLQuery() {
            return new AclQuery(StandardRestrictionResourceOperations.CREATE.getId(), ModelRestrictionEntityResources.ENTITY_PRODUCT.getId());
        }
    }
    ,
    AIR_TICKET{

        public String getName() {
            return Messages.Air_ticket;
        }

        public double getWeight() {
            return 10.0;
        }

        public void execute() {
            CreateBookingHelper.createBookingFile((bookingFile, bookingFileSupplementData, parameters) -> {
                MiscUtil.Pair<Product, AirProductUIData> prototypeData = AirProductFXHelper.getPrototypeData(ProductCategory.AIR);
                Product product = (Product)prototypeData.getFirst();
                AirProductUIData productSupplementData = (AirProductUIData)prototypeData.getSecond();
                Reservation reservation = (Reservation)bookingFile.getReservations().get(0);
                reservation.getProducts().add(product);
                product.setReservation(reservation);
                bookingFileSupplementData.getProducts().add(productSupplementData);
            }, false);
        }

        public AclQuery getACLQuery() {
            return new AclQuery(StandardRestrictionResourceOperations.CREATE.getId(), ModelRestrictionEntityResources.ENTITY_PRODUCT.getId());
        }
    }
    ,
    AVIA_EMD{

        public String getName() {
            return Messages.Air_EMD;
        }

        public double getWeight() {
            return 20.0;
        }

        public void execute() {
            CreateBookingHelper.createBookingFile((bookingFile, bookingFileSupplementData, parameters) -> {
                MiscUtil.Pair<Product, AirProductUIData> prototypeData = AirProductFXHelper.getPrototypeData(ProductCategory.MCO);
                Product product = (Product)prototypeData.getFirst();
                AirProductUIData productSupplementData = (AirProductUIData)prototypeData.getSecond();
                Reservation reservation = (Reservation)bookingFile.getReservations().get(0);
                reservation.getProducts().add(product);
                product.setReservation(reservation);
                bookingFileSupplementData.getProducts().add(productSupplementData);
            }, false);
        }

        public AclQuery getACLQuery() {
            return new AclQuery(StandardRestrictionResourceOperations.CREATE.getId(), ModelRestrictionEntityResources.ENTITY_PRODUCT.getId());
        }
    }
    ,
    EXCESS_BAGGAGE{

        public String getName() {
            return Messages.Baggage_check;
        }

        public double getWeight() {
            return 40.0;
        }

        public void execute() {
            CreateBookingHelper.createBookingFile((bookingFile, bookingFileSupplementData, parameters) -> {
                MiscUtil.Pair<Product, AirProductUIData> prototypeData = AirProductFXHelper.getPrototypeData(ProductCategory.EXCESS_BAGAGE);
                Product product = (Product)prototypeData.getFirst();
                AirProductUIData productSupplementData = (AirProductUIData)prototypeData.getSecond();
                Reservation reservation = (Reservation)bookingFile.getReservations().get(0);
                reservation.getProducts().add(product);
                product.setReservation(reservation);
                bookingFileSupplementData.getProducts().add(productSupplementData);
            }, false);
        }

        public AclQuery getACLQuery() {
            return new AclQuery(StandardRestrictionResourceOperations.CREATE.getId(), ModelRestrictionEntityResources.ENTITY_PRODUCT.getId());
        }
    }
    ,
    CAR_RENTAL_PRODUCT{

        public String getName() {
            return Messages.Car_rent;
        }

        public double getWeight() {
            return 30.0;
        }

        public void execute() {
            CreateBookingHelper.createBookingFile((bookingFile, bookingFileSupplementData, parameters) -> {
                MiscUtil.Pair<CarRentalProduct, CarRentalProductUIData> prototypeData = CarRentalProductFXHelper.getPrototypeData();
                CarRentalProduct product = (CarRentalProduct)prototypeData.getFirst();
                CarRentalProductUIData productSupplementData = (CarRentalProductUIData)prototypeData.getSecond();
                Reservation reservation = (Reservation)bookingFile.getReservations().get(0);
                reservation.getProducts().add(product);
                product.setReservation(reservation);
                bookingFileSupplementData.getProducts().add(productSupplementData);
            }, false);
        }

        public AclQuery getACLQuery() {
            return new AclQuery(StandardRestrictionResourceOperations.CREATE.getId(), ModelRestrictionEntityResources.ENTITY_PRODUCT.getId());
        }
    }
    ,
    DELIVERY{

        public String getName() {
            return Messages.Delivery;
        }

        public double getWeight() {
            return 50.0;
        }

        public void execute() {
            CreateBookingHelper.createBookingFile((bookingFile, bookingFileSupplementData, parameters) -> {
                MiscUtil.Pair<Delivery, DeliveryUIData> prototypeData = DeliveryFXHelper.getPrototypeData();
                Delivery product = (Delivery)prototypeData.getFirst();
                DeliveryUIData productSupplementData = (DeliveryUIData)prototypeData.getSecond();
                Reservation reservation = (Reservation)bookingFile.getReservations().get(0);
                reservation.getProducts().add(product);
                product.setReservation(reservation);
                bookingFileSupplementData.getProducts().add(productSupplementData);
            }, false);
        }

        public AclQuery getACLQuery() {
            return new AclQuery(StandardRestrictionResourceOperations.CREATE.getId(), ModelRestrictionEntityResources.ENTITY_PRODUCT.getId());
        }
    }
    ,
    HOTEL{

        public String getName() {
            return Messages.Hotel_reservation;
        }

        public double getWeight() {
            return 130.0;
        }

        public void execute() {
            Runnable proc = (Runnable)ReflectionUtil.createBySystemPropertyName((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)"client.fx.hotel_booking_create_procedure.class", null, StandardHotelCreateProcedure::new);
            proc.run();
        }

        public AclQuery getACLQuery() {
            return new AclQuery(StandardRestrictionResourceOperations.CREATE.getId(), ModelRestrictionEntityResources.ENTITY_PRODUCT.getId());
        }
    }
    ,
    INSURANCE_ACCIDENT{

        public String getName() {
            return Messages.Accident_insurance;
        }

        public double getWeight() {
            return 130.0;
        }

        public void execute() {
            CreateBookingHelper.createBookingFile((bookingFile, bookingFileSupplementData, parameters) -> {
                MiscUtil.Pair<InsuranceAccident, InsuranceUIData> prototypeData = InsuranceAccidentFXHelper.getPrototypeData();
                InsuranceAccident product = (InsuranceAccident)prototypeData.getFirst();
                InsuranceUIData productSupplementData = (InsuranceUIData)prototypeData.getSecond();
                Reservation reservation = (Reservation)bookingFile.getReservations().get(0);
                reservation.getProducts().add(product);
                product.setReservation(reservation);
                bookingFileSupplementData.getProducts().add(productSupplementData);
            }, false);
        }

        public AclQuery getACLQuery() {
            return new AclQuery(StandardRestrictionResourceOperations.CREATE.getId(), ModelRestrictionEntityResources.ENTITY_PRODUCT.getId());
        }
    }
    ,
    INSURANCE_TOURISTIC{

        public String getName() {
            return Messages.Travel_insurance;
        }

        public double getWeight() {
            return 140.0;
        }

        public void execute() {
            CreateBookingHelper.createBookingFile((bookingFile, bookingFileSupplementData, parameters) -> {
                MiscUtil.Pair<InsuranceTouristic, InsuranceUIData> prototypeData = InsuranceTouristicFXHelper.getPrototypeData();
                InsuranceTouristic product = (InsuranceTouristic)prototypeData.getFirst();
                InsuranceUIData productSupplementData = (InsuranceUIData)prototypeData.getSecond();
                Reservation reservation = (Reservation)bookingFile.getReservations().get(0);
                reservation.getProducts().add(product);
                product.setReservation(reservation);
                bookingFileSupplementData.getProducts().add(productSupplementData);
            }, false);
        }

        public AclQuery getACLQuery() {
            return new AclQuery(StandardRestrictionResourceOperations.CREATE.getId(), ModelRestrictionEntityResources.ENTITY_PRODUCT.getId());
        }
    }
    ,
    TRANSFER{

        public String getName() {
            return Messages.Transfer;
        }

        public double getWeight() {
            return 30.0;
        }

        public void execute() {
            CreateBookingHelper.createBookingFile((bookingFile, bookingFileSupplementData, parameters) -> {
                MiscUtil.Pair<Transfer, TransferProductXtripUIData> prototypeData = TransferFXHelper.getPrototypeData();
                Transfer product = (Transfer)prototypeData.getFirst();
                TransferProductXtripUIData productSupplementData = (TransferProductXtripUIData)prototypeData.getSecond();
                Reservation reservation = (Reservation)bookingFile.getReservations().get(0);
                reservation.getProducts().add(product);
                product.setReservation(reservation);
                bookingFileSupplementData.getProducts().add(productSupplementData);
            }, false);
        }

        public AclQuery getACLQuery() {
            return new AclQuery(StandardRestrictionResourceOperations.CREATE.getId(), ModelRestrictionEntityResources.ENTITY_PRODUCT.getId());
        }
    }
    ,
    TAXI{

        public String getName() {
            return Messages.Taxi;
        }

        public double getWeight() {
            return 30.0;
        }

        public void execute() {
            CreateBookingHelper.createBookingFile((bookingFile, bookingFileSupplementData, parameters) -> {
                MiscUtil.Pair<TaxiProduct, TaxiProductUIData> prototypeData = TaxiFXHelper.getPrototypeData();
                TaxiProduct product = (TaxiProduct)prototypeData.getFirst();
                TaxiProductUIData productSupplementData = (TaxiProductUIData)prototypeData.getSecond();
                Reservation reservation = (Reservation)bookingFile.getReservations().get(0);
                reservation.getProducts().add(product);
                product.setReservation(reservation);
                bookingFileSupplementData.getProducts().add(productSupplementData);
            }, false);
        }

        public AclQuery getACLQuery() {
            return new AclQuery(StandardRestrictionResourceOperations.CREATE.getId(), ModelRestrictionEntityResources.ENTITY_PRODUCT.getId());
        }
    }
    ,
    VISA_PRODUCT{

        public String getName() {
            return Messages.Visa;
        }

        public double getWeight() {
            return 30.0;
        }

        public void execute() {
            CreateBookingHelper.createBookingFile((bookingFile, bookingFileSupplementData, parameters) -> {
                MiscUtil.Pair<VisaProduct, VisaProductUIData> prototypeData = VisaProductFXHelper.getPrototypeData();
                VisaProduct product = (VisaProduct)prototypeData.getFirst();
                VisaProductUIData productSupplementData = (VisaProductUIData)prototypeData.getSecond();
                Reservation reservation = (Reservation)bookingFile.getReservations().get(0);
                reservation.getProducts().add(product);
                product.setReservation(reservation);
                bookingFileSupplementData.getProducts().add(productSupplementData);
            }, false);
        }

        public AclQuery getACLQuery() {
            return new AclQuery(StandardRestrictionResourceOperations.CREATE.getId(), ModelRestrictionEntityResources.ENTITY_PRODUCT.getId());
        }
    }
    ,
    ADDITIONAL_SERVICE_PRODUCT{

        public String getName() {
            return Messages.Additional_service;
        }

        public double getWeight() {
            return 30.0;
        }

        public void execute() {
            CreateBookingHelper.createBookingFile((bookingFile, bookingFileSupplementData, parameters) -> {
                MiscUtil.Pair<AdditionalServiceProduct, AdditionalServiceProductUIData> prototypeData = AdditionalServiceProductFXHelper.getPrototypeData();
                AdditionalServiceProduct product = (AdditionalServiceProduct)prototypeData.getFirst();
                AdditionalServiceProductUIData productSupplementData = (AdditionalServiceProductUIData)prototypeData.getSecond();
                Reservation reservation = (Reservation)bookingFile.getReservations().get(0);
                reservation.getProducts().add(product);
                product.setReservation(reservation);
                bookingFileSupplementData.getProducts().add(productSupplementData);
            }, false);
        }

        public AclQuery getACLQuery() {
            return new AclQuery(StandardRestrictionResourceOperations.CREATE.getId(), ModelRestrictionEntityResources.ENTITY_PRODUCT.getId());
        }
    }
    ,
    BOOKING_FILE{

        public String getName() {
            return Messages.Order;
        }

        public double getWeight() {
            return 90.0;
        }

        public void execute() {
            CreateBookingHelper.createBookingFile((bf, bookingFileUiData, parameters) -> {}, false);
        }

        public AclQuery getACLQuery() {
            return new AclQuery(StandardRestrictionResourceOperations.CREATE.getId(), ModelRestrictionEntityResources.ENTITY_BOOKING_FILE.getId());
        }
    }
    ,
    MCO_FEES{

        public String getName() {
            return Messages.MCOFees;
        }

        public double getWeight() {
            return 0.0;
        }

        public void execute() {
            BookingFileProductMCOFeesCreationPanelController controller = new BookingFileProductMCOFeesCreationPanelController(false);
            BookingFileProductMCOFeesCreationPanelVM model = new BookingFileProductMCOFeesCreationPanelVM();
            new Dialog().setTitle(Messages.MCOFees).setBody((Node)controller.getView()).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Create, () -> {
                controller.writeData(model);
                EntityReference bookingFileRef = model.getBookingFile();
                Objects.requireNonNull(RootEntityEditingService.get()).open(bookingFileRef, true, rep -> {
                    BookingFileSpaceController bookingController = (BookingFileSpaceController)rep.getEditor().getProperties().get((Object)"controller");
                    Optional.ofNullable(((CompactNavigatorWidget)bookingController.getProductsFull().getContent().getView()).getSelectedView()).ifPresent(selectedView -> selectedView.getProperties().put((Object)"select-product", (Object)false));
                    Collection viewTypes = Optional.ofNullable(ClientRegistry.get().allOf(ProductFXHandler.TYPE).get(MCOFees.class.getName())).map(item -> BookingFileSpaceControllerInterceptorHelper.createViewType(bookingController, item)).orElse(Collections.emptyList());
                    if (viewTypes.size() > 0) {
                        bookingController.getView().expand(bookingController.getView().getProductsTile());
                        ((CompactNavigatorWidget)((BookingFileProductsFullPanel)bookingController.getView().getProductsTile().getFullNode()).getContent()).createView(null, (NavigatorViewType)viewTypes.iterator().next());
                    }
                });
            }, (BooleanExpression)controller.getView().getBookingFileNode().valueProperty().isNotNull()).showGlobal();
        }

        public AclQuery getACLQuery() {
            return AclQuery.AclQueryBuilder.get().entry(StandardRestrictionResourceOperations.CREATE.getId(), ModelRestrictionEntityResources.ENTITY_PRODUCT.getId()).build();
        }
    };


    public String getUid() {
        return "booking-tools:" + this.name();
    }

    public FactoryToolCategory getCategory() {
        return StandardCategories.BOOKINGS;
    }

    public boolean isAuxiliary() {
        return false;
    }
}

