/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.factory.basic;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.factory.FactoryTool;
import com.gridnine.xtrip.client.fx.core.factory.FactoryToolCategory;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.standard.entity.RootEntityActivityHandler;
import com.gridnine.xtrip.client.fx.standard.factory.StandardCategories;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.DiscountProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeProperties;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.licence.LicenceServerProvider;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ModelContract;
import com.gridnine.xtrip.common.model.profile.TripartiteContract;
import com.gridnine.xtrip.common.model.profile.TripartiteContractType;
import com.gridnine.xtrip.common.model.restriction.resource.ModelRestrictionEntityResources;
import com.gridnine.xtrip.common.model.rules.RulesMigrationSettings;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import java.util.ArrayList;
import javafx.scene.Node;

enum ContractsFactoryTools implements FactoryTool
{
    CONTRACT{

        public String getName() {
            return Messages.Contract;
        }

        public void execute() {
            ComboBoxWidget typeWidget = new ComboBoxWidget(false);
            typeWidget.setNoNulls(true);
            typeWidget.setItemsSupplier(() -> {
                ArrayList<ContractType> list = new ArrayList<ContractType>();
                list.add(ContractType.CLIENT);
                list.add(ContractType.SUBAGENCY);
                list.add(ContractType.VENDOR);
                if (Environment.isPublished(LicenceServerProvider.class)) {
                    list.add(ContractType.TECHNICAL_PROVIDER);
                }
                return list;
            });
            typeWidget.valueProperty().set((Object)ContractType.CLIENT);
            new Dialog().setTitle(Messages.Choose_type_of_contract).setBody((Node)typeWidget).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Select, () -> RootEntityActivityHandler.editNew(this.createContract((ContractType)typeWidget.valueProperty().get()))).showGlobal();
        }

        private DataTransferPackage<Contract, Void> createContract(ContractType type) {
            EntityContainer ctr = new EntityContainer(Contract.class);
            ((Contract)ctr.getEntity()).setContractType(type);
            ((Contract)ctr.getEntity()).setNewModel(true);
            return new DataTransferPackage(ctr);
        }

        public AclQuery getACLQuery() {
            return new AclQuery(StandardRestrictionResourceOperations.CREATE.getId(), ModelRestrictionEntityResources.ENTITY_CONTRACT.getId());
        }
    }
    ,
    TRIPARTITE_CONTRACT{

        public String getName() {
            return Messages.The_tripartite_agreement;
        }

        public void execute() {
            ComboBoxWidget typeWidget = new ComboBoxWidget(false);
            typeWidget.setNoNulls(true);
            typeWidget.setItemsSupplier(() -> {
                ArrayList<TripartiteContractType> list = new ArrayList<TripartiteContractType>();
                list.add(TripartiteContractType.AVIA);
                list.add(TripartiteContractType.CAR);
                list.add(TripartiteContractType.HOTEL);
                return list;
            });
            EntityContainer ctr = new EntityContainer(TripartiteContract.class);
            typeWidget.valueProperty().set((Object)TripartiteContractType.AVIA);
            new Dialog().setTitle(Messages.Choose_type_of_tripartite_agreement).setBody((Node)typeWidget).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Select, () -> {
                ((TripartiteContract)ctr.getEntity()).setType((TripartiteContractType)typeWidget.valueProperty().get());
                RootEntityActivityHandler.editNew(new DataTransferPackage(ctr));
            }).showGlobal();
        }

        public AclQuery getACLQuery() {
            return new AclQuery(StandardRestrictionResourceOperations.CREATE.getId(), ModelRestrictionEntityResources.ENTITY_TRIPARTITE_CONTRACT.getId());
        }
    }
    ,
    MODEL_CONTRACT{

        public String getName() {
            return Messages.Model_contract;
        }

        public void execute() {
            RootEntityActivityHandler.editNew(new DataTransferPackage(EntityContainer.create((BaseEntity)new ModelContract())));
        }

        public AclQuery getACLQuery() {
            return new AclQuery(StandardRestrictionResourceOperations.CREATE.getId(), ModelRestrictionEntityResources.ENTITY_MODEL_CONTRACT.getId());
        }
    }
    ,
    RULES_MIGRATION_SETTINGS{

        public String getName() {
            return Messages.Rule_Transfer_Settings;
        }

        public void execute() {
            RulesMigrationSettings entity = new RulesMigrationSettings();
            entity.setName(this.getName());
            RootEntityActivityHandler.editNew(new DataTransferPackage(EntityContainer.create((BaseEntity)entity)));
        }

        public AclQuery getACLQuery() {
            return new AclQuery(StandardRestrictionResourceOperations.CREATE.getId(), ModelRestrictionEntityResources.ENTITY_RULES_MIGRATION_SETTINGS.getId());
        }
    }
    ,
    COMISSION_PROPERTIES{

        public String getName() {
            return Messages.Commission_properties;
        }

        public void execute() {
            RootEntityActivityHandler.editNew(new DataTransferPackage(EntityContainer.create((BaseEntity)new CommissionProperties())));
        }

        public AclQuery getACLQuery() {
            return new AclQuery(StandardRestrictionResourceOperations.CREATE.getId(), ModelRestrictionEntityResources.ENTITY_COMMISSION_PROPERTIES.getId());
        }
    }
    ,
    FEE_PROPERTIES{

        public String getName() {
            return Messages.Collection_properties;
        }

        public void execute() {
            RootEntityActivityHandler.editNew(new DataTransferPackage(EntityContainer.create((BaseEntity)new FeeProperties())));
        }

        public AclQuery getACLQuery() {
            return new AclQuery(StandardRestrictionResourceOperations.CREATE.getId(), ModelRestrictionEntityResources.ENTITY_FEE_PROPERTIES.getId());
        }
    }
    ,
    PAYMENT_FEE_PROPERTIES{

        public String getName() {
            return Messages.Collection_fee_for_payment;
        }

        public void execute() {
            RootEntityActivityHandler.editNew(new DataTransferPackage(EntityContainer.create((BaseEntity)new PaymentFeeProperties())));
        }

        public AclQuery getACLQuery() {
            return new AclQuery(StandardRestrictionResourceOperations.CREATE.getId(), ModelRestrictionEntityResources.ENTITY_PAYMENT_FEE_PROPERTIES.getId());
        }
    }
    ,
    DISCOUNT_PROPERTIES{

        public String getName() {
            return Messages.Discount_properties;
        }

        public void execute() {
            RootEntityActivityHandler.editNew(new DataTransferPackage(EntityContainer.create((BaseEntity)new DiscountProperties())));
        }

        public AclQuery getACLQuery() {
            return new AclQuery(StandardRestrictionResourceOperations.CREATE.getId(), ModelRestrictionEntityResources.ENTITY_DISCOUNT_PROPERTIES.getId());
        }
    };


    public String getUid() {
        return "contracts-tools:" + this.name();
    }

    public FactoryToolCategory getCategory() {
        return StandardCategories.CONTRACTS;
    }

    public double getWeight() {
        return this.ordinal();
    }

    public boolean isAuxiliary() {
        return false;
    }
}

