/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.factory.basic;

import com.gridnine.xtrip.client.fx.core.factory.FactoryTool;
import com.gridnine.xtrip.client.fx.core.factory.FactoryToolCategory;
import com.gridnine.xtrip.client.fx.standard.entity.RootEntityActivityHandler;
import com.gridnine.xtrip.client.fx.standard.factory.StandardCategories;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.finance.CreditBankTransferOrder;
import com.gridnine.xtrip.common.model.finance.CreditSlip;
import com.gridnine.xtrip.common.model.finance.DebitBankTransferOrder;
import com.gridnine.xtrip.common.model.finance.DebitSlip;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.FinanceDocumentUIData;
import com.gridnine.xtrip.common.model.finance.PaymentDocumentUIData;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.finance.ShipmentUIData;
import com.gridnine.xtrip.common.model.restriction.resource.ModelRestrictionEntityResources;
import com.gridnine.xtrip.common.model.system.BillingTransaction;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;

enum FinanceFactoryTools implements FactoryTool
{
    CREDIT_SLIP{

        public String getName() {
            return Messages.RKO;
        }

        public void execute() {
            RootEntityActivityHandler.editNew(new DataTransferPackage(EntityContainer.create((BaseEntity)new CreditSlip())));
        }

        public AclQuery getACLQuery() {
            return new AclQuery(StandardRestrictionResourceOperations.CREATE.getId(), ModelRestrictionEntityResources.ENTITY_CREDIT_SLIP.getId());
        }
    }
    ,
    DEBIT_SLIP{

        public String getName() {
            return Messages.PKO;
        }

        public void execute() {
            RootEntityActivityHandler.editNew(new DataTransferPackage(EntityContainer.create((BaseEntity)new DebitSlip())));
        }

        public AclQuery getACLQuery() {
            return new AclQuery(StandardRestrictionResourceOperations.CREATE.getId(), ModelRestrictionEntityResources.ENTITY_DEBIT_SLIP.getId());
        }
    }
    ,
    CREDIT_BANK_TRANSFER_ORDER{

        public String getName() {
            return Messages.Withdrawals_from_account;
        }

        public void execute() {
            RootEntityActivityHandler.editNew(new DataTransferPackage(EntityContainer.create((BaseEntity)new CreditBankTransferOrder())));
        }

        public AclQuery getACLQuery() {
            return new AclQuery(StandardRestrictionResourceOperations.CREATE.getId(), ModelRestrictionEntityResources.ENTITY_CREDIT_BANK_TRANSFER_ORDER.getId());
        }
    }
    ,
    DEBIT_BANK_TRANSFER_ORDER{

        public String getName() {
            return Messages.Receipt_to_account;
        }

        public void execute() {
            RootEntityActivityHandler.editNew(new DataTransferPackage(EntityContainer.create((BaseEntity)new DebitBankTransferOrder()), (Object)new PaymentDocumentUIData()));
        }

        public AclQuery getACLQuery() {
            return new AclQuery(StandardRestrictionResourceOperations.CREATE.getId(), ModelRestrictionEntityResources.ENTITY_DEBIT_BANK_TRANSFER_ORDER.getId());
        }
    }
    ,
    SHIPMENT{

        public String getName() {
            return Messages.Implementation;
        }

        public void execute() {
            RootEntityActivityHandler.editNew(new DataTransferPackage(EntityContainer.create((BaseEntity)new Shipment()), (Object)new ShipmentUIData()));
        }

        public AclQuery getACLQuery() {
            return new AclQuery(StandardRestrictionResourceOperations.CREATE.getId(), ModelRestrictionEntityResources.ENTITY_SHIPMENT.getId());
        }
    }
    ,
    FINANCIAL_DOCUMENT{

        public String getName() {
            return Messages.Financial_Document;
        }

        public void execute() {
            EntityContainer ctr = new EntityContainer(FinanceDocument.class);
            ((FinanceDocument)ctr.getEntity()).setUseFacsimile(true);
            RootEntityActivityHandler.editNew(new DataTransferPackage(ctr, (Object)new FinanceDocumentUIData()));
        }

        public AclQuery getACLQuery() {
            return new AclQuery(StandardRestrictionResourceOperations.CREATE.getId(), ModelRestrictionEntityResources.ENTITY_FINANCE_DOCUMENT.getId());
        }
    }
    ,
    BILLING_TRANSACTION{

        public String getName() {
            return Messages.Transaction;
        }

        public void execute() {
            RootEntityActivityHandler.editNew(new DataTransferPackage(EntityContainer.create((BaseEntity)new BillingTransaction())));
        }

        public AclQuery getACLQuery() {
            return new AclQuery(StandardRestrictionResourceOperations.CREATE.getId(), ModelRestrictionEntityResources.ENTITY_BILLING_TRANSACTION.getId());
        }
    };


    public String getUid() {
        return "finance-tools:" + this.name();
    }

    public FactoryToolCategory getCategory() {
        return StandardCategories.FINANCE;
    }

    public double getWeight() {
        return this.ordinal();
    }

    public boolean isAuxiliary() {
        return false;
    }
}

