/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.factory.basic;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.lib.components.dialog.MessagePane;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.model.profile.TransferTransactionToAgent;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.fx.rpc.FinanceService;
import com.gridnine.xtrip.common.fx.rpc.WorklogService;
import com.gridnine.xtrip.common.fx.rpc.service.IntegrationBusRpcService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.dict.CurrencyInfoReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.finance.StandardTransactionActions;
import com.gridnine.xtrip.common.model.finance.TransactionAction;
import com.gridnine.xtrip.common.model.finance.TransactionDataHolder;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.Worklog;
import com.gridnine.xtrip.common.model.system.WorklogIndex;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.layout.VBox;

public class TransferTransactionToAgentCreateProcedure {
    public static void handle() {
        Date date = new Date();
        Notifications.get().submitTask(() -> {
            EntityContainer worklogContainer = ((WorklogService)RpcServiceManager.get().getService(WorklogService.class)).loadWorklog(ServiceInvocationContext.get(), Prefetched.getData().getCurrentAgentData().getAgent(), PersonType.AGENT, date);
            if (worklogContainer != null) {
                Worklog worklog = (Worklog)worklogContainer.getEntity();
                String currency = Prefetched.getData().getEquivalentCurrency();
                BigDecimal amount = ((FinanceService)RpcServiceManager.get().getService(FinanceService.class)).calculateAgentBalance(ServiceInvocationContext.get(), worklog.getAgency(), worklog.getEmployee(), worklog.getCashRegisterWorkplace(), worklog.getStartDate(), date, new Date(), (DictionaryReference)new CurrencyInfoReference(currency));
                FxUtil.waitForFxThread(() -> {
                    Dialog dialog = new Dialog();
                    TransferTransactionToAgent panel = new TransferTransactionToAgent(false);
                    panel.getAgentNode().setListParametersSupplier(() -> {
                        IndexListParameters params = new IndexListParameters();
                        params.setIndexType(WorklogIndex.class);
                        TableColumnSettings name = new TableColumnSettings();
                        name.setId(WorklogIndex.Property.employee.name());
                        TableColumnSettings agency = new TableColumnSettings();
                        agency.setId(WorklogIndex.Property.agency.name());
                        TableColumnSettings types = new TableColumnSettings();
                        types.setId(WorklogIndex.Property.types.name());
                        params.getColumns().add(name);
                        params.getColumns().add(agency);
                        params.getColumns().add(types);
                        params.getFilters().add(name);
                        params.getFilters().add(agency);
                        params.getFilters().add(types);
                        params.getSearchCriterions().add(SearchCriterion.ne((String)WorklogIndex.Property.employee.name(), (Object)worklog.getEmployee()));
                        params.getSearchCriterions().add(SearchCriterion.contains((String)WorklogIndex.Property.types.name(), (Object)PersonType.AGENT));
                        params.getSearchCriterions().add(SearchCriterion.eq((String)WorklogIndex.Property.agency.name(), (Object)worklog.getAgency()));
                        params.getSearchCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.le((String)WorklogIndex.Property.startDate.name(), (Object)date), SearchCriterion.eq((String)WorklogIndex.Property.startDate.name(), null)}));
                        params.getSearchCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)WorklogIndex.Property.endDate.name(), (Object)date), SearchCriterion.eq((String)WorklogIndex.Property.endDate.name(), null)}));
                        params.getPatternSearchFields().add(WorklogIndex.Property.employee.name());
                        return params;
                    });
                    panel.getCalculatedNode().setValue(SystemHelper.getMoney((BigDecimal)(amount != null ? amount : BigDecimal.ZERO), (String)currency));
                    panel.getFactualNode().setValue((Number)amount);
                    ArrayList messages = new ArrayList();
                    VBox box = new VBox(new Node[]{panel});
                    dialog.setBody((Node)box).setTitle(Messages.Transfer_transaction_to_agent).setAutoClose(false).setOnCloseRequest(() -> dialog.close()).addButton(DialogButtonStyle.DECLINE, () -> dialog.close()).addButton(DialogButtonStyle.ACCEPT_REGULAR, () -> {
                        box.getChildren().removeAll((Collection)messages);
                        messages.clear();
                        messages.addAll(TransferTransactionToAgentCreateProcedure.validate(panel));
                        if (messages.size() > 0) {
                            for (int i = 0; i < messages.size(); ++i) {
                                box.getChildren().add(i, messages.get(i));
                            }
                            return;
                        }
                        if (panel.getCalculatedNode().getValue().getValue().compareTo((BigDecimal)panel.getFactualNode().getValue()) < 0) {
                            Dialog.confirm((Node)Dialog.getGlobalWindow(), (String)Messages.TransferTransaction_Warning, (String)Messages.TransferTransaction_CompareError, (String)Messages.TransferTransaction_Continue, () -> {
                                TransferTransactionToAgentCreateProcedure.create(panel, worklog, currency, date);
                                dialog.close();
                            }, () -> {});
                        } else {
                            TransferTransactionToAgentCreateProcedure.create(panel, worklog, currency, date);
                            dialog.close();
                        }
                    }).showGlobal();
                });
            } else {
                Dialog.info((String)Messages.TransferTransactionFactoryHandler_agentWorklogNotFound);
            }
        }, Messages.Loading_data);
    }

    private static List<MessagePane> validate(TransferTransactionToAgent panel) {
        ArrayList<MessagePane> messages = new ArrayList<MessagePane>();
        if (panel.getAgentNode().getValue() == null) {
            messages.add(MessagePane.error((String)Messages.TransferTransactionToAgentPanel_agentNotSpecified));
        }
        if (panel.getFactualNode().getValue() == null) {
            messages.add(MessagePane.error((String)Messages.TransferTransactionPanel_amountNotSpecified));
        }
        if (TextUtil.isBlank((String)panel.getNameNode().getValue())) {
            messages.add(MessagePane.error((String)Messages.TransferTransactionPanel_descriptionNotSpecified));
        }
        return messages;
    }

    private static void create(TransferTransactionToAgent panel, Worklog worklog, String currency, Date date) {
        Notifications.get().submitTask(() -> {
            try {
                EntityContainer agentWorklogContainer = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), panel.getAgentNode().getValue());
                Worklog agentWorklog = (Worklog)agentWorklogContainer.getEntity();
                if (agentWorklog != null) {
                    TransactionDataHolder transactionDataHolder = TransactionDataHolder.TransactionDataHolderBuilder.of((TransactionAction)StandardTransactionActions.CASH_REMAINS_AGENT_CASH, (EntityReference)worklog.getAgency()).date(date).amount(SystemHelper.getMoney((BigDecimal)((BigDecimal)panel.getFactualNode().getValue()), (String)currency)).description(panel.getNameNode().getValue()).creditDimensionData().paymentType(PaymentType.CASH).salesPoint(worklog.getSalesPoint()).agent(worklog.getEmployee()).cash(worklog.getCash()).cashRegister(worklog.getCashRegister()).cashRegisterWorkplace(worklog.getCashRegisterWorkplace()).end().debitDimensionData().paymentType(PaymentType.CASH).salesPoint(worklog.getSalesPoint()).agent(worklog.getEmployee()).cash(worklog.getCash()).cashRegister(worklog.getCashRegister()).cashRegisterWorkplace(worklog.getCashRegisterWorkplace()).end().build();
                    HashMap<String, TransactionDataHolder> data = new HashMap<String, TransactionDataHolder>();
                    data.put(IBusFinanceContextKeys.TRANSACTION_DATA_HOLDER.name(), transactionDataHolder);
                    ((IntegrationBusRpcService)RpcServiceManager.get().getService(IntegrationBusRpcService.class)).processRouteSync(ServiceInvocationContext.get(), "finance:create-custom-transaction", data);
                    transactionDataHolder = TransactionDataHolder.TransactionDataHolderBuilder.of((TransactionAction)StandardTransactionActions.CASH_REMAINS_AGENT_CASH, (EntityReference)worklog.getAgency()).date(date).amount(SystemHelper.getMoney((BigDecimal)MiscUtil.negate((BigDecimal)((BigDecimal)panel.getFactualNode().getValue())), (String)currency)).description(panel.getNameNode().getValue()).creditDimensionData().paymentType(PaymentType.CASH).salesPoint(agentWorklog.getSalesPoint()).agent(agentWorklog.getEmployee()).cash(agentWorklog.getCash()).cashRegister(agentWorklog.getCashRegister()).cashRegisterWorkplace(agentWorklog.getCashRegisterWorkplace()).end().debitDimensionData().paymentType(PaymentType.CASH).salesPoint(worklog.getSalesPoint()).agent(worklog.getEmployee()).cash(worklog.getCash()).cashRegister(worklog.getCashRegister()).cashRegisterWorkplace(worklog.getCashRegisterWorkplace()).end().build();
                    data = new HashMap();
                    data.put(IBusFinanceContextKeys.TRANSACTION_DATA_HOLDER.name(), transactionDataHolder);
                    ((IntegrationBusRpcService)RpcServiceManager.get().getService(IntegrationBusRpcService.class)).processRouteSync(ServiceInvocationContext.get(), "finance:create-custom-transaction", data);
                    Notifications.get().showFlashNotification(Messages.TransferTransactionSuccess, Messages.TransferTransactionSuccess);
                } else {
                    Dialog.info((String)Messages.TransferTransactionFactoryHandler_agentWorklogNotFound);
                }
            }
            catch (Exception e) {
                ErrorHandler.handle((Throwable)e);
            }
        }, Messages.Notifications_getting_data);
    }
}

