/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.gds.sabreprofiles;

import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.tasks.ServerTaskHandler;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ValueHolder;
import com.gridnine.xtrip.client.fx.standard.gds.sabreprofiles.SabreProfilesSynchronizationUtil;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.async.SabreProfilesSynchronizeOrganizationListAsyncTaskParameters;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.SabreProfilesPccSettings;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class SabreProfilesSynchronizeOrganizationListServerTaskHandler
extends ServerTaskHandler {
    private final List<EntityReference<Organization>> itemsReference;
    private final SearchQuery searchQuery;
    private SabreProfilesPccSettings pccSettings;

    public static void enqueue(List<EntityReference<Organization>> itemsReference) {
        SabreProfilesSynchronizeOrganizationListServerTaskHandler.enqueue(new SabreProfilesSynchronizeOrganizationListServerTaskHandler(itemsReference));
    }

    public static void enqueue(SearchQuery searchQuery) {
        SabreProfilesSynchronizeOrganizationListServerTaskHandler.enqueue(new SabreProfilesSynchronizeOrganizationListServerTaskHandler(searchQuery));
    }

    public static void enqueue(List<EntityReference<Organization>> itemsReference, String confirmation) {
        SabreProfilesSynchronizeOrganizationListServerTaskHandler.enqueue(new SabreProfilesSynchronizeOrganizationListServerTaskHandler(itemsReference, confirmation));
    }

    private static void enqueue(SabreProfilesSynchronizeOrganizationListServerTaskHandler handler) {
        Notifications.get().submitTask(() -> {
            try {
                ArrayList<Message> validationErrors = new ArrayList<Message>();
                ValueHolder continueHolder = new ValueHolder((Object)Boolean.TRUE);
                if (!SabreProfilesSynchronizeOrganizationListServerTaskHandler.checkAccess(validationErrors)) {
                    Notifications.get().showMessages(validationErrors);
                    Notifications.get().showMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.Org_synhronization_Sabre_no_permissions, (Object[])new Object[0])});
                    continueHolder.set((Object)Boolean.FALSE);
                }
                SabreProfilesPccSettings pccSettingsTemp = null;
                if (Boolean.TRUE.equals(continueHolder.get()) && ((pccSettingsTemp = SabreProfilesSynchronizationUtil.getPccSettings(Messages.Org_synhronization_Sabre)) == null || TextUtil.isBlank((String)pccSettingsTemp.getPcc()))) {
                    Notifications.get().showMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.No_pcc_for_sync, (Object[])new Object[0]), SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.Org_profiles_not_sync_no_agent_pcc, (Object[])new Object[0])});
                    continueHolder.set((Object)Boolean.FALSE);
                }
                if (Boolean.TRUE.equals(continueHolder.get())) {
                    handler.pccSettings = pccSettingsTemp;
                    FxUtil.submitToFxThread(() -> Notifications.get().enqueueAsyncTask((ServerTaskHandler)handler));
                }
            }
            catch (Exception ex) {
                ErrorHandler.handle((Throwable)ex);
            }
        }, Messages.Synchronization_with_Sabre_Profiles);
    }

    private static boolean checkAccess(List<Message> messages) {
        return true;
    }

    private SabreProfilesSynchronizeOrganizationListServerTaskHandler(List<EntityReference<Organization>> itemsReference) {
        this.itemsReference = itemsReference;
        this.searchQuery = null;
    }

    private SabreProfilesSynchronizeOrganizationListServerTaskHandler(SearchQuery searchQuery) {
        this.itemsReference = null;
        this.searchQuery = searchQuery;
    }

    private SabreProfilesSynchronizeOrganizationListServerTaskHandler(List<EntityReference<Organization>> itemsReference, String confirmation) {
        this.itemsReference = itemsReference;
        this.searchQuery = null;
    }

    protected String getTitle() {
        return Messages.Org_synhronization_Sabre;
    }

    protected String getTaskClassName() {
        return "com.gridnine.xtrip.server.fx.async.entityactions.sabreprofiles.SabreProfilesSynchronizeOrganizationListAsyncTask";
    }

    protected Serializable getTaskParameters() {
        return new SabreProfilesSynchronizeOrganizationListAsyncTaskParameters(this.itemsReference, this.searchQuery, this.pccSettings);
    }

    protected void onCompleted(Object result, List<Message> log) {
        List res = (List)result;
        Notifications.get().showMessages(new Message[]{SabreProfilesSynchronizationUtil.getSummaryOrganizationsSyncMessage(res)});
        if (this.itemsReference != null) {
            EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, (Collection)this.itemsReference.stream().map(ref -> new EntityModification(ref, EntityModification.ModificationType.CHANGE)).collect(Collectors.toList())));
        }
    }
}

