/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.gds.sabreprofiles;

import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.standard.gds.sabreprofiles.SabreProfilesSynchronizationUtil;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.fx.rpc.ProfilesSynchronizationService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.gds.sabre.ProfileSynchronizationUtil;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.model.profile.SabreProfilesLoadResult;
import com.gridnine.xtrip.common.model.profile.SabreProfilesPccSettings;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SabreProfilesUpdatePersonListTask
extends ClientTask {
    private final List<EntityReference<Person>> itemsReference;
    private static final int PREPARING_PROGRESS = 50;
    private static final int SYNCHRONIZING_PROGRESS = 50;

    public SabreProfilesUpdatePersonListTask(List<EntityReference<Person>> persons) {
        this.itemsReference = persons;
    }

    protected String getTitle() {
        return Messages.Travelers_update_Sabre;
    }

    protected void execute() throws Exception {
        ProfilesSynchronizationService syncService = (ProfilesSynchronizationService)RpcServiceManager.get().getService(ProfilesSynchronizationService.class);
        EntityService entityService = (EntityService)RpcServiceManager.get().getService(EntityService.class);
        ServiceInvocationContext sic = ServiceInvocationContext.get();
        ArrayList<Message> validationErrors = new ArrayList<Message>();
        ArrayList<EntityContainer> travellerContainers = new ArrayList<EntityContainer>();
        int numTotalSelected = this.itemsReference.size();
        int count = 1;
        for (EntityReference<Person> personReference : this.itemsReference) {
            EntityContainer personContainer;
            if (personReference != null && (personContainer = entityService.load(sic, personReference)) != null) {
                if (!((Person)personContainer.getEntity()).getTypes().contains(PersonType.PASSENGER)) {
                    this.addMessages(new Message[]{MessageHelper.createMessage((String)Messages.Person_isnt_traveler, (Object[])new Object[]{personReference.getCaption()})});
                } else if (!((Person)personContainer.getEntity()).getSabreProfilesUniqueIDs().isEmpty()) {
                    travellerContainers.add(personContainer);
                } else {
                    this.addMessages(new Message[]{MessageHelper.createMessage((String)Messages.Person_hasnt_IDsPCCs, (Object[])new Object[]{personReference.getCaption()})});
                }
            }
            int progress = 50 * count / this.itemsReference.size();
            this.setProgress((byte)progress, "Prepared for update: " + personReference);
            ++count;
        }
        if (travellerContainers.isEmpty()) {
            this.addMessages(new Message[]{MessageHelper.createMessage((String)Messages.SabreProfilesSynchronizationToolHandler_personNotFound, (Object[])new Object[0])});
            return;
        }
        int numNotValidated = numTotalSelected - travellerContainers.size();
        int numSyncSuccess = 0;
        int numSyncFailed = 0;
        List allowedPccSettings = Prefetched.getData().getSabreProfilesSettings().getDefaultPccSettings();
        if (allowedPccSettings.isEmpty()) {
            this.addMessages(new Message[]{MessageHelper.createMessage((String)Messages.AllowedPccSettingsIsEmpty, (Object[])new Object[0])});
            return;
        }
        HashMap<EntityContainer, List> personsWithPccs = new HashMap<EntityContainer, List>();
        for (EntityContainer entityContainer : travellerContainers) {
            if (!this.checkAccess((EntityContainer<Person>)entityContainer, validationErrors)) continue;
            List<String> predefinedPccSettings = SabreProfilesSynchronizationUtil.getPccSettingsFromProfilesUniqueIDs((EntityContainer<Person>)entityContainer);
            List filteredPccSettings = ProfileSynchronizationUtil.filterIDsPccsSettings(predefinedPccSettings, (List)allowedPccSettings);
            personsWithPccs.put(entityContainer, filteredPccSettings);
        }
        if (personsWithPccs.values().stream().allMatch(list -> list.size() == 1) && !personsWithPccs.isEmpty()) {
            for (Map.Entry entry : personsWithPccs.entrySet()) {
                EntityContainer travellerContainer = (EntityContainer)entry.getKey();
                if (this.checkAccess((EntityContainer<Person>)travellerContainer, validationErrors)) {
                    SabreProfilesPccSettings pccToSync = (SabreProfilesPccSettings)((List)entry.getValue()).get(0);
                    boolean res = pccToSync != null && SabreProfilesUpdatePersonListTask.updatePerson((EntityContainer<Person>)travellerContainer, pccToSync, validationErrors);
                    this.addMessages(validationErrors);
                    validationErrors.clear();
                    if (res) {
                        ++numSyncSuccess;
                    } else {
                        ++numSyncFailed;
                    }
                }
                int progress = 50 + 50 * count / travellerContainers.size();
                this.setProgress((byte)progress, String.format(Messages.SabreProfilesUpdateToolHandler_personAdded, travellerContainer.getEntity()));
                ++count;
            }
        } else {
            List<SabreProfilesPccSettings> commonPccSettings = SabreProfilesSynchronizationUtil.getUniquePccSettings(personsWithPccs.values());
            if (commonPccSettings.size() == 0) {
                this.addMessages(new Message[]{MessageHelper.createErrorMessage((String)Messages.SabreProfilesUpdateToolHandler_selectedProfilesDoesNotHaveCommonPccs, (Object[])new Object[0])});
                this.setProgress((byte)100, Messages.SabreProfilesSynchronizationToolHandler_updateComplete);
                return;
            }
            SabreProfilesPccSettings sabreProfilesPccSettings = SabreProfilesSynchronizationUtil.showPccSettingsDialog(commonPccSettings, Messages.Travelers_update_Sabre);
            for (Map.Entry entry : personsWithPccs.entrySet()) {
                EntityContainer travellerContainer = (EntityContainer)entry.getKey();
                if (this.checkAccess((EntityContainer<Person>)travellerContainer, validationErrors)) {
                    boolean res = sabreProfilesPccSettings != null && SabreProfilesUpdatePersonListTask.updatePerson((EntityContainer<Person>)travellerContainer, sabreProfilesPccSettings, validationErrors);
                    this.addMessages(validationErrors);
                    validationErrors.clear();
                    if (res) {
                        ++numSyncSuccess;
                    } else {
                        ++numSyncFailed;
                    }
                }
                int progress = 50 + 50 * count / travellerContainers.size();
                this.setProgress((byte)progress, String.format(Messages.SabreProfilesUpdateToolHandler_personAdded, travellerContainer.getEntity()));
                ++count;
            }
        }
        this.addMessages(new Message[]{SabreProfilesSynchronizationUtil.getSummaryPersonsSyncMessage(Arrays.asList(numTotalSelected, numSyncSuccess, numNotValidated, numSyncFailed))});
        EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, (Collection)this.itemsReference.stream().map(ref -> new EntityModification(ref, EntityModification.ModificationType.CHANGE)).collect(Collectors.toList())));
        this.setProgress((byte)100, Messages.SabreProfilesSynchronizationToolHandler_updateComplete);
    }

    public static boolean updatePerson(EntityContainer<Person> perCont, SabreProfilesPccSettings pccSettings, List<Message> msgs) {
        boolean res;
        if (perCont == null) {
            return false;
        }
        try {
            RpcServiceManager rpcServiceManager = RpcServiceManager.get();
            ServiceInvocationContext serviceInvocationContext = ServiceInvocationContext.get();
            EntityReference perRef = perCont.toReference();
            MiscUtil.Pair currentRes = ((ProfilesSynchronizationService)rpcServiceManager.getService(ProfilesSynchronizationService.class)).loadExistPerson(serviceInvocationContext, perRef, pccSettings, false, true);
            res = currentRes.getFirst() == SabreProfilesLoadResult.OK;
            msgs.addAll((Collection)currentRes.getSecond());
        }
        catch (Exception e) {
            res = false;
            msgs.add(MessageHelper.createErrorMessage((String)"{0}", (Object[])new Object[]{e.getMessage()}));
        }
        return res;
    }

    private boolean checkAccess(EntityContainer<Person> perCont, List<Message> messages) throws Exception {
        return true;
    }
}

