/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.helpers;

import com.gridnine.xtrip.client.fx.core.dicts.DictListParameters;
import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.registry.basic.Renderer;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.HasValue;
import com.gridnine.xtrip.client.fx.core.util.MultiSupplier;
import com.gridnine.xtrip.client.fx.standard.helpers.DictHandlersHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.ListParametersHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.DictQuery;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.BookingFileIndex;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.CommissionPropertiesIndex;
import com.gridnine.xtrip.common.model.booking.commission.DiscountProperties;
import com.gridnine.xtrip.common.model.booking.commission.DiscountPropertiesIndex;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeePropertiesIndex;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeePropertiesIndex;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.export.BaseCommonConnectionSettings;
import com.gridnine.xtrip.common.model.export.BaseCommonExportSettings;
import com.gridnine.xtrip.common.model.export.BasicCommonConnectionSettingsIndex;
import com.gridnine.xtrip.common.model.export.BasicCommonExportSettingsIndex;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.handlers.standard.UniversalProductHandler;
import com.gridnine.xtrip.common.model.profile.BaseProfile;
import com.gridnine.xtrip.common.model.profile.Branch;
import com.gridnine.xtrip.common.model.profile.BranchIndex;
import com.gridnine.xtrip.common.model.profile.Cash;
import com.gridnine.xtrip.common.model.profile.CashIndex;
import com.gridnine.xtrip.common.model.profile.CashRegister;
import com.gridnine.xtrip.common.model.profile.CashRegisterIndex;
import com.gridnine.xtrip.common.model.profile.CashRegisterWorkplace;
import com.gridnine.xtrip.common.model.profile.CashRegisterWorkplaceIndex;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerIndex;
import com.gridnine.xtrip.common.model.profile.ContractIndex;
import com.gridnine.xtrip.common.model.profile.Holding;
import com.gridnine.xtrip.common.model.profile.HoldingIndex;
import com.gridnine.xtrip.common.model.profile.ModelContract;
import com.gridnine.xtrip.common.model.profile.ModelContractIndex;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonEmploymentIndex;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.profile.SalesPointIndex;
import com.gridnine.xtrip.common.model.profile.TripartiteContract;
import com.gridnine.xtrip.common.model.profile.TripartiteContractIndex;
import com.gridnine.xtrip.common.model.profile.VendorContractType;
import com.gridnine.xtrip.common.model.rules.standard.UniversalProductRuleEnvironment;
import com.gridnine.xtrip.common.model.rules.standard.nomenclatures.UniversalProductNomenclatureRulesEnvironment;
import com.gridnine.xtrip.common.model.system.BaseFileDocument;
import com.gridnine.xtrip.common.model.system.BasicDocumentIndex;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.model.system.TemplateDocumentIndex;
import com.gridnine.xtrip.common.model.system.TemplateType;
import com.gridnine.xtrip.common.model.system.Worklog;
import com.gridnine.xtrip.common.model.system.WorklogIndex;
import com.gridnine.xtrip.common.parsers.model.BaseExchangeDocument;
import com.gridnine.xtrip.common.parsers.model.GabrielMaskExchangeDocument;
import com.gridnine.xtrip.common.parsers.model.GabrielMaskExchangeDocumentIndex;
import com.gridnine.xtrip.common.parsers.model.IurExchangeDocument;
import com.gridnine.xtrip.common.parsers.model.IurExchangeDocumentIndex;
import com.gridnine.xtrip.common.parsers.model.RetExchangeDocument;
import com.gridnine.xtrip.common.parsers.model.RetExchangeDocumentIndex;
import com.gridnine.xtrip.common.parsers.model.SirenaXmlExchangeDocument;
import com.gridnine.xtrip.common.parsers.model.SirenaXmlExchangeDocumentIndex;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.search.utils.SearchQueryHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javafx.beans.value.ChangeListener;
import javafx.scene.Node;

public final class ControllerInterceptorsHelper {
    private ControllerInterceptorsHelper() {
    }

    public static <N extends Node, V, S> void spyFor(String spyToken, N node, Function<V, S> converter, Consumer<S> setter) {
        String keyValueChanged = spyToken + "-spyValueChanged";
        String keyValueListener = spyToken + "-spyValueListener";
        String keySceneListener = spyToken + "-spySceneListener";
        if (node.getProperties().containsKey((Object)keyValueListener)) {
            ((HasValue)node).valueProperty().removeListener((ChangeListener)node.getProperties().remove((Object)keyValueListener));
        }
        if (node.getProperties().containsKey((Object)keySceneListener)) {
            node.sceneProperty().removeListener((ChangeListener)node.getProperties().remove((Object)keySceneListener));
        }
        node.getProperties().put((Object)keyValueChanged, (Object)Boolean.FALSE);
        ChangeListener valueListener = (s, o, n) -> {
            if (node.getScene() == null) {
                node.getProperties().put((Object)keyValueChanged, (Object)Boolean.TRUE);
                return;
            }
            node.getProperties().put((Object)keyValueChanged, (Object)Boolean.FALSE);
            if (n == null) {
                setter.accept(null);
                return;
            }
            Notifications.get().submitTask(() -> {
                Object result = converter.apply(n);
                FxUtil.submitToFxThread(() -> setter.accept(result));
            }, Messages.Loading_data);
        };
        ChangeListener sceneListener = (s, o, n) -> {
            if (n == null) {
                return;
            }
            if (!Boolean.TRUE.equals(node.getProperties().get((Object)keyValueChanged))) {
                return;
            }
            node.getProperties().put((Object)keyValueChanged, (Object)Boolean.FALSE);
            Object value = ((HasValue)node).valueProperty().get();
            if (value == null) {
                setter.accept(null);
                return;
            }
            Notifications.get().submitTask(() -> {
                Object result = converter.apply(value);
                FxUtil.submitToFxThread(() -> setter.accept(result));
            }, Messages.Loading_data);
        };
        ((HasValue)node).valueProperty().addListener(valueListener);
        node.sceneProperty().addListener(sceneListener);
        node.getProperties().put((Object)keyValueListener, (Object)valueListener);
        node.getProperties().put((Object)keySceneListener, (Object)sceneListener);
    }

    public static IndexListParameters<Organization, OrganizationIndex> getOrganizations() {
        IndexListParameters result = new IndexListParameters();
        result.setIndexType(OrganizationIndex.class);
        result.getSortings().put(OrganizationIndex.Property.shortName.name(), SortOrder.ASC);
        result.getSearchCriterions().add(SearchCriterion.eq((String)OrganizationIndex.Property.disabled.name(), (Object)Boolean.FALSE));
        result.getPatternSearchFields().add(OrganizationIndex.Property.shortName.name());
        result.getPatternSearchFields().add(OrganizationIndex.Property.name.name());
        result.getPatternSearchFields().add(OrganizationIndex.Property.code.name());
        ListParametersHelper.setFilters(result, OrganizationIndex.Property.code.name(), OrganizationIndex.Property.types.name(), OrganizationIndex.Property.shortName.name(), OrganizationIndex.Property.name.name());
        ListParametersHelper.setColumns(result, OrganizationIndex.Property.shortName.name(), OrganizationIndex.Property.name.name(), OrganizationIndex.Property.code.name(), OrganizationIndex.Property.types.name());
        return result;
    }

    public static IndexListParameters<Organization, OrganizationIndex> getSuppliers() {
        IndexListParameters<Organization, OrganizationIndex> result = ControllerInterceptorsHelper.getOrganizations();
        result.getSearchCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.contains((String)OrganizationIndex.Property.types.name(), (Object)OrganizationType.AGENCY.name()), SearchCriterion.contains((String)OrganizationIndex.Property.types.name(), (Object)OrganizationType.BLANK_OWNER.name())}));
        return result;
    }

    public static IndexListParameters<Organization, OrganizationIndex> getPayers() {
        IndexListParameters<Organization, OrganizationIndex> result = ControllerInterceptorsHelper.getOrganizations();
        result.getSearchCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.contains((String)OrganizationIndex.Property.types.name(), (Object)OrganizationType.AGENCY.name()), SearchCriterion.contains((String)OrganizationIndex.Property.types.name(), (Object)OrganizationType.CORPORATE_CLIENT.name())}));
        return result;
    }

    public static IndexListParameters<Organization, OrganizationIndex> getBlankOwners() {
        IndexListParameters result = new IndexListParameters();
        result.setIndexType(OrganizationIndex.class);
        result.getSortings().put(OrganizationIndex.Property.shortName.name(), SortOrder.ASC);
        result.getSearchCriterions().add(SearchCriterion.contains((String)OrganizationIndex.Property.types.name(), (Object)OrganizationType.BLANK_OWNER.name()));
        result.getSearchCriterions().add(SearchCriterion.eq((String)OrganizationIndex.Property.disabled.name(), (Object)Boolean.FALSE));
        result.getPatternSearchFields().add(OrganizationIndex.Property.shortName.name());
        result.getPatternSearchFields().add(OrganizationIndex.Property.name.name());
        result.getPatternSearchFields().add(OrganizationIndex.Property.code.name());
        ListParametersHelper.setFilters(result, OrganizationIndex.Property.code.name(), OrganizationIndex.Property.shortName.name(), OrganizationIndex.Property.name.name());
        ListParametersHelper.setColumns(result, OrganizationIndex.Property.shortName.name(), OrganizationIndex.Property.name.name(), OrganizationIndex.Property.code.name());
        return result;
    }

    public static DictListParameters getBlanTypesForBlankOwner(EntityReference<Organization> blankOwner) {
        DictListParameters result = new DictListParameters();
        result.getColumns().add(DictHandlersHelper.COL_CODE);
        result.getColumns().add(DictHandlersHelper.createColumn(BlankType.class, BlankType.Property.name.name(), Messages.Number, (Renderer)StandardRenderers.GENERIC));
        result.getColumns().add(DictHandlersHelper.createColumn(BlankType.class, BlankType.Property.couponsCount.name(), Messages.Number_of_coupons, (Renderer)StandardRenderers.GENERIC));
        result.getColumns().add(DictHandlersHelper.createColumn(BlankType.class, BlankType.Property.blankOwner.name(), Messages.Form_owner, (Renderer)StandardRenderers.GENERIC));
        result.getColumns().add(DictHandlersHelper.createColumn(BlankType.class, BlankType.Property.productCategory.name(), Messages.View, (Renderer)StandardRenderers.GENERIC));
        result.getColumns().add(DictHandlersHelper.createColumn(BlankType.class, BlankType.Property.blankCategory.name(), Messages.Type, (Renderer)StandardRenderers.GENERIC));
        if (blankOwner != null) {
            result.getSearchCriterions().add(new DictQuery.SearchCriterion(BlankType.Property.blankOwner.name(), new Object[]{blankOwner}));
        }
        return result;
    }

    public static IndexListParameters<Organization, OrganizationIndex> getAviaBlankOwners() {
        IndexListParameters<Organization, OrganizationIndex> result = ControllerInterceptorsHelper.getBlankOwners();
        result.getSearchCriterions().add(SearchCriterion.ne((String)OrganizationIndex.Property.airline.name(), null));
        return result;
    }

    public static IndexListParameters<Organization, OrganizationIndex> getAgencies() {
        IndexListParameters result = new IndexListParameters();
        result.setIndexType(OrganizationIndex.class);
        result.getSortings().put(OrganizationIndex.Property.shortName.name(), SortOrder.ASC);
        result.getSearchCriterions().add(SearchCriterion.contains((String)OrganizationIndex.Property.types.name(), (Object)OrganizationType.AGENCY.name()));
        result.getSearchCriterions().add(SearchCriterion.eq((String)OrganizationIndex.Property.disabled.name(), (Object)Boolean.FALSE));
        result.getPatternSearchFields().add(OrganizationIndex.Property.shortName.name());
        result.getPatternSearchFields().add(OrganizationIndex.Property.name.name());
        result.getPatternSearchFields().add(OrganizationIndex.Property.code.name());
        ListParametersHelper.setFilters(result, OrganizationIndex.Property.code.name(), OrganizationIndex.Property.shortName.name(), OrganizationIndex.Property.name.name());
        ListParametersHelper.setColumns(result, OrganizationIndex.Property.shortName.name(), OrganizationIndex.Property.name.name(), OrganizationIndex.Property.code.name());
        return result;
    }

    @Deprecated
    public static IndexListParameters<Organization, OrganizationIndex> getActiveAgencies() {
        return ControllerInterceptorsHelper.getAgencies();
    }

    public static IndexListParameters<Organization, OrganizationIndex> getClients() {
        IndexListParameters result = new IndexListParameters();
        result.setIndexType(OrganizationIndex.class);
        result.getSortings().put(OrganizationIndex.Property.shortName.name(), SortOrder.ASC);
        result.getSearchCriterions().add(SearchCriterion.contains((String)OrganizationIndex.Property.types.name(), (Object)OrganizationType.CORPORATE_CLIENT.name()));
        result.getSearchCriterions().add(SearchCriterion.eq((String)OrganizationIndex.Property.disabled.name(), (Object)Boolean.FALSE));
        result.getPatternSearchFields().add(OrganizationIndex.Property.shortName.name());
        result.getPatternSearchFields().add(OrganizationIndex.Property.name.name());
        result.getPatternSearchFields().add(OrganizationIndex.Property.code.name());
        ListParametersHelper.setFilters(result, OrganizationIndex.Property.code.name(), OrganizationIndex.Property.shortName.name(), OrganizationIndex.Property.name.name(), OrganizationIndex.Property.holding.name());
        ListParametersHelper.setColumns(result, OrganizationIndex.Property.shortName.name(), OrganizationIndex.Property.name.name(), OrganizationIndex.Property.code.name());
        return result;
    }

    public static IndexListParameters<Organization, OrganizationIndex> getClientsAndAgencies() {
        IndexListParameters<Organization, OrganizationIndex> result = ControllerInterceptorsHelper.getOrganizations();
        result.getSearchCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.contains((String)OrganizationIndex.Property.types.name(), (Object)OrganizationType.CORPORATE_CLIENT.name()), SearchCriterion.contains((String)OrganizationIndex.Property.types.name(), (Object)OrganizationType.AGENCY.name())}));
        return result;
    }

    public static IndexListParameters<Person, PersonIndex> getPersonsSortByCode() {
        IndexListParameters result = new IndexListParameters();
        result.setIndexType(PersonIndex.class);
        result.getSortings().put(PersonIndex.Property.code.name(), SortOrder.ASC);
        ListParametersHelper.setFilters(result, PersonIndex.Property.name.name(), PersonIndex.Property.code.name());
        ListParametersHelper.setColumns(result, PersonIndex.Property.name.name(), PersonIndex.Property.code.name());
        result.getSearchCriterions().add(SearchCriterion.eq((String)PersonIndex.Property.disabled.name(), (Object)Boolean.FALSE));
        return result;
    }

    public static IndexListParameters<Person, PersonIndex> getPersonsSortByName() {
        IndexListParameters result = new IndexListParameters();
        result.setIndexType(PersonIndex.class);
        result.getSortings().put(PersonIndex.Property.name.name(), SortOrder.ASC);
        ListParametersHelper.setFilters(result, PersonIndex.Property.name.name(), PersonIndex.Property.code.name());
        ListParametersHelper.setColumns(result, PersonIndex.Property.name.name(), PersonIndex.Property.code.name());
        result.getSearchCriterions().add(SearchCriterion.eq((String)PersonIndex.Property.disabled.name(), (Object)Boolean.FALSE));
        return result;
    }

    public static IndexListParameters<Person, PersonIndex> getPassengers(EntityReference<Organization> client, EntityReference<Holding> holding) {
        IndexListParameters result = new IndexListParameters();
        result.setIndexType(PersonIndex.class);
        result.getSearchCriterions().add(SearchCriterion.contains((String)PersonIndex.Property.types.name(), (Object)PersonType.PASSENGER.name()));
        if (holding != null) {
            result.getSearchCriterions().add(SearchCriterion.eq((String)"holding", holding));
        } else if (client != null) {
            result.getSearchCriterions().add(SearchCriterion.contains((String)PersonIndex.Property.employmentsUids.name(), (Object)client.getUid()));
        }
        ListParametersHelper.setFilters(result, PersonIndex.Property.name.name(), PersonIndex.Property.employments.name());
        ListParametersHelper.setColumns(result, PersonIndex.Property.name.name(), PersonIndex.Property.employments.name());
        return result;
    }

    public static IndexListParameters<Person, PersonIndex> getAgents() {
        IndexListParameters<Person, PersonIndex> params = ControllerInterceptorsHelper.getPersonsSortByName();
        params.getSearchCriterions().add(SearchCriterion.contains((String)PersonIndex.Property.types.name(), (Object)PersonType.AGENT.name()));
        return params;
    }

    public static IndexListParameters<Person, PersonIndex> getCashierAccountant() {
        IndexListParameters<Person, PersonIndex> params = ControllerInterceptorsHelper.getPersonsSortByCode();
        params.getSearchCriterions().add(SearchCriterion.contains((String)PersonIndex.Property.types.name(), (Object)PersonType.CASHIER_ACCOUNTANT.name()));
        return params;
    }

    public static IndexListParameters<Person, PersonIndex> getAgentsForSalesPoint(EntityReference<SalesPoint> spRef) {
        IndexListParameters<Person, PersonIndex> result = ControllerInterceptorsHelper.getAgents();
        if (spRef != null) {
            result.getSearchCriterions().add(SearchCriterion.contains((String)PersonIndex.Property.salesPointsUids.name(), (Object)spRef.getUid()));
        }
        return result;
    }

    public static IndexListParameters<Person, PersonIndex> getAgentsAndManagersWithLogins() {
        IndexListParameters result = new IndexListParameters();
        result.setIndexType(PersonIndex.class);
        result.getSearchCriterions().add(SearchCriterion.eq((String)PersonIndex.Property.disabled.name(), (Object)Boolean.FALSE));
        result.getSearchCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.contains((String)PersonIndex.Property.types.name(), (Object)PersonType.AGENT.name()), SearchCriterion.contains((String)PersonIndex.Property.types.name(), (Object)PersonType.MANAGER.name())}));
        result.getSearchCriterions().add(SearchCriterion.isNotEmpty((String)PersonIndex.Property.loginName.name()));
        ListParametersHelper.setFilters(result, PersonIndex.Property.name.name(), PersonIndex.Property.code.name(), PersonIndex.Property.loginName.name(), PersonIndex.Property.employments.name());
        ListParametersHelper.setColumns(result, PersonIndex.Property.name.name(), PersonIndex.Property.code.name(), PersonIndex.Property.loginName.name(), PersonIndex.Property.emails.name(), PersonIndex.Property.positions.name());
        return result;
    }

    public static IndexListParameters<Person, PersonIndex> getActiveAgents() {
        IndexListParameters result = new IndexListParameters();
        result.setIndexType(PersonIndex.class);
        result.getSearchCriterions().add(SearchCriterion.contains((String)PersonIndex.Property.types.name(), (Object)PersonType.AGENT.name()));
        result.getSearchCriterions().add(SearchCriterion.eq((String)PersonIndex.Property.disabled.name(), (Object)Boolean.FALSE));
        ListParametersHelper.setFilters(result, PersonIndex.Property.name.name(), PersonIndex.Property.code.name(), PersonIndex.Property.loginName.name());
        ListParametersHelper.setColumns(result, PersonIndex.Property.name.name(), PersonIndex.Property.code.name(), PersonIndex.Property.loginName.name(), PersonIndex.Property.positions.name());
        return result;
    }

    public static IndexListParameters<Person, PersonEmploymentIndex> getEmployees() {
        IndexListParameters result = new IndexListParameters();
        result.setIndexType(PersonEmploymentIndex.class);
        result.getSearchCriterions().add(SearchCriterion.contains((String)PersonEmploymentIndex.Property.types.name(), (Object)PersonType.AGENT.name()));
        ListParametersHelper.setFilters(result, PersonEmploymentIndex.Property.name.name(), PersonEmploymentIndex.Property.code.name(), PersonEmploymentIndex.Property.login.name());
        ListParametersHelper.setColumns(result, PersonEmploymentIndex.Property.name.name(), PersonEmploymentIndex.Property.code.name(), PersonEmploymentIndex.Property.login.name(), PersonEmploymentIndex.Property.position.name());
        return result;
    }

    public static IndexListParameters<Holding, HoldingIndex> getHoldings() {
        IndexListParameters result = new IndexListParameters();
        result.setIndexType(HoldingIndex.class);
        result.getSortings().put(HoldingIndex.Property.code.name(), SortOrder.ASC);
        result.getSearchCriterions().add(SearchCriterion.eq((String)HoldingIndex.Property.disabled.name(), (Object)Boolean.FALSE));
        ListParametersHelper.setFilters(result, HoldingIndex.Property.shortName.name(), HoldingIndex.Property.name.name(), HoldingIndex.Property.code.name());
        ListParametersHelper.setColumns(result, HoldingIndex.Property.shortName.name(), HoldingIndex.Property.name.name(), HoldingIndex.Property.code.name());
        return result;
    }

    public static IndexListParameters<TemplateDocument, TemplateDocumentIndex> getAviaReceiptTemplates() {
        IndexListParameters result = new IndexListParameters();
        result.setIndexType(TemplateDocumentIndex.class);
        result.getSortings().put(TemplateDocumentIndex.Property.title.name(), SortOrder.ASC);
        result.getSearchCriterions().add(SearchCriterion.eq((String)TemplateDocumentIndex.Property.type.name(), (Object)TemplateType.PRINTFORM));
        result.getSearchCriterions().add(SearchQueryHelper.buildOrEqStringCriterion((String)TemplateDocumentIndex.Property.templateId.name(), Arrays.asList("itinerary-receipt", "refund-receipt")));
        result.getSearchCriterions().add(SearchCriterion.ne((String)TemplateDocumentIndex.Property.disabled.name(), (Object)Boolean.TRUE));
        ListParametersHelper.setFilters(result, TemplateDocumentIndex.Property.type.name(), TemplateDocumentIndex.Property.title.name());
        ListParametersHelper.setColumns(result, TemplateDocumentIndex.Property.type.name(), TemplateDocumentIndex.Property.title.name());
        return result;
    }

    public static IndexListParameters<TemplateDocument, TemplateDocumentIndex> getRailwayReceiptTemplates() {
        IndexListParameters result = new IndexListParameters();
        result.setIndexType(TemplateDocumentIndex.class);
        result.getSortings().put(TemplateDocumentIndex.Property.title.name(), SortOrder.ASC);
        result.getSearchCriterions().add(SearchCriterion.eq((String)TemplateDocumentIndex.Property.type.name(), (Object)TemplateType.PRINTFORM));
        result.getSearchCriterions().add(SearchQueryHelper.buildOrEqStringCriterion((String)TemplateDocumentIndex.Property.templateId.name(), Arrays.asList("railway-itinerary-receipt", "railway-refund-receipt")));
        result.getSearchCriterions().add(SearchCriterion.ne((String)TemplateDocumentIndex.Property.disabled.name(), (Object)Boolean.TRUE));
        ListParametersHelper.setFilters(result, TemplateDocumentIndex.Property.type.name(), TemplateDocumentIndex.Property.title.name());
        ListParametersHelper.setColumns(result, TemplateDocumentIndex.Property.type.name(), TemplateDocumentIndex.Property.title.name());
        return result;
    }

    public static IndexListParameters<TemplateDocument, TemplateDocumentIndex> getAeroexpressReceiptTemplates() {
        IndexListParameters result = new IndexListParameters();
        result.setIndexType(TemplateDocumentIndex.class);
        result.getSortings().put(TemplateDocumentIndex.Property.title.name(), SortOrder.ASC);
        result.getSearchCriterions().add(SearchCriterion.eq((String)TemplateDocumentIndex.Property.type.name(), (Object)TemplateType.PRINTFORM));
        result.getSearchCriterions().add(SearchCriterion.eq((String)TemplateDocumentIndex.Property.templateId.name(), (Object)"aeroexpress-itinerary-receipt"));
        result.getSearchCriterions().add(SearchCriterion.ne((String)TemplateDocumentIndex.Property.disabled.name(), (Object)Boolean.TRUE));
        ListParametersHelper.setFilters(result, TemplateDocumentIndex.Property.type.name(), TemplateDocumentIndex.Property.title.name());
        ListParametersHelper.setColumns(result, TemplateDocumentIndex.Property.type.name(), TemplateDocumentIndex.Property.title.name());
        return result;
    }

    public static IndexListParameters<TemplateDocument, TemplateDocumentIndex> getBusReceiptTemplates() {
        IndexListParameters result = new IndexListParameters();
        result.setIndexType(TemplateDocumentIndex.class);
        result.getSortings().put(TemplateDocumentIndex.Property.title.name(), SortOrder.ASC);
        result.getSearchCriterions().add(SearchCriterion.eq((String)TemplateDocumentIndex.Property.type.name(), (Object)TemplateType.PRINTFORM));
        result.getSearchCriterions().add(SearchCriterion.eq((String)TemplateDocumentIndex.Property.templateId.name(), (Object)"bus-itinerary-receipt"));
        result.getSearchCriterions().add(SearchCriterion.ne((String)TemplateDocumentIndex.Property.disabled.name(), (Object)Boolean.TRUE));
        ListParametersHelper.setFilters(result, TemplateDocumentIndex.Property.type.name(), TemplateDocumentIndex.Property.title.name());
        ListParametersHelper.setColumns(result, TemplateDocumentIndex.Property.type.name(), TemplateDocumentIndex.Property.title.name());
        return result;
    }

    public static IndexListParameters<TemplateDocument, TemplateDocumentIndex> getCertificateOfCompletedFlightTemplates() {
        IndexListParameters result = new IndexListParameters();
        result.setIndexType(TemplateDocumentIndex.class);
        result.getSortings().put(TemplateDocumentIndex.Property.title.name(), SortOrder.ASC);
        result.getSearchCriterions().add(SearchCriterion.eq((String)TemplateDocumentIndex.Property.type.name(), (Object)TemplateType.PRINTFORM));
        result.getSearchCriterions().add(SearchCriterion.eq((String)TemplateDocumentIndex.Property.templateId.name(), (Object)"certificate-of-completed-flight"));
        result.getSearchCriterions().add(SearchCriterion.ne((String)TemplateDocumentIndex.Property.disabled.name(), (Object)Boolean.TRUE));
        ListParametersHelper.setFilters(result, TemplateDocumentIndex.Property.type.name(), TemplateDocumentIndex.Property.title.name());
        ListParametersHelper.setColumns(result, TemplateDocumentIndex.Property.type.name(), TemplateDocumentIndex.Property.title.name());
        return result;
    }

    public static IndexListParameters<TemplateDocument, TemplateDocumentIndex> getItineraryTemplates() {
        IndexListParameters result = new IndexListParameters();
        result.setIndexType(TemplateDocumentIndex.class);
        result.getSortings().put(TemplateDocumentIndex.Property.title.name(), SortOrder.ASC);
        result.getSearchCriterions().add(SearchCriterion.eq((String)TemplateDocumentIndex.Property.type.name(), (Object)TemplateType.PRINTFORM));
        result.getSearchCriterions().add(SearchCriterion.eq((String)TemplateDocumentIndex.Property.templateId.name(), (Object)"itinerary-receipt"));
        result.getSearchCriterions().add(SearchCriterion.ne((String)TemplateDocumentIndex.Property.disabled.name(), (Object)Boolean.TRUE));
        ListParametersHelper.setFilters(result, TemplateDocumentIndex.Property.type.name(), TemplateDocumentIndex.Property.title.name());
        ListParametersHelper.setColumns(result, TemplateDocumentIndex.Property.type.name(), TemplateDocumentIndex.Property.title.name());
        return result;
    }

    public static IndexListParameters<TemplateDocument, TemplateDocumentIndex> getRailwayItineraryTemplates() {
        IndexListParameters result = new IndexListParameters();
        result.setIndexType(TemplateDocumentIndex.class);
        result.getSortings().put(TemplateDocumentIndex.Property.title.name(), SortOrder.ASC);
        result.getSearchCriterions().add(SearchCriterion.eq((String)TemplateDocumentIndex.Property.type.name(), (Object)TemplateType.PRINTFORM));
        result.getSearchCriterions().add(SearchCriterion.eq((String)TemplateDocumentIndex.Property.templateId.name(), (Object)"railway-itinerary-receipt"));
        result.getSearchCriterions().add(SearchCriterion.ne((String)TemplateDocumentIndex.Property.disabled.name(), (Object)Boolean.TRUE));
        ListParametersHelper.setFilters(result, TemplateDocumentIndex.Property.type.name(), TemplateDocumentIndex.Property.title.name());
        ListParametersHelper.setColumns(result, TemplateDocumentIndex.Property.type.name(), TemplateDocumentIndex.Property.title.name());
        return result;
    }

    public static IndexListParameters<TemplateDocument, TemplateDocumentIndex> getTransferItineraryTemplates() {
        IndexListParameters result = new IndexListParameters();
        result.setIndexType(TemplateDocumentIndex.class);
        result.getSortings().put(TemplateDocumentIndex.Property.title.name(), SortOrder.ASC);
        result.getSearchCriterions().add(SearchCriterion.eq((String)TemplateDocumentIndex.Property.type.name(), (Object)TemplateType.PRINTFORM));
        result.getSearchCriterions().add(SearchCriterion.eq((String)TemplateDocumentIndex.Property.templateId.name(), (Object)"transfer-itinerary-receipt"));
        result.getSearchCriterions().add(SearchCriterion.ne((String)TemplateDocumentIndex.Property.disabled.name(), (Object)Boolean.TRUE));
        ListParametersHelper.setFilters(result, TemplateDocumentIndex.Property.type.name(), TemplateDocumentIndex.Property.title.name());
        ListParametersHelper.setColumns(result, TemplateDocumentIndex.Property.type.name(), TemplateDocumentIndex.Property.title.name());
        return result;
    }

    public static IndexListParameters<TemplateDocument, TemplateDocumentIndex> getRefundTemplates() {
        IndexListParameters result = new IndexListParameters();
        result.setIndexType(TemplateDocumentIndex.class);
        result.getSortings().put(TemplateDocumentIndex.Property.title.name(), SortOrder.ASC);
        result.getSearchCriterions().add(SearchCriterion.eq((String)TemplateDocumentIndex.Property.type.name(), (Object)TemplateType.PRINTFORM));
        result.getSearchCriterions().add(SearchCriterion.eq((String)TemplateDocumentIndex.Property.templateId.name(), (Object)"refund-receipt"));
        result.getSearchCriterions().add(SearchCriterion.ne((String)TemplateDocumentIndex.Property.disabled.name(), (Object)Boolean.TRUE));
        ListParametersHelper.setFilters(result, TemplateDocumentIndex.Property.type.name(), TemplateDocumentIndex.Property.title.name());
        ListParametersHelper.setColumns(result, TemplateDocumentIndex.Property.type.name(), TemplateDocumentIndex.Property.title.name());
        return result;
    }

    public static IndexListParameters<TemplateDocument, TemplateDocumentIndex> getRailwayRefundTemplates() {
        IndexListParameters result = new IndexListParameters();
        result.setIndexType(TemplateDocumentIndex.class);
        result.getSortings().put(TemplateDocumentIndex.Property.title.name(), SortOrder.ASC);
        result.getSearchCriterions().add(SearchCriterion.eq((String)TemplateDocumentIndex.Property.type.name(), (Object)TemplateType.PRINTFORM));
        result.getSearchCriterions().add(SearchCriterion.eq((String)TemplateDocumentIndex.Property.templateId.name(), (Object)"railway-refund-receipt"));
        result.getSearchCriterions().add(SearchCriterion.ne((String)TemplateDocumentIndex.Property.disabled.name(), (Object)Boolean.TRUE));
        ListParametersHelper.setFilters(result, TemplateDocumentIndex.Property.type.name(), TemplateDocumentIndex.Property.title.name());
        ListParametersHelper.setColumns(result, TemplateDocumentIndex.Property.type.name(), TemplateDocumentIndex.Property.title.name());
        return result;
    }

    public static IndexListParameters<TemplateDocument, TemplateDocumentIndex> getVoucherTemplates() {
        IndexListParameters result = new IndexListParameters();
        result.setIndexType(TemplateDocumentIndex.class);
        result.getSortings().put(TemplateDocumentIndex.Property.title.name(), SortOrder.ASC);
        result.getSearchCriterions().add(SearchCriterion.eq((String)TemplateDocumentIndex.Property.type.name(), (Object)TemplateType.PRINTFORM));
        result.getSearchCriterions().add(SearchCriterion.eq((String)TemplateDocumentIndex.Property.templateId.name(), (Object)"voucher-template"));
        result.getSearchCriterions().add(SearchCriterion.ne((String)TemplateDocumentIndex.Property.disabled.name(), (Object)Boolean.TRUE));
        ListParametersHelper.setFilters(result, TemplateDocumentIndex.Property.type.name(), TemplateDocumentIndex.Property.title.name());
        ListParametersHelper.setColumns(result, TemplateDocumentIndex.Property.type.name(), TemplateDocumentIndex.Property.title.name());
        return result;
    }

    public static IndexListParameters<SalesPoint, SalesPointIndex> getSalesPoints() {
        IndexListParameters result = new IndexListParameters();
        result.setIndexType(SalesPointIndex.class);
        result.getSortings().put(SalesPointIndex.Property.code.name(), SortOrder.ASC);
        result.getSearchCriterions().add(SearchCriterion.eq((String)SalesPointIndex.Property.disabled.name(), (Object)Boolean.FALSE));
        ListParametersHelper.setFilters(result, SalesPointIndex.Property.shortName.name(), SalesPointIndex.Property.fullName.name(), SalesPointIndex.Property.agency.name());
        ListParametersHelper.setColumns(result, SalesPointIndex.Property.shortName.name(), SalesPointIndex.Property.fullName.name(), SalesPointIndex.Property.agency.name());
        return result;
    }

    public static IndexListParameters<SalesPoint, SalesPointIndex> getSalesPoints(EntityReference<Organization> subAgency) {
        IndexListParameters result = new IndexListParameters();
        if (subAgency != null) {
            result.getSearchCriterions().add(SearchCriterion.eq((String)SalesPointIndex.Property.agency.name(), subAgency));
        }
        result.getSearchCriterions().add(SearchCriterion.eq((String)SalesPointIndex.Property.disabled.name(), (Object)Boolean.FALSE));
        result.setIndexType(SalesPointIndex.class);
        result.getSortings().put(SalesPointIndex.Property.code.name(), SortOrder.ASC);
        ListParametersHelper.setFilters(result, SalesPointIndex.Property.shortName.name(), SalesPointIndex.Property.fullName.name(), SalesPointIndex.Property.agency.name());
        ListParametersHelper.setColumns(result, SalesPointIndex.Property.shortName.name(), SalesPointIndex.Property.fullName.name(), SalesPointIndex.Property.agency.name());
        return result;
    }

    public static IndexListParameters<CommissionProperties, CommissionPropertiesIndex> getCommissions(RuleTarget target) {
        List<ProductType> types;
        IndexListParameters result = new IndexListParameters();
        if (target != null && CollectionUtil.isNotEmpty(types = ControllerInterceptorsHelper.productTypesFromTarget(target))) {
            result.getSearchCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchQueryHelper.buildOrContainsEnumCriterion((String)CommissionPropertiesIndex.Property.productTypes.name(), types), SearchCriterion.isEmpty((String)CommissionPropertiesIndex.Property.productTypes.name())}));
            result.getSearchCriterions().add(SearchCriterion.ne((String)CommissionPropertiesIndex.Property.disabled.name(), (Object)Boolean.TRUE));
        }
        result.setIndexType(CommissionPropertiesIndex.class);
        result.getSortings().put(CommissionPropertiesIndex.Property.displayName.name(), SortOrder.ASC);
        ListParametersHelper.setFilters(result, CommissionPropertiesIndex.Property.category.name(), CommissionPropertiesIndex.Property.roundingMode.name(), CommissionPropertiesIndex.Property.calculationBasis.name(), CommissionPropertiesIndex.Property.productTypes.name());
        ListParametersHelper.setColumns(result, CommissionPropertiesIndex.Property.displayName.name(), CommissionPropertiesIndex.Property.category.name(), CommissionPropertiesIndex.Property.calculationBasis.name(), CommissionPropertiesIndex.Property.productTypes.name(), CommissionPropertiesIndex.Property.minimum.name());
        return result;
    }

    public static IndexListParameters<DiscountProperties, DiscountPropertiesIndex> getDiscounts() {
        IndexListParameters result = new IndexListParameters();
        result.getSearchCriterions().add(SearchCriterion.ne((String)DiscountPropertiesIndex.Property.disabled.name(), (Object)Boolean.TRUE));
        result.setIndexType(DiscountPropertiesIndex.class);
        ListParametersHelper.setColumns(result, DiscountPropertiesIndex.Property.displayName.name(), DiscountPropertiesIndex.Property.category.name(), DiscountPropertiesIndex.Property.rate.name(), DiscountPropertiesIndex.Property.roundingMode.name(), DiscountPropertiesIndex.Property.roundingValue.name());
        return result;
    }

    public static IndexListParameters<PaymentFeeProperties, PaymentFeePropertiesIndex> getPaymentFees() {
        IndexListParameters result = new IndexListParameters();
        result.getSearchCriterions().add(SearchCriterion.ne((String)PaymentFeePropertiesIndex.Property.disabled.name(), (Object)Boolean.TRUE));
        result.setIndexType(PaymentFeePropertiesIndex.class);
        ListParametersHelper.setColumns(result, PaymentFeePropertiesIndex.Property.paymentType.name(), PaymentFeePropertiesIndex.Property.rate.name(), PaymentFeePropertiesIndex.Property.type.name(), PaymentFeePropertiesIndex.Property.basis.name(), PaymentFeePropertiesIndex.Property.returnCases.name());
        return result;
    }

    public static IndexListParameters<FeeProperties, FeePropertiesIndex> getFees(RuleTarget target) {
        List<ProductType> types;
        IndexListParameters result = new IndexListParameters();
        if (target != null && CollectionUtil.isNotEmpty(types = ControllerInterceptorsHelper.productTypesFromTarget(target))) {
            result.getSearchCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchQueryHelper.buildOrContainsEnumCriterion((String)FeePropertiesIndex.Property.productTypes.name(), types), SearchCriterion.isEmpty((String)FeePropertiesIndex.Property.productTypes.name())}));
            result.getSearchCriterions().add(SearchCriterion.ne((String)FeePropertiesIndex.Property.disabled.name(), (Object)Boolean.TRUE));
        }
        result.setIndexType(FeePropertiesIndex.class);
        result.getSortings().put(FeePropertiesIndex.Property.displayName.name(), SortOrder.ASC);
        ListParametersHelper.setFilters(result, FeePropertiesIndex.Property.category.name(), FeePropertiesIndex.Property.roundingMode.name(), FeePropertiesIndex.Property.calculationBasis.name(), FeePropertiesIndex.Property.productTypes.name());
        ListParametersHelper.setColumns(result, FeePropertiesIndex.Property.displayName.name(), FeePropertiesIndex.Property.category.name(), FeePropertiesIndex.Property.calculationBasis.name(), FeePropertiesIndex.Property.productTypes.name());
        return result;
    }

    public static IndexListParameters<SalesPoint, SalesPointIndex> getActiveSalesPoints() {
        IndexListParameters<SalesPoint, SalesPointIndex> result = ControllerInterceptorsHelper.getSalesPoints();
        result.getSearchCriterions().add(SearchCriterion.eq((String)SalesPointIndex.Property.disabled.name(), (Object)Boolean.FALSE));
        return result;
    }

    public static MultiSupplier<IndexListParameters<Organization, ?>> getAgenciesAndBlankOwnersMulti() {
        return new MultiSupplier<IndexListParameters<Organization, ?>>(){

            public String getDisplayName(int idx) {
                switch (idx) {
                    case 0: {
                        return Messages.Agency;
                    }
                    case 1: {
                        return Messages.Letterhead_owner;
                    }
                }
                throw new IndexOutOfBoundsException();
            }

            public IndexListParameters<Organization, ?> get(int idx) {
                switch (idx) {
                    case 0: {
                        return ControllerInterceptorsHelper.getAgencies();
                    }
                    case 1: {
                        return ControllerInterceptorsHelper.getBlankOwners();
                    }
                }
                throw new IndexOutOfBoundsException();
            }

            public int count() {
                return 2;
            }
        };
    }

    public static MultiSupplier<IndexListParameters<Organization, ?>> getAgenciesAndClientsMulti() {
        return new MultiSupplier<IndexListParameters<Organization, ?>>(){

            public String getDisplayName(int idx) {
                switch (idx) {
                    case 0: {
                        return Messages.Agency;
                    }
                    case 1: {
                        return Messages.Client;
                    }
                }
                throw new IndexOutOfBoundsException();
            }

            public IndexListParameters<Organization, ?> get(int idx) {
                switch (idx) {
                    case 0: {
                        return ControllerInterceptorsHelper.getAgencies();
                    }
                    case 1: {
                        return ControllerInterceptorsHelper.getClients();
                    }
                }
                throw new IndexOutOfBoundsException();
            }

            public int count() {
                return 2;
            }
        };
    }

    public static IndexListParameters<Person, PersonIndex> getPassengers() {
        IndexListParameters<Person, PersonIndex> params = ControllerInterceptorsHelper.getPersonsSortByCode();
        params.getSearchCriterions().add(SearchCriterion.contains((String)PersonIndex.Property.types.name(), (Object)PersonType.PASSENGER.name()));
        return params;
    }

    public static IndexListParameters<Contract, ContractCustomerIndex> getContracts(EntityReference<Organization> organization, EntityReference<? extends BaseProfile> payer) {
        IndexListParameters params = new IndexListParameters();
        params.setIndexType(ContractCustomerIndex.class);
        if (organization != null && payer != null) {
            params.getSearchCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.supplier.name(), organization), SearchCriterion.eq((String)ContractCustomerIndex.Property.customer.name(), payer)}), SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.supplier.name(), payer), SearchCriterion.eq((String)ContractCustomerIndex.Property.customer.name(), organization)})}));
        } else if (organization != null) {
            params.getSearchCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.supplier.name(), organization), SearchCriterion.eq((String)ContractCustomerIndex.Property.customer.name(), organization)}));
        } else if (payer != null) {
            params.getSearchCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.supplier.name(), payer), SearchCriterion.eq((String)ContractCustomerIndex.Property.customer.name(), payer)}));
        }
        params.getSortings().put(ContractCustomerIndex.Property.supplier.name(), SortOrder.ASC);
        ListParametersHelper.setFilters(params, ContractCustomerIndex.Property.customer.name(), ContractCustomerIndex.Property.supplier.name(), ContractCustomerIndex.Property.vendorContractType.name());
        ListParametersHelper.setColumns(params, ContractCustomerIndex.Property.name.name(), ContractCustomerIndex.Property.customer.name(), ContractCustomerIndex.Property.supplier.name(), ContractCustomerIndex.Property.vendorContractType.name());
        return params;
    }

    public static MultiSupplier<IndexListParameters<BaseProfile, ?>> getAgenciesAndBlankOwnersAndClientAndPassenger() {
        return new MultiSupplier<IndexListParameters<BaseProfile, ?>>(){

            public String getDisplayName(int idx) {
                switch (idx) {
                    case 0: {
                        return Messages.Agency;
                    }
                    case 1: {
                        return Messages.Letterhead_owner;
                    }
                    case 2: {
                        return Messages.Corp_client;
                    }
                    case 3: {
                        return Messages.Traveler;
                    }
                }
                throw new IndexOutOfBoundsException();
            }

            public IndexListParameters<BaseProfile, ?> get(int idx) {
                switch (idx) {
                    case 0: {
                        return ControllerInterceptorsHelper.getAgencies();
                    }
                    case 1: {
                        return ControllerInterceptorsHelper.getBlankOwners();
                    }
                    case 2: {
                        return ControllerInterceptorsHelper.getClients();
                    }
                    case 3: {
                        return ControllerInterceptorsHelper.getPassengers();
                    }
                }
                throw new IndexOutOfBoundsException();
            }

            public int count() {
                return 4;
            }
        };
    }

    public static MultiSupplier<IndexListParameters<Organization, ?>> getAgenciesAndBlankOwnersAndClient() {
        return new MultiSupplier<IndexListParameters<Organization, ?>>(){

            public String getDisplayName(int idx) {
                switch (idx) {
                    case 0: {
                        return Messages.Agency;
                    }
                    case 1: {
                        return Messages.Letterhead_owner;
                    }
                    case 2: {
                        return Messages.Corp_client;
                    }
                }
                throw new IndexOutOfBoundsException();
            }

            public IndexListParameters<Organization, ?> get(int idx) {
                switch (idx) {
                    case 0: {
                        return ControllerInterceptorsHelper.getAgencies();
                    }
                    case 1: {
                        return ControllerInterceptorsHelper.getBlankOwners();
                    }
                    case 2: {
                        return ControllerInterceptorsHelper.getClients();
                    }
                }
                throw new IndexOutOfBoundsException();
            }

            public int count() {
                return 3;
            }
        };
    }

    public static MultiSupplier<IndexListParameters<BaseProfile, ?>> getProfileMulti() {
        return new MultiSupplier<IndexListParameters<BaseProfile, ?>>(){

            public String getDisplayName(int idx) {
                switch (idx) {
                    case 0: {
                        return Messages.Agency;
                    }
                    case 1: {
                        return Messages.Dimension_sales_point;
                    }
                    case 2: {
                        return Messages.Dimension_agent;
                    }
                    case 3: {
                        return Messages.Dimension_cash_register_workplace;
                    }
                }
                throw new IndexOutOfBoundsException();
            }

            public IndexListParameters<BaseProfile, ?> get(int idx) {
                switch (idx) {
                    case 0: {
                        return ControllerInterceptorsHelper.getAgencies();
                    }
                    case 1: {
                        return ControllerInterceptorsHelper.getSalesPoints();
                    }
                    case 2: {
                        return ControllerInterceptorsHelper.getEmployees();
                    }
                    case 3: {
                        return ControllerInterceptorsHelper.getCashRegisterWorkplaces();
                    }
                }
                throw new IndexOutOfBoundsException();
            }

            public int count() {
                return 4;
            }
        };
    }

    public static MultiSupplier<IndexListParameters<BaseExchangeDocument, ?>> getExchangeDocumentsMulti() {
        return new MultiSupplier<IndexListParameters<BaseExchangeDocument, ?>>(){

            public String getDisplayName(int idx) {
                switch (idx) {
                    case 0: {
                        return Messages.Sabre_files;
                    }
                    case 1: {
                        return Messages.Sirena_files;
                    }
                    case 2: {
                        return Messages.Gabriel_files;
                    }
                    case 3: {
                        return Messages.Gabriel_Ret_files;
                    }
                    case 4: {
                        return Messages.All_type_documents;
                    }
                }
                throw new IndexOutOfBoundsException();
            }

            public IndexListParameters<BaseExchangeDocument, ?> get(int idx) {
                switch (idx) {
                    case 0: {
                        return ControllerInterceptorsHelper.getIurExchangeDocuments();
                    }
                    case 1: {
                        return ControllerInterceptorsHelper.getSirenaXmlExchangeDocuments();
                    }
                    case 2: {
                        return ControllerInterceptorsHelper.getGabrielMaskExchangeDocuments();
                    }
                    case 3: {
                        return ControllerInterceptorsHelper.getRetExchangeDocuments();
                    }
                    case 4: {
                        return ControllerInterceptorsHelper.getBasicDocuments();
                    }
                }
                throw new IndexOutOfBoundsException();
            }

            public int count() {
                return 5;
            }
        };
    }

    public static IndexListParameters<CashRegisterWorkplace, CashRegisterWorkplaceIndex> getCashRegisterWorkplaces() {
        IndexListParameters result = new IndexListParameters();
        result.setIndexType(CashRegisterWorkplaceIndex.class);
        result.getSortings().put(CashRegisterWorkplaceIndex.Property.name.name(), SortOrder.ASC);
        ListParametersHelper.setFilters(result, CashRegisterWorkplaceIndex.Property.name.name(), CashRegisterWorkplaceIndex.Property.salesPoint.name());
        ListParametersHelper.setColumns(result, CashRegisterWorkplaceIndex.Property.name.name(), CashRegisterWorkplaceIndex.Property.salesPoint.name());
        return result;
    }

    public static IndexListParameters<Cash, CashIndex> getCashes() {
        IndexListParameters result = new IndexListParameters();
        result.setIndexType(CashIndex.class);
        result.getSortings().put(CashIndex.Property.name.name(), SortOrder.ASC);
        ListParametersHelper.setFilters(result, CashIndex.Property.name.name(), CashIndex.Property.owner.name(), CashIndex.Property.disabled.name());
        ListParametersHelper.setColumns(result, CashIndex.Property.name.name(), CashIndex.Property.owner.name(), CashIndex.Property.disabled.name());
        return result;
    }

    public static IndexListParameters<Cash, CashIndex> getCashesForOrganization(EntityReference<Organization> orgRef) {
        IndexListParameters result = new IndexListParameters();
        result.getSearchCriterions().add(SearchCriterion.eq((String)CashIndex.Property.organization.name(), orgRef));
        result.getSearchCriterions().add(SearchCriterion.eq((String)SalesPointIndex.Property.disabled.name(), (Object)Boolean.FALSE));
        result.setIndexType(CashIndex.class);
        result.getSortings().put(CashIndex.Property.name.name(), SortOrder.ASC);
        ListParametersHelper.setFilters(result, CashIndex.Property.name.name(), CashIndex.Property.owner.name(), CashIndex.Property.disabled.name());
        ListParametersHelper.setColumns(result, CashIndex.Property.name.name(), CashIndex.Property.owner.name(), CashIndex.Property.disabled.name());
        return result;
    }

    public static IndexListParameters<CashRegister, CashRegisterIndex> getCashRegisters() {
        IndexListParameters result = new IndexListParameters();
        result.setIndexType(CashRegisterIndex.class);
        result.getSortings().put(CashRegisterIndex.Property.name.name(), SortOrder.ASC);
        ListParametersHelper.setFilters(result, CashRegisterIndex.Property.name.name(), CashRegisterIndex.Property.salesPoint.name(), CashRegisterIndex.Property.disabled.name());
        ListParametersHelper.setColumns(result, CashRegisterIndex.Property.name.name(), CashRegisterIndex.Property.number.name(), CashRegisterIndex.Property.registryNumber.name(), CashRegisterIndex.Property.model.name(), CashRegisterIndex.Property.salesPoint.name(), CashRegisterIndex.Property.disabled.name());
        return result;
    }

    public static IndexListParameters<Worklog, WorklogIndex> getWorklogs() {
        IndexListParameters result = new IndexListParameters();
        result.setIndexType(WorklogIndex.class);
        result.getSortings().put(WorklogIndex.Property.employee.name(), SortOrder.ASC);
        ListParametersHelper.setFilters(result, WorklogIndex.Property.agency.name(), WorklogIndex.Property.salesPoint.name(), WorklogIndex.Property.types.name());
        ListParametersHelper.setColumns(result, WorklogIndex.Property.agency.name(), WorklogIndex.Property.startDate.name(), WorklogIndex.Property.endDate.name(), WorklogIndex.Property.cashRegisterWorkplace.name(), WorklogIndex.Property.employee.name(), WorklogIndex.Property.salesPoint.name());
        return result;
    }

    public static IndexListParameters<Branch, BranchIndex> getActiveBranches() {
        IndexListParameters result = new IndexListParameters();
        result.setIndexType(BranchIndex.class);
        result.getSortings().put(BranchIndex.Property.code.name(), SortOrder.ASC);
        result.getSearchCriterions().add(SearchCriterion.eq((String)BranchIndex.Property.disabled.name(), (Object)Boolean.FALSE));
        ListParametersHelper.setFilters(result, BranchIndex.Property.agency.name());
        ListParametersHelper.setColumns(result, BranchIndex.Property.code.name(), BranchIndex.Property.shortName.name(), BranchIndex.Property.fullName.name());
        return result;
    }

    public static IndexListParameters<BookingFile, BookingFileIndex> getOrders() {
        IndexListParameters result = new IndexListParameters();
        result.setIndexType(BookingFileIndex.class);
        result.getSortings().put(BookingFileIndex.Property.fullNumber.name(), SortOrder.ASC);
        ListParametersHelper.setFilters(result, BookingFileIndex.Property.fullNumber.name(), BookingFileIndex.Property.createDate.name(), BookingFileIndex.Property.client.name());
        ListParametersHelper.setColumns(result, BookingFileIndex.Property.fullNumber.name(), BookingFileIndex.Property.createDate.name(), BookingFileIndex.Property.client.name());
        return result;
    }

    public static IndexListParameters<Contract, ContractIndex> getEnabledContracts() {
        IndexListParameters<Contract, ContractIndex> params = ControllerInterceptorsHelper.getContracts();
        params.getSearchCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.disabled.name(), (Object)Boolean.FALSE));
        return params;
    }

    public static IndexListParameters<Contract, ContractIndex> getContracts() {
        IndexListParameters result = new IndexListParameters();
        result.setIndexType(ContractIndex.class);
        result.getSortings().put(ContractIndex.Property.name.name(), SortOrder.ASC);
        ListParametersHelper.setFilters(result, ContractIndex.Property.contractType.name(), ContractIndex.Property.name.name(), ContractIndex.Property.vendor.name(), ContractIndex.Property.supplier.name());
        ListParametersHelper.setColumns(result, ContractIndex.Property.contractType.name(), ContractIndex.Property.name.name(), ContractIndex.Property.vendor.name(), ContractIndex.Property.supplier.name());
        return result;
    }

    public static IndexListParameters<Contract, ContractIndex> getContractsByType(ContractType contractType) {
        IndexListParameters result = new IndexListParameters();
        result.setIndexType(ContractIndex.class);
        result.getSortings().put(ContractIndex.Property.name.name(), SortOrder.ASC);
        result.getSearchCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.contractType.name(), (Object)contractType));
        ListParametersHelper.setFilters(result, ContractIndex.Property.name.name(), ContractIndex.Property.vendor.name(), ContractIndex.Property.supplier.name());
        ListParametersHelper.setColumns(result, ContractIndex.Property.name.name(), ContractIndex.Property.vendor.name(), ContractIndex.Property.supplier.name());
        return result;
    }

    public static IndexListParameters<TripartiteContract, TripartiteContractIndex> getTripartiteContracts() {
        IndexListParameters result = new IndexListParameters();
        result.setIndexType(TripartiteContractIndex.class);
        result.getSortings().put(TripartiteContractIndex.Property.name.name(), SortOrder.ASC);
        ListParametersHelper.setFilters(result, TripartiteContractIndex.Property.contractType.name(), TripartiteContractIndex.Property.name.name(), TripartiteContractIndex.Property.agency.name());
        ListParametersHelper.setColumns(result, TripartiteContractIndex.Property.contractType.name(), TripartiteContractIndex.Property.name.name(), TripartiteContractIndex.Property.agency.name());
        return result;
    }

    public static IndexListParameters<IurExchangeDocument, IurExchangeDocumentIndex> getIurExchangeDocuments() {
        IndexListParameters result = new IndexListParameters();
        result.setIndexType(IurExchangeDocumentIndex.class);
        result.getSortings().put(IurExchangeDocumentIndex.Property.created.name(), SortOrder.DESC);
        ListParametersHelper.setFilters(result, IurExchangeDocumentIndex.Property.iurTransactionType.name(), IurExchangeDocumentIndex.Property.pnr.name(), IurExchangeDocumentIndex.Property.ticketNumbers.name());
        ListParametersHelper.setColumns(result, IurExchangeDocumentIndex.Property.location.name(), IurExchangeDocumentIndex.Property.pnr.name(), IurExchangeDocumentIndex.Property.iurTransactionType.name(), IurExchangeDocumentIndex.Property.ticketNumbers.name(), IurExchangeDocumentIndex.Property.issued.name());
        return result;
    }

    public static IndexListParameters<SirenaXmlExchangeDocument, SirenaXmlExchangeDocumentIndex> getSirenaXmlExchangeDocuments() {
        IndexListParameters result = new IndexListParameters();
        result.setIndexType(SirenaXmlExchangeDocumentIndex.class);
        result.getSortings().put(SirenaXmlExchangeDocumentIndex.Property.created.name(), SortOrder.DESC);
        ListParametersHelper.setFilters(result, SirenaXmlExchangeDocumentIndex.Property.PNR.name(), SirenaXmlExchangeDocumentIndex.Property.transactionType.name(), SirenaXmlExchangeDocumentIndex.Property.ticketNumber.name());
        ListParametersHelper.setColumns(result, SirenaXmlExchangeDocumentIndex.Property.location.name(), SirenaXmlExchangeDocumentIndex.Property.PNR.name(), SirenaXmlExchangeDocumentIndex.Property.transactionType.name(), SirenaXmlExchangeDocumentIndex.Property.ticketNumber.name(), SirenaXmlExchangeDocumentIndex.Property.operationDate.name());
        return result;
    }

    public static IndexListParameters<GabrielMaskExchangeDocument, GabrielMaskExchangeDocumentIndex> getGabrielMaskExchangeDocuments() {
        IndexListParameters result = new IndexListParameters();
        result.setIndexType(GabrielMaskExchangeDocumentIndex.class);
        result.getSortings().put(GabrielMaskExchangeDocumentIndex.Property.created.name(), SortOrder.DESC);
        ListParametersHelper.setFilters(result, GabrielMaskExchangeDocumentIndex.Property.transactionType.name(), GabrielMaskExchangeDocumentIndex.Property.ticketNumber.name());
        ListParametersHelper.setColumns(result, GabrielMaskExchangeDocumentIndex.Property.location.name(), GabrielMaskExchangeDocumentIndex.Property.transactionType.name(), GabrielMaskExchangeDocumentIndex.Property.ticketNumber.name(), GabrielMaskExchangeDocumentIndex.Property.operationDate.name());
        return result;
    }

    public static IndexListParameters<RetExchangeDocument, RetExchangeDocumentIndex> getRetExchangeDocuments() {
        IndexListParameters result = new IndexListParameters();
        result.setIndexType(RetExchangeDocumentIndex.class);
        result.getSortings().put(RetExchangeDocumentIndex.Property.created.name(), SortOrder.DESC);
        ListParametersHelper.setFilters(result, RetExchangeDocumentIndex.Property.transactionName.name(), RetExchangeDocumentIndex.Property.travellerName.name(), RetExchangeDocumentIndex.Property.ticketNumber.name());
        ListParametersHelper.setColumns(result, RetExchangeDocumentIndex.Property.location.name(), RetExchangeDocumentIndex.Property.transactionName.name(), RetExchangeDocumentIndex.Property.transactionNumber.name(), RetExchangeDocumentIndex.Property.ticketNumber.name(), RetExchangeDocumentIndex.Property.travellerName.name(), RetExchangeDocumentIndex.Property.issued.name());
        return result;
    }

    public static IndexListParameters<BaseCommonExportSettings, BasicCommonExportSettingsIndex> getCommonExportSettings() {
        IndexListParameters result = new IndexListParameters();
        result.setIndexType(BasicCommonExportSettingsIndex.class);
        ListParametersHelper.setColumns(result, BasicCommonExportSettingsIndex.Property.name.name(), BasicCommonExportSettingsIndex.Property.exportCategory.name());
        return result;
    }

    public static IndexListParameters<BaseCommonConnectionSettings, BasicCommonConnectionSettingsIndex> getCommonConnectionSettings() {
        IndexListParameters result = new IndexListParameters();
        result.setIndexType(BasicCommonConnectionSettingsIndex.class);
        ListParametersHelper.setColumns(result, BasicCommonConnectionSettingsIndex.Property.name.name(), BasicCommonConnectionSettingsIndex.Property.connectionType.name());
        return result;
    }

    public static IndexListParameters<BaseFileDocument, BasicDocumentIndex> getBasicDocuments() {
        IndexListParameters result = new IndexListParameters();
        result.setIndexType(BasicDocumentIndex.class);
        result.getSortings().put(BasicDocumentIndex.Property.created.name(), SortOrder.DESC);
        ListParametersHelper.setFilters(result, BasicDocumentIndex.Property.contentType.name(), BasicDocumentIndex.Property.type.name(), BasicDocumentIndex.Property.title.name());
        ListParametersHelper.setColumns(result, BasicDocumentIndex.Property.title.name(), BasicDocumentIndex.Property.name.name(), BasicDocumentIndex.Property.contentType.name(), BasicDocumentIndex.Property.type.name(), BasicDocumentIndex.Property.created.name());
        return result;
    }

    public static IndexListParameters<Organization, ?> getPayers(List<String> payerUids) {
        IndexListParameters result = new IndexListParameters();
        result.setIndexType(OrganizationIndex.class);
        ListParametersHelper.setFilters(result, OrganizationIndex.Property.shortName.name(), OrganizationIndex.Property.name.name(), OrganizationIndex.Property.code.name());
        ListParametersHelper.setColumns(result, OrganizationIndex.Property.shortName.name(), OrganizationIndex.Property.name.name(), OrganizationIndex.Property.code.name());
        result.getSearchCriterions().add(SearchCriterion.in((String)"containerUid", (Object[])payerUids.toArray()));
        return result;
    }

    public static boolean matches(String pattern, Object ... values) {
        if (TextUtil.isBlank((String)pattern) || values == null || values.length == 0) {
            return true;
        }
        String paternLowerCase = pattern.trim().toLowerCase(Locale.ROOT);
        for (Object value : values) {
            if (value == null || !String.valueOf(value).toLowerCase(Locale.ROOT).contains(paternLowerCase)) continue;
            return true;
        }
        return false;
    }

    public static boolean matches(LocalDate patternStart, LocalDate patternEnd, LocalDate valueStart, LocalDate valueEnd) {
        LocalDate sd = ControllerInterceptorsHelper.getMinimumDate(valueStart);
        LocalDate ed = ControllerInterceptorsHelper.getMaximumDate(valueEnd);
        LocalDate ssd = ControllerInterceptorsHelper.getMinimumDate(patternStart);
        LocalDate sed = ControllerInterceptorsHelper.getMaximumDate(patternEnd);
        return sd.compareTo(sed) <= 0 && ed.compareTo(ssd) >= 0;
    }

    public static boolean matches(VendorContractType pattern, VendorContractType value) {
        return pattern == null || pattern == value;
    }

    private static LocalDate getMaximumDate(LocalDate value) {
        return value == null ? LocalDate.MAX : value;
    }

    private static LocalDate getMinimumDate(LocalDate value) {
        return value == null ? LocalDate.MIN : value;
    }

    public static DictListParameters getGeoLocations() {
        DictListParameters result = new DictListParameters();
        result.getColumns().add(DictHandlersHelper.COL_CODE_VARIANTS);
        result.getColumns().add(DictHandlersHelper.COL_TRANSLATIONS);
        result.getColumns().add(DictHandlersHelper.createColumn(GeoLocation.class, GeoLocation.Property.type.name(), Messages.Point_type, (Renderer)StandardRenderers.GENERIC));
        result.getColumns().add(DictHandlersHelper.createColumn(GeoLocation.class, GeoLocation.Property.country.name(), Messages.Country, (Renderer)StandardRenderers.GENERIC));
        result.getFilters().add(DictHandlersHelper.createColumn(GeoLocation.class, GeoLocation.Property.type.name(), Messages.Point_type, (Renderer)StandardRenderers.GENERIC));
        result.getFilters().add(DictHandlersHelper.createColumn(GeoLocation.class, GeoLocation.Property.country.name(), Messages.Country, (Renderer)StandardRenderers.GENERIC));
        result.getFilters().add(DictHandlersHelper.createColumn(GeoLocation.class, GeoLocation.Property.parent.name(), Messages.Affiliation, (Renderer)StandardRenderers.GENERIC));
        return result;
    }

    public static List<ProductType> productTypesFromTarget(RuleTarget target) {
        if (target instanceof UniversalProductRuleEnvironment.UniversalProductRuleTarget || target instanceof UniversalProductNomenclatureRulesEnvironment.UniversalProductNomenclatureRuleTarget) {
            return new ArrayList<ProductType>(new UniversalProductHandler().getAllProductTypes());
        }
        HashSet result = new HashSet();
        for (ProductHandler handler : HandlersRegistry.get().getAllProductHandlers()) {
            if (handler instanceof UniversalProductHandler || !Objects.equals(target.getId(), Optional.ofNullable(handler.getCommissionRuleTarget()).map(RuleTarget::getId).orElse(null))) continue;
            result.addAll(handler.getAllProductTypes());
        }
        return new ArrayList<ProductType>(result);
    }

    public static IndexListParameters<ModelContract, ModelContractIndex> getModelContract() {
        IndexListParameters result = new IndexListParameters();
        result.setIndexType(ModelContractIndex.class);
        result.getSortings().put(ModelContractIndex.Property.priority.name(), SortOrder.DESC);
        ListParametersHelper.setFilters(result, ModelContractIndex.Property.contractType.name(), ModelContractIndex.Property.priority.name(), ModelContractIndex.Property.disabled.name());
        ListParametersHelper.setColumns(result, ModelContractIndex.Property.name.name(), ModelContractIndex.Property.contractType.name(), ModelContractIndex.Property.customers.name(), ModelContractIndex.Property.priority.name(), ModelContractIndex.Property.disabled.name());
        return result;
    }
}

