/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.helpers;

import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.registry.basic.Renderer;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.model.dict.CodeSystemVM;
import com.gridnine.xtrip.client.fx.model.dict.SpellVariantVM;
import com.gridnine.xtrip.client.fx.model.dict.TranslationVM;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.meta.DictionaryProperty;
import com.gridnine.xtrip.common.meta.DictionaryType;
import com.gridnine.xtrip.common.meta.EntityCollection;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public final class DictHandlersHelper {
    public static final TableColumnSettings COL_NOT_UPDATE = new TableColumnSettings();
    public static final TableColumnSettings COL_CODE;
    public static final TableColumnSettings COL_CODE_VARIANTS;
    public static final TableColumnSettings COL_TRANSLATIONS;
    public static final TableColumnSettings COL_SPELL_VARIANTS;

    public static TableColumnSettings createColumn(Class<? extends BaseDictionary> dictClass, String id, String name, Renderer renderer) {
        TableColumnSettings result = new TableColumnSettings();
        result.setId(id);
        result.setDisplayName(name);
        result.setRenderer(renderer);
        DictionaryType dictType = (DictionaryType)MetaRegistry.get().getDictionaries().get(dictClass.getName());
        if (dictType != null) {
            DictionaryProperty prop = (DictionaryProperty)dictType.getProperties().get(id);
            if (prop != null) {
                result.setType(prop.getType());
            } else {
                EntityCollection coll = (EntityCollection)dictType.getCollections().get(id);
                if (coll != null) {
                    result.setType(coll.getElementType());
                }
            }
        }
        return result;
    }

    public static void codeVariantsToVM(Map<String, String> model, List<CodeSystemVM> vm) {
        model.entrySet().forEach(entry -> {
            CodeSystemVM itemVM = new CodeSystemVM();
            itemVM.setCodeSystem((CodeSystem)CollectionUtil.findEnumConstant(CodeSystem.class, (String)((String)entry.getKey())));
            itemVM.setCode((String)entry.getValue());
            vm.add(itemVM);
        });
    }

    public static void codeVariantsFromVM(List<CodeSystemVM> vm, Map<String, String> model) {
        model.clear();
        vm.forEach(itemVM -> {
            if (itemVM.getCodeSystem() != null && !TextUtil.isBlank((String)itemVM.getCode())) {
                model.put(itemVM.getCodeSystem().name(), itemVM.getCode().trim());
            }
        });
    }

    public static void translationsToVM(Map<Locale, String> model, List<TranslationVM> vm) {
        model.entrySet().forEach(entry -> {
            TranslationVM item = new TranslationVM();
            item.setLocale((Locale)entry.getKey());
            item.setTranslation((String)entry.getValue());
            vm.add(item);
        });
    }

    public static void translationsFromVM(List<TranslationVM> vm, Map<Locale, String> model) {
        model.clear();
        vm.forEach(itemVM -> {
            if (itemVM.getLocale() != null && !TextUtil.isBlank((String)itemVM.getTranslation())) {
                model.put(itemVM.getLocale(), itemVM.getTranslation());
            }
        });
    }

    public static void spellVariantsToVM(Set<String> model, List<SpellVariantVM> vm) {
        model.forEach(variant -> {
            SpellVariantVM variantVM = new SpellVariantVM();
            variantVM.setSpellVariant(variant);
            vm.add(variantVM);
        });
    }

    public static void spellVariantsFromVM(List<SpellVariantVM> vm, Set<String> model) {
        model.clear();
        vm.forEach(variantVM -> {
            if (!TextUtil.isBlank((String)variantVM.getSpellVariant())) {
                model.add(variantVM.getSpellVariant());
            }
        });
    }

    private DictHandlersHelper() {
    }

    static {
        COL_NOT_UPDATE.setId(BaseDictionary.Property.notUpdatable.name());
        COL_NOT_UPDATE.setDisplayName(Messages.No_update);
        COL_NOT_UPDATE.setRenderer((Renderer)StandardRenderers.UPDATE);
        COL_CODE = new TableColumnSettings();
        COL_CODE.setId(BaseDictionary.Property.code.name());
        COL_CODE.setDisplayName(Messages.ID);
        COL_CODE.setRenderer((Renderer)StandardRenderers.GENERIC);
        COL_CODE_VARIANTS = new TableColumnSettings();
        COL_CODE_VARIANTS.setId(BaseDictionary.Property.codeVariants.name());
        COL_CODE_VARIANTS.setDisplayName(Messages.Codes);
        COL_CODE_VARIANTS.setRenderer((Renderer)StandardRenderers.CODE_VARIANTS);
        COL_TRANSLATIONS = new TableColumnSettings();
        COL_TRANSLATIONS.setId(BaseDictionary.Property.translations.name());
        COL_TRANSLATIONS.setDisplayName(Messages.Names);
        COL_TRANSLATIONS.setRenderer((Renderer)StandardRenderers.TRANSLATIONS);
        COL_SPELL_VARIANTS = new TableColumnSettings();
        COL_SPELL_VARIANTS.setId(BaseDictionary.Property.spellVariants.name());
        COL_SPELL_VARIANTS.setDisplayName(Messages.Writing);
        COL_SPELL_VARIANTS.setRenderer((Renderer)StandardRenderers.SPELL_VARIANTS);
    }
}

