/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.helpers;

import com.gridnine.xtrip.common.fx.rpc.DictItem;
import com.gridnine.xtrip.common.fx.rpc.DictQuery;
import com.gridnine.xtrip.common.fx.rpc.DictService;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.Preference;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.util.List;

public final class RpcDictHelper {
    public static String findPreferenceValue(PreferenceKey key) throws Exception {
        ServiceInvocationContext sic = ServiceInvocationContext.get();
        DictService dictService = (DictService)RpcServiceManager.get().getService(DictService.class);
        DictQuery query = new DictQuery();
        query.getFields().add(Preference.Property.key.name());
        query.getFields().add(Preference.Property.value.name());
        query.getCriterions().add(new DictQuery.SearchCriterion(Preference.Property.key.name(), new Object[]{key}));
        List dictItems = dictService.search(sic, Preference.class, query);
        return dictItems.isEmpty() ? null : (String)((DictItem)dictItems.get(0)).getFields().get(Preference.Property.value.name());
    }

    public static String getPreferenceValue(PreferenceKey key, String def) throws Exception {
        String value = RpcDictHelper.findPreferenceValue(key);
        return value == null ? def : value;
    }

    public static boolean getPreferenceValue(PreferenceKey key, boolean def) throws Exception {
        String value = RpcDictHelper.findPreferenceValue(key);
        return value == null ? def : Boolean.parseBoolean(value);
    }

    public static double getPreferenceValue(PreferenceKey key, double def) throws Exception {
        String value = RpcDictHelper.findPreferenceValue(key);
        return value == null ? def : Double.parseDouble(value);
    }

    public static void updatePreference(PreferenceKey key, String value) throws Exception {
        ServiceInvocationContext sic = ServiceInvocationContext.get();
        DictService dictService = (DictService)RpcServiceManager.get().getService(DictService.class);
        DictQuery query = new DictQuery();
        query.getFields().add(Preference.Property.key.name());
        query.getCriterions().add(new DictQuery.SearchCriterion(Preference.Property.key.name(), new Object[]{key}));
        List dictItems = dictService.search(sic, Preference.class, query);
        if (value == null) {
            for (DictItem item : dictItems) {
                dictService.delete(sic, item.getReference());
            }
            return;
        }
        Preference pref = null;
        for (DictItem item : dictItems) {
            if (pref == null) {
                pref = (Preference)dictService.load(sic, item.getReference());
                continue;
            }
            dictService.delete(sic, item.getReference());
        }
        if (pref == null) {
            pref = new Preference();
            pref.setKey(key);
            pref.setCode(key.name());
        }
        pref.setValue(value);
        dictService.save(sic, (BaseDictionary)pref);
    }

    private RpcDictHelper() {
    }

    public static <D extends BaseDictionary> DictionaryReference<D> getReference(Class<D> clazz, String code) throws Exception {
        if (null == code) {
            return null;
        }
        DictService dictService = (DictService)RpcServiceManager.get().getService(DictService.class);
        return dictService.getReference(ServiceInvocationContext.get(), clazz, code);
    }

    public static <D extends BaseDictionary> List<D> loadAll(Class<D> clazz) throws Exception {
        DictService dictService = (DictService)RpcServiceManager.get().getService(DictService.class);
        return dictService.loadAll(ServiceInvocationContext.get(), clazz);
    }
}

