/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.lrt;

import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.registry.RegistryItem;
import com.gridnine.xtrip.client.fx.core.registry.RegistryItemType;
import com.gridnine.xtrip.common.util.XSerializable;
import java.io.Serializable;
import java.util.Comparator;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.Node;

public interface LrtHandler<N extends Node>
extends RegistryItem<LrtHandler<?>> {
    public static final RegistryItemType<LrtHandler<?>> TYPE = new RegistryItemType("LRT-HANDLER");
    public static final Comparator<LrtHandler<?>> COMPARATOR = (handler1, handler2) -> handler1.getName().compareTo(handler2.getName());

    public static LrtHandler<?> forId(String id) {
        return (LrtHandler)ClientRegistry.get().allOf(TYPE).get(id);
    }

    public static LrtHandler<?> forTaskClassName(String taskClassName) {
        return ClientRegistry.get().allOf(TYPE).values().stream().filter(handler -> handler.getTaskClassName().equals(taskClassName)).findFirst().orElse(null);
    }

    default public RegistryItemType<LrtHandler<?>> getType() {
        return TYPE;
    }

    default public String getName() {
        String result = ClientRegistry.get().getResourceFor((RegistryItem)this, "name");
        return result == null ? this.getId() : result;
    }

    public String getTaskClassName();

    public N createConfigurator();

    default public boolean isCompactConfigurator() {
        return false;
    }

    default public BooleanExpression createAvailability(N configurator) {
        return new SimpleBooleanProperty(true);
    }

    public Serializable getConfiguration(N var1);

    default public N getReadOnlyConfigurator(XSerializable configuration) {
        return null;
    }

    default public boolean canCreateTask() {
        return true;
    }
}

