/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.lrt.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.assets.AssetModification;
import com.gridnine.xtrip.client.fx.core.assets.AssetModificationEvent;
import com.gridnine.xtrip.client.fx.core.assets.list.AssetsListPane;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.lrt.LrtAction;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.assets.LongRunningTaskInfo;
import com.gridnine.xtrip.common.model.rpc.TaskService;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import javafx.scene.control.Control;

public class PauseTaskAction
implements LrtAction {
    public String getId() {
        return "lrt-pause-task";
    }

    public ActionIcon getIcon(AssetsListPane context) {
        return StandardActionIcons.STOP;
    }

    public double getWeight() {
        return 30.0;
    }

    public boolean isAvailable(AssetsListPane context) {
        return context.getAssetHandler().getAssetType().equals(LongRunningTaskInfo.class);
    }

    public boolean isEnabled(AssetsListPane context) {
        if (context.getSelectedItems().size() != 1) {
            return false;
        }
        LongRunningTaskInfo info = (LongRunningTaskInfo)context.getSelectedItems().get(0);
        switch (info.getState()) {
            case RUNNING: {
                return true;
            }
        }
        return false;
    }

    public void execute(Control source, AssetsListPane context, boolean alt) {
        if (context.getSelectedItems().size() != 1) {
            return;
        }
        LongRunningTaskInfo info = (LongRunningTaskInfo)context.getSelectedItems().get(0);
        Notifications.get().submitTask(() -> this.changeTaskState(info), context.getMutex());
    }

    private void changeTaskState(LongRunningTaskInfo info) throws Exception {
        ServiceInvocationContext sic = ServiceInvocationContext.get();
        TaskService taskService = (TaskService)RpcServiceManager.get().getService(TaskService.class);
        switch (info.getState()) {
            case RUNNING: {
                taskService.stopTask(sic, info.getUid());
                break;
            }
        }
        EventBus.get().publishAsync((Event)new AssetModificationEvent(new AssetModification[]{new AssetModification((BaseAsset)info, AssetModification.ModificationType.CHANGE)}));
    }
}

