/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.lrt.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.assets.list.AssetsListPane;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.lib.components.text.RichTextFlow;
import com.gridnine.xtrip.client.fx.core.lib.components.text.TextHandler;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.CardsContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextAreaWidget;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.lrt.LrtAction;
import com.gridnine.xtrip.client.fx.standard.lrt.LrtHandler;
import com.gridnine.xtrip.common.fx.rpc.service.AssetService;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.assets.LongRunningTaskInfo;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.xml.XUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Optional;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.input.Clipboard;
import javafx.scene.input.DataFormat;

public class ViewTaskAction
implements LrtAction {
    public String getId() {
        return "lrt-view-task";
    }

    public ActionIcon getIcon(AssetsListPane context) {
        return StandardActionIcons.VIEW;
    }

    public double getWeight() {
        return 20.0;
    }

    public boolean isAvailable(AssetsListPane context) {
        return context.getAssetHandler().getAssetType().equals(LongRunningTaskInfo.class);
    }

    public boolean isEnabled(AssetsListPane context) {
        return context.getSelectedItems().size() == 1;
    }

    public boolean isDefault() {
        return true;
    }

    public void execute(Control source, AssetsListPane context, boolean alt) {
        if (context.getSelectedItems().isEmpty()) {
            return;
        }
        String taskUid = ((BaseAsset)context.getSelectedItems().get(0)).getUid();
        Notifications.get().submitTask(() -> this.loadTask(context, taskUid), Messages.Loading_task_data);
    }

    private void loadTask(AssetsListPane context, String taskUid) throws Exception {
        LongRunningTaskInfo taskInfo = (LongRunningTaskInfo)((AssetService)RpcServiceManager.get().getService(AssetService.class)).load(ServiceInvocationContext.get(), LongRunningTaskInfo.class, taskUid);
        FxUtil.submitToFxThread(() -> this.showTask(context, taskInfo));
    }

    private void showTask(AssetsListPane context, LongRunningTaskInfo taskInfo) {
        if (taskInfo == null) {
            Notifications.get().showFlashNotification(Messages.Task_not_found, null);
            return;
        }
        LrtHandler<?> handler = LrtHandler.forTaskClassName(taskInfo.getTaskClassName());
        CardsContainer container = new CardsContainer();
        RichTextFlow rtf = new RichTextFlow(TextHandler.SIMPLE_HTML, this.buildDetails(taskInfo));
        XSerializable configuration = taskInfo.getConfiguration();
        if (configuration != null) {
            Object configurationNode = handler.getReadOnlyConfigurator(configuration);
            if (configurationNode == null) {
                String configText;
                try (ByteArrayOutputStream strm = new ByteArrayOutputStream();){
                    XUtil.serialize((XSerializable)configuration, (OutputStream)strm);
                    configText = strm.toString("utf-8");
                }
                catch (Exception e) {
                    configText = TextUtil.getExceptionStackTrace((Throwable)e);
                }
                TextAreaWidget textAreaWidget = new TextAreaWidget(true);
                textAreaWidget.setValue(configText);
                configurationNode = textAreaWidget;
            }
            container.getCards().add((Object)new Card("configuration", UiCardsContainer.Style.COLLAPSED, "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b", configurationNode));
        }
        container.getCards().add((Object)new Card("messages", UiCardsContainer.Style.STATIC, "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f", (Node)rtf));
        Dialog dialog = new Dialog();
        dialog.setTitle(Messages.getTask(handler == null ? "???" : handler.getName())).setBody((Node)container).setExpandToParent(true).setAutoClose(false).setOnCloseRequest(() -> ((Dialog)dialog).close()).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Close, () -> ((Dialog)dialog).close()).addButton(DialogButtonStyle.AUXILARY, Messages.Copy, () -> Clipboard.getSystemClipboard().setContent(Collections.singletonMap(DataFormat.PLAIN_TEXT, rtf.toPlainText()))).show((Node)context);
    }

    private String buildDetails(LongRunningTaskInfo taskInfo) {
        DateFormat format = LocaleManager.get().getCurrentLocaleData().getDateTimeFormat();
        L10nResourcesManager rm = LocaleManager.get().getL10nResourceManager();
        StringBuilder text = new StringBuilder("<html>");
        text.append("<b>" + Messages.Description + ":</b> " + taskInfo.getDescription() + "<br>");
        if (taskInfo.getCreated() != null) {
            text.append("<b>" + Messages.Created + "</b> " + format.format(taskInfo.getCreated()) + ' ' + taskInfo.getCreatedBy() + "<br>");
        }
        if (taskInfo.getStartDate() != null) {
            text.append("<b>" + Messages.Start_date + ":</b> " + format.format(taskInfo.getStartDate()) + "<br>");
        }
        if (taskInfo.getEndDate() != null) {
            text.append("<b>" + Messages.Finish_date + ":</b> " + format.format(taskInfo.getEndDate()) + "<br>");
        }
        if (!TextUtil.isBlank((String)taskInfo.getInstance())) {
            text.append("<b>" + Messages.Node + ":</b> " + taskInfo.getInstance() + "<br>");
        }
        if (taskInfo.getState() != null) {
            text.append("<b>" + Messages.Status + ":</b> " + taskInfo.getState() + "<br>");
        }
        if (taskInfo.isIndefinite()) {
            text.append("<b>" + Messages.Progress + ":</b> " + Integer.toString(taskInfo.getProgress()) + "%<br>");
        }
        text.append("<b>" + Messages.Messages + "</b><br>");
        for (LongRunningTaskInfo.Event event : taskInfo.getEvents().get()) {
            String date = Optional.ofNullable(event.getDate()).map(item -> format.format((Date)item)).orElse("???");
            text.append("<b>").append(date).append(" ").append(event.getDescription().getType()).append(":</b> ").append(rm.getMessage(event.getDescription().getMessage())).append("<br>");
            String details = Optional.ofNullable(event.getDescription().getDetails()).map(item -> item.replaceAll("[\\r\\n]+", "<br>")).map(item -> item.endsWith("<br>") ? item.substring(0, item.length() - 4) : item).orElse(null);
            if (TextUtil.isBlank((String)details)) continue;
            text.append("<b>").append(date).append(" ").append(Messages.Extra_info).append(":</b> ").append(details).append("<br>");
        }
        return text.toString();
    }
}

