/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.lrt.handlers;

import com.gridnine.xtrip.client.fx.core.lib.components.QuickHelp;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DateValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.TripleValueWidget;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.lrt.LrtHandler;
import com.gridnine.xtrip.common.model.finance.FinanceDocumentsCreateTaskConfiguration;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Date;
import java.util.Optional;
import javafx.scene.Node;

public class FinanceDocumentsCreateTaskHandler
implements LrtHandler<Configurator> {
    public String getId() {
        return "FinanceDocumentsCreateTask";
    }

    @Override
    public String getTaskClassName() {
        return "com.gridnine.xtrip.server.model.tasks.standard.FinanceDocumentsCreateTask";
    }

    @Override
    public Configurator createConfigurator() {
        return new Configurator();
    }

    @Override
    public Serializable getConfiguration(Configurator configurator) {
        return configurator.createConfiguration();
    }

    static final class Configurator
    extends GridContainer {
        private final DateValueWidget dateNode = new DateValueWidget(false);
        private final DateValueWidget startDateNode = new DateValueWidget(false);
        private final DateValueWidget endDateNode = new DateValueWidget(false);
        private final TripleValueWidget useDelegateNode = new TripleValueWidget(false, false);
        private final TripleValueWidget useFacsimileNode = new TripleValueWidget(false, false);

        Configurator() {
            super(3);
            GridCell dateCell = new GridCell(Messages.financeDocumentsDate, (Node)this.dateNode);
            GridCell startDateCell = new GridCell(Messages.financeDocumentsStartDate, (Node)this.startDateNode);
            GridCell endDateCell = new GridCell(Messages.financeDocumentsEndDate, (Node)this.endDateNode);
            GridCell useDelegateCell = new GridCell(Messages.financeDocumentsUseDelegate, (Node)this.useDelegateNode);
            GridCell useFacsimileCell = new GridCell(Messages.financeDocumentsUseFacsimile, (Node)this.useFacsimileNode);
            dateCell.setHelp(() -> new QuickHelp(Messages.financeDocumentsDateHelp));
            startDateCell.setHelp(() -> new QuickHelp(Messages.financeDocumentsStartDateHelp));
            endDateCell.setHelp(() -> new QuickHelp(Messages.financeDocumentsEndDateHelp));
            useDelegateCell.setHelp(() -> new QuickHelp(Messages.financeDocumentsUseDelegateHelp));
            useFacsimileCell.setHelp(() -> new QuickHelp(Messages.financeDocumentsUseFacsimileHelp));
            this.getCells().add((Object)dateCell);
            this.getCells().add((Object)startDateCell);
            this.getCells().add((Object)endDateCell);
            this.getCells().add((Object)useDelegateCell);
            this.getCells().add((Object)useFacsimileCell);
        }

        FinanceDocumentsCreateTaskConfiguration createConfiguration() {
            FinanceDocumentsCreateTaskConfiguration configuration = new FinanceDocumentsCreateTaskConfiguration();
            Date date = DateUtils.asDate((LocalDate)this.dateNode.getValue());
            if (date == null) {
                date = new Date();
            }
            Date startDate = Optional.ofNullable(DateUtils.asDate((LocalDate)this.startDateNode.getValue())).map(item -> MiscUtil.clearTime((Date)item)).orElse(null);
            Date endDate = Optional.ofNullable(DateUtils.asDate((LocalDate)this.endDateNode.getValue())).map(item -> MiscUtil.setDayEndTime((Date)item)).orElse(null);
            Boolean useDelegate = this.useDelegateNode.getValue();
            Boolean useFacsimile = this.useFacsimileNode.getValue();
            configuration.setDate(date);
            configuration.setStartDate(startDate);
            configuration.setEndDate(endDate);
            configuration.setUseDelegate(useDelegate);
            configuration.setUseFacsimile(useFacsimile);
            return configuration;
        }
    }
}

