/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.lrt.handlers;

import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DateValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.DictBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.lrt.LrtHandler;
import com.gridnine.xtrip.common.model.dict.CostCodeCategory;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.tasks.MigrateCostCodeCategoryTaskConfiguration;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Date;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.BooleanExpression;
import javafx.scene.Node;

public class MigrateCostCodeCategoryTaskHandler
implements LrtHandler<Configurator> {
    public String getId() {
        return "MigrateCostCodeCategoryTask";
    }

    @Override
    public String getTaskClassName() {
        return "com.gridnine.xtrip.server.model.tasks.standard.MigrateCostCodeCategoryTask";
    }

    @Override
    public Configurator createConfigurator() {
        return new Configurator();
    }

    @Override
    public BooleanExpression createAvailability(Configurator configurator) {
        return configurator.createAvailability();
    }

    @Override
    public Serializable getConfiguration(Configurator configurator) {
        return configurator.createConfiguration();
    }

    static final class Configurator
    extends GridContainer {
        protected final EntityBoxWidget<Organization> clientWidget = new EntityBoxWidget(Organization.class, false);
        protected final DictBoxWidget<CostCodeCategory> oldCategoryWidget;
        protected final DictBoxWidget<CostCodeCategory> newCategoryWidget;
        protected final DateValueWidget dateStartWidget;
        protected final DateValueWidget dateEndWidget;

        Configurator() {
            super(2);
            this.clientWidget.setFieldName(Messages.Client);
            this.clientWidget.setListParametersSupplier(ControllerInterceptorsHelper::getClients);
            this.oldCategoryWidget = new DictBoxWidget(CostCodeCategory.class, false);
            this.oldCategoryWidget.setFieldName(Messages.Old_category);
            this.newCategoryWidget = new DictBoxWidget(CostCodeCategory.class, false);
            this.newCategoryWidget.setFieldName(Messages.New_category);
            this.dateStartWidget = new DateValueWidget(false);
            this.dateEndWidget = new DateValueWidget(false);
            this.dateEndWidget.setValue(LocalDate.now());
            this.getCells().addAll((Object[])new GridCell[]{new GridCell(Messages.Client, this.clientWidget), GridCell.NEW_ROW_MARKER, new GridCell(Messages.Old_category, this.oldCategoryWidget), new GridCell(Messages.New_category, this.newCategoryWidget), new GridCell(Messages.Start_period, (Node)this.dateStartWidget), new GridCell(Messages.End_period, (Node)this.dateEndWidget)});
        }

        BooleanExpression createAvailability() {
            return new BooleanBinding(){
                {
                    this.bind(new Observable[]{clientWidget.valueProperty(), oldCategoryWidget.valueProperty(), newCategoryWidget.valueProperty(), dateStartWidget.valueProperty(), dateEndWidget.valueProperty()});
                }

                protected boolean computeValue() {
                    return clientWidget.getValue() != null && oldCategoryWidget.getValue() != null && newCategoryWidget.getValue() != null && dateStartWidget.getValue() != null && dateEndWidget.getValue() != null;
                }
            };
        }

        MigrateCostCodeCategoryTaskConfiguration createConfiguration() {
            MigrateCostCodeCategoryTaskConfiguration result = new MigrateCostCodeCategoryTaskConfiguration();
            result.setClient(this.clientWidget.getValue());
            result.setOldCategory(this.oldCategoryWidget.getValue());
            result.setNewCategory(this.newCategoryWidget.getValue());
            result.setIssueDateStart(MiscUtil.clearTime((Date)DateUtils.asDate((LocalDate)this.dateStartWidget.getValue())));
            result.setIssueDateEnd(MiscUtil.setDayEndTime((Date)DateUtils.asDate((LocalDate)this.dateEndWidget.getValue())));
            return result;
        }
    }
}

