/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.lrt.handlers;

import com.gridnine.xtrip.client.fx.core.lib.components.tree.CustomCheckBoxTreeView;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DateValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.IntValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.BooleanValueWidget;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.lrt.LrtHandler;
import com.gridnine.xtrip.client.fx.standard.lrt.handlers.TaskHelper;
import com.gridnine.xtrip.common.model.tasks.MigrateEntitiesTaskConfiguration;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.stream.Collectors;
import javafx.scene.Node;

public class MigrateEntitiesTaskHandler
implements LrtHandler<Configurator> {
    public String getId() {
        return "MigrateEntitiesTask";
    }

    @Override
    public String getTaskClassName() {
        return "com.gridnine.xtrip.server.model.tasks.standard.MigrateEntitiesTask";
    }

    @Override
    public Configurator createConfigurator() {
        return new Configurator();
    }

    @Override
    public Serializable getConfiguration(Configurator configurator) {
        return configurator.createConfiguration();
    }

    static final class Configurator
    extends GridContainer {
        protected final DateValueWidget date = new DateValueWidget(false);
        protected final IntValueWidget hours = new IntValueWidget(false);
        protected final IntValueWidget threadCount = new IntValueWidget(false);
        protected final BooleanValueWidget isUsedCreateDate = new BooleanValueWidget(true, false);
        protected final BooleanValueWidget isDescOrder = new BooleanValueWidget(true, false);
        protected final BooleanValueWidget stopOnError = new BooleanValueWidget(true, false);
        protected final TextFieldWidget url = new TextFieldWidget(false);
        protected final BooleanValueWidget repairTypes = new BooleanValueWidget(true, false);
        protected GridContainer treePane;
        protected CustomCheckBoxTreeView<TaskHelper.Item> tree;

        Configurator() {
            super(3);
            CustomCheckBoxTreeView<TaskHelper.Item> customTreeView = TaskHelper.createTree();
            this.treePane = GridContainer.wrap((Node)customTreeView.getTreePane());
            customTreeView.setReadonly(true);
            this.tree = customTreeView;
            this.repairTypes.valueProperty().addListener((obs, oldValue, newValue) -> customTreeView.setReadonly(newValue == false));
            this.isUsedCreateDate.setValue(true);
            this.isDescOrder.setValue(true);
            this.stopOnError.setValue(true);
            this.repairTypes.setValue(false);
            this.getCells().addAll((Object[])new GridCell[]{new GridCell(Messages.Date, (Node)this.date), new GridCell(Messages.Hours, (Node)this.hours), new GridCell(Messages.ThreadCount, (Node)this.threadCount), new GridCell(Messages.isUsedCreateDate, (Node)this.isUsedCreateDate), new GridCell(Messages.isDescOrder, (Node)this.isDescOrder), new GridCell(Messages.StopOnError2, (Node)this.stopOnError), new GridCell("url", (Node)this.url), new GridCell(Messages.RepairTypes, (Node)this.repairTypes), new GridCell(Messages.List, (Node)this.treePane)});
        }

        MigrateEntitiesTaskConfiguration createConfiguration() {
            MigrateEntitiesTaskConfiguration result = new MigrateEntitiesTaskConfiguration();
            result.setDate(DateUtils.asDate((LocalDate)this.date.getValue()));
            result.setHours(this.hours.getValue() == null ? 0 : (Integer)this.hours.getValue());
            result.setThreadCount(this.threadCount.getValue() == null ? 0 : (Integer)this.threadCount.getValue());
            result.setUsedCreateDate(this.isUsedCreateDate.getValue());
            result.setDescOrder(this.isDescOrder.getValue());
            result.setStopOnError(this.stopOnError.getValue());
            result.setUrl(this.url.getValue());
            if (this.repairTypes.getValue()) {
                for (String id : this.tree.getSelectedItemsIds()) {
                    if (id.equals("root")) continue;
                    result.getTypeList().add(id);
                }
            } else {
                result.getTypeList().addAll(this.tree.getTreeView().getRoot().getChildren().stream().map(item -> ((TaskHelper.Item)item.getValue()).getId()).filter(str -> !str.equals("root")).collect(Collectors.toList()));
            }
            return result;
        }
    }
}

