/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.lrt.handlers;

import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog.EntityBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.util.MultiSupplier;
import com.gridnine.xtrip.client.fx.model.tasks.PersonReplaceTaskContainer;
import com.gridnine.xtrip.client.fx.model.tasks.PersonReplaceTaskContainerController;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.lrt.LrtHandler;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.model.replace.PersonReplaceTaskConfiguration;
import com.gridnine.xtrip.common.model.replace.PersonWrapper;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SortOrder;
import java.io.Serializable;
import java.util.ArrayList;

public class PersonReplaceTaskHandler
implements LrtHandler<Configurator> {
    @Override
    public String getTaskClassName() {
        return "com.gridnine.xtrip.server.model.tasks.standard.PersonReplaceTask";
    }

    @Override
    public Configurator createConfigurator() {
        return new Configurator();
    }

    @Override
    public Serializable getConfiguration(Configurator configurator) {
        return configurator.createConfiguration();
    }

    public String getId() {
        return "PersonReplaceTask";
    }

    public class Configurator<rr>
    extends PersonReplaceTaskContainer {
        private MultiSupplier<IndexListParameters<Person, ?>> supplier;

        Configurator() {
            super(false);
            this.supplier = new MultiSupplier<IndexListParameters<Person, ?>>(){
                IndexListParameters<Person, PersonIndex> listAgents;
                IndexListParameters<Person, PersonIndex> listManagers;
                IndexListParameters<Person, PersonIndex> listTravellers;
                IndexListParameters<?, ?>[] listParameters;
                {
                    this.listAgents = Configurator.this.getListParameters();
                    this.listManagers = Configurator.this.getListParameters();
                    this.listTravellers = Configurator.this.getListParameters();
                    this.listAgents.getSearchCriterions().add(SearchCriterion.contains((String)PersonIndex.Property.types.name(), (Object)PersonType.AGENT.name()));
                    this.listAgents.getSearchCriterions().add(SearchCriterion.eq((String)PersonIndex.Property.disabled.name(), (Object)Boolean.FALSE));
                    this.listManagers.getSearchCriterions().add(SearchCriterion.containsOnly((String)PersonIndex.Property.types.name(), (String)PersonType.MANAGER.name()));
                    this.listManagers.getSearchCriterions().add(SearchCriterion.eq((String)PersonIndex.Property.disabled.name(), (Object)Boolean.FALSE));
                    this.listTravellers.getSearchCriterions().add(SearchCriterion.containsOnly((String)PersonIndex.Property.types.name(), (String)PersonType.PASSENGER.name()));
                    this.listTravellers.getSearchCriterions().add(SearchCriterion.eq((String)PersonIndex.Property.disabled.name(), (Object)Boolean.FALSE));
                    this.listParameters = new IndexListParameters[]{this.listAgents, this.listManagers, this.listTravellers};
                }

                public int count() {
                    return this.listParameters.length;
                }

                public String getDisplayName(int idx) {
                    String name = "";
                    switch (idx) {
                        case 0: {
                            name = Messages.Dimension_agent;
                            break;
                        }
                        case 1: {
                            name = Messages.Manager;
                            break;
                        }
                        case 2: {
                            name = Messages.Name_Travelers;
                        }
                    }
                    return name;
                }

                public IndexListParameters<Person, ?> get(int idx) {
                    return this.listParameters[idx];
                }
            };
            this.getReplaceWithNode().setListParametersSupplier(this.supplier);
            ((EntityBoxWidgetColumn)this.getPersonWrapperTableNode().getColumn("profile")).setListParametersSupplier(this.supplier);
        }

        PersonReplaceTaskConfiguration createConfiguration() {
            PersonReplaceTaskConfiguration configuration = new PersonReplaceTaskConfiguration();
            configuration.setReplaceWith(this.getReplaceWithNode().getValue());
            PersonReplaceTaskContainerController ctr = new PersonReplaceTaskContainerController((PersonReplaceTaskContainer)this, false);
            ArrayList vm = new ArrayList();
            ctr.getPersonWrapperTable().writeData(vm);
            VMHelper.transfer(vm, configuration.getFindWhat(), wrapperTableVM -> {
                PersonWrapper wrapperTable = new PersonWrapper();
                wrapperTable.setProfile(wrapperTableVM.getProfile());
                wrapperTable.setToDelete(wrapperTableVM.isToDelete());
                return wrapperTable;
            });
            return configuration;
        }

        private IndexListParameters<Person, PersonIndex> getListParameters() {
            IndexListParameters result = new IndexListParameters();
            result.setIndexType(PersonIndex.class);
            result.getSortings().put(PersonIndex.Property.name.name(), SortOrder.ASC);
            TableColumnSettings filter = new TableColumnSettings();
            filter.setId(PersonIndex.Property.name.name());
            result.getFilters().add(filter);
            filter = new TableColumnSettings();
            filter.setId(PersonIndex.Property.code.name());
            result.getFilters().add(filter);
            TableColumnSettings column1 = new TableColumnSettings();
            column1.setId(PersonIndex.Property.name.name());
            result.getColumns().add(column1);
            TableColumnSettings column2 = new TableColumnSettings();
            column2.setId(PersonIndex.Property.code.name());
            result.getColumns().add(column2);
            return result;
        }
    }
}

