/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.lrt.handlers;

import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.IntValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.model.custom.restrictions.RestrictionsData;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.lrt.LrtHandler;
import com.gridnine.xtrip.client.fx.standard.restriction.BasicRestrictionsWidget;
import com.gridnine.xtrip.common.meta.BaseMetaElement;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.tasks.QueryBasedReindexTaskConfiguration;
import com.gridnine.xtrip.common.restriction.util.RestrictionsUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.util.StringConverter;

public class QueryBasedReindexTaskHandler
implements LrtHandler<Configurator> {
    public String getId() {
        return "QueryBasedReindexLongRunningTask";
    }

    @Override
    public String getTaskClassName() {
        return "com.gridnine.xtrip.server.model.tasks.standard.QueryBasedReindexLongRunningTask";
    }

    @Override
    public Configurator createConfigurator() {
        return new Configurator();
    }

    @Override
    public Serializable getConfiguration(Configurator configurator) {
        return configurator.createConfiguration();
    }

    static final class Configurator
    extends GridContainer {
        private final ComboBoxWidget<String> indexWidget = new ComboBoxWidget(false);
        private final IntValueWidget threadCountWidget = new IntValueWidget(false);
        private final BasicRestrictionsWidget criterions = new BasicRestrictionsWidget(false);

        Configurator() {
            super(4);
            GridCell critCell = new GridCell(Messages.Criteria, (Node)this.criterions);
            critCell.setColSpan(Integer.MAX_VALUE);
            this.getCells().addAll((Object[])new GridCell[]{new GridCell(Messages.Index, this.indexWidget), new GridCell(Messages.ThreadCount, (Node)this.threadCountWidget), GridCell.NEW_ROW_MARKER, critCell});
            final Map<String, String> collect = MetaRegistry.get().getIndexes().values().stream().collect(Collectors.toMap(BaseMetaElement::getId, BaseMetaElement::getDisplayName));
            StringConverter<String> converter = new StringConverter<String>(){

                public String toString(String object) {
                    return (String)collect.get(object);
                }

                public String fromString(String string) {
                    return null;
                }
            };
            this.indexWidget.setItemsSupplier(() -> new ArrayList(collect.keySet()));
            this.indexWidget.setConverter((StringConverter)converter);
            this.indexWidget.valueProperty().addListener((observable, oldValue, newValue) -> {
                if (newValue != null) {
                    this.criterions.setRestrictionId((String)newValue);
                }
            });
        }

        QueryBasedReindexTaskConfiguration createConfiguration() {
            QueryBasedReindexTaskConfiguration result = new QueryBasedReindexTaskConfiguration();
            if (this.indexWidget.getValue() != null) {
                result.setIndexType((String)this.indexWidget.getValue());
            }
            if (this.threadCountWidget.getValue() != null) {
                result.setThreadCount(((Integer)this.threadCountWidget.getValue()).intValue());
            }
            RestrictionsData rd = new RestrictionsData();
            this.criterions.writeData(rd);
            try {
                Class<?> indexClass = Class.forName(rd.getRestrictionId());
                result.getCriterions().addAll(RestrictionsUtil.toQueryFromRestrictionGroups((Collection)rd.getRestrictions(), indexClass, Collections.emptyList()));
            }
            catch (ClassNotFoundException e) {
                ErrorHandler.handle((Throwable)e);
            }
            return result;
        }
    }
}

