/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.lrt.handlers;

import com.gridnine.xtrip.client.fx.core.lib.components.tree.CustomCheckBoxTreeView;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DateValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.IntValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.BooleanValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.lrt.LrtHandler;
import com.gridnine.xtrip.client.fx.standard.lrt.handlers.TaskHelper;
import com.gridnine.xtrip.common.model.tasks.ReindexIndexStorageTaskConfiguration;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.stream.Collectors;
import javafx.scene.Node;

public class ReindexIndexStorageTaskHandler
implements LrtHandler<Configurator> {
    public String getId() {
        return "ReindexIndexStorageTask";
    }

    @Override
    public String getTaskClassName() {
        return "com.gridnine.xtrip.server.model.tasks.standard.ReindexIndexStorageTask";
    }

    @Override
    public Configurator createConfigurator() {
        return new Configurator();
    }

    @Override
    public Serializable getConfiguration(Configurator configurator) {
        return configurator.createConfiguration();
    }

    static final class Configurator
    extends GridContainer {
        protected final ComboBoxWidget<String> primaryStorage = new ComboBoxWidget(false);
        protected final DateValueWidget date;
        protected final IntValueWidget hours;
        protected final IntValueWidget threadCount;
        protected final BooleanValueWidget isUsedCreateDate;
        protected final BooleanValueWidget stopOnError;
        protected final BooleanValueWidget deleteIndexes;
        protected final BooleanValueWidget repairTypes;
        protected GridContainer treePane;
        protected CustomCheckBoxTreeView<TaskHelper.Item> tree;

        Configurator() {
            super(3);
            this.primaryStorage.setAsync(true);
            this.primaryStorage.setItemsSupplier(() -> TaskHelper.createListAndConverter(this.primaryStorage));
            this.date = new DateValueWidget(false);
            this.hours = new IntValueWidget(false);
            this.threadCount = new IntValueWidget(false);
            this.isUsedCreateDate = new BooleanValueWidget(true, false);
            this.stopOnError = new BooleanValueWidget(true, false);
            this.deleteIndexes = new BooleanValueWidget(true, false);
            this.repairTypes = new BooleanValueWidget(true, false);
            CustomCheckBoxTreeView<TaskHelper.Item> customTreeView = TaskHelper.createTree();
            customTreeView.setReadonly(true);
            this.treePane = GridContainer.wrap((Node)customTreeView.getTreePane());
            this.tree = customTreeView;
            this.repairTypes.valueProperty().addListener((obs, oldValue, newValue) -> customTreeView.setReadonly(newValue == false));
            this.isUsedCreateDate.setValue(true);
            this.stopOnError.setValue(true);
            this.repairTypes.setValue(false);
            this.getCells().addAll((Object[])new GridCell[]{new GridCell(Messages.PrimaryStorage, this.primaryStorage), new GridCell(Messages.Date, (Node)this.date), new GridCell(Messages.Hours, (Node)this.hours), new GridCell(Messages.ThreadCount, (Node)this.threadCount), new GridCell(Messages.isUsedCreateDate, (Node)this.isUsedCreateDate), new GridCell(Messages.StopOnError2, (Node)this.stopOnError), new GridCell(Messages.DeleteIndexes, (Node)this.deleteIndexes), new GridCell(Messages.RepairTypes, (Node)this.repairTypes), new GridCell(Messages.List, (Node)this.treePane)});
        }

        ReindexIndexStorageTaskConfiguration createConfiguration() {
            ReindexIndexStorageTaskConfiguration result = new ReindexIndexStorageTaskConfiguration();
            result.setStorageUid((String)this.primaryStorage.getValue());
            result.setDate(DateUtils.asDate((LocalDate)this.date.getValue()));
            result.setHours(this.hours.getValue() == null ? 0 : (Integer)this.hours.getValue());
            result.setThreadCount(this.threadCount.getValue() == null ? 0 : (Integer)this.threadCount.getValue());
            result.setUsedCreateDate(this.isUsedCreateDate.getValue());
            result.setStopOnError(this.stopOnError.getValue());
            result.setDeleteAllIndexes(this.deleteIndexes.getValue());
            if (this.repairTypes.getValue()) {
                for (String id : this.tree.getSelectedItemsIds()) {
                    if (id.equals("root")) continue;
                    result.getTypeList().add(id);
                }
            } else {
                result.getTypeList().addAll(this.tree.getTreeView().getRoot().getChildren().stream().map(item -> ((TaskHelper.Item)item.getValue()).getId()).filter(str -> !str.equals("root")).collect(Collectors.toList()));
            }
            return result;
        }
    }
}

