/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.lrt.handlers;

import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DateValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.IntValueWidget;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.lrt.LrtHandler;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.tasks.ResendStatisticsTaskConfiguration;
import java.io.Serializable;
import java.time.LocalDate;
import javafx.scene.Node;

public class ResendStatisticsTaskHandler
implements LrtHandler<Configurator> {
    public String getId() {
        return "ResendStatisticsTask";
    }

    @Override
    public String getTaskClassName() {
        return "com.gridnine.xtrip.server.model.statistics.ResendStatisticsTask";
    }

    @Override
    public Configurator createConfigurator() {
        return new Configurator();
    }

    @Override
    public Serializable getConfiguration(Configurator configurator) {
        return configurator.createConfiguration();
    }

    static final class Configurator
    extends GridContainer {
        DateValueWidget dateValueWidget = new DateValueWidget(false);
        IntValueWidget threadCountWidget = new IntValueWidget(false);
        GridCell<DateValueWidget> dateValueWidgetGridCell = new GridCell(Messages.Date, (Node)this.dateValueWidget);
        GridCell<IntValueWidget> threadCountWidgetGridCell = new GridCell(Messages.Threads_amount, (Node)this.threadCountWidget);

        Configurator() {
            super(4);
            this.threadCountWidget.setDefaultValue((Number)1);
            this.getCells().addAll((Object[])new GridCell[]{this.dateValueWidgetGridCell, this.threadCountWidgetGridCell});
        }

        ResendStatisticsTaskConfiguration createConfiguration() {
            ResendStatisticsTaskConfiguration result = new ResendStatisticsTaskConfiguration();
            result.setDate(DateUtils.asDate((LocalDate)this.dateValueWidget.getValue()));
            result.setThreadCount(((Integer)this.threadCountWidget.getValue()).intValue());
            result.setHours(24);
            result.setStopOnError(true);
            result.getTypeList().add(BookingFile.class.getName());
            result.setUsedCreateDate(false);
            result.setDescOrder(false);
            return result;
        }
    }
}

