/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.lrt.handlers;

import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.FileChooserWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.BooleanValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.ComboBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.TextWidgetColumn;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.lrt.LrtHandler;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.model.profile.SabreProfileLoadProfilesTaskConfiguration;
import com.gridnine.xtrip.common.model.profile.SabreProfilesPccSettings;
import com.gridnine.xtrip.common.model.profile.SabreProfilesProfileInfo;
import com.gridnine.xtrip.common.model.profile.SabreProfilesProfileType;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.stage.FileChooser;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;

public class SabreProfileLoadProfilesTaskHandler
implements LrtHandler<Configurator> {
    private static final String RECORDS_DELIMETER = "\u00b6";

    public String getId() {
        return "SabreProfileLoadProfilesTask";
    }

    @Override
    public String getTaskClassName() {
        return "com.gridnine.xtrip.server.model.tasks.standard.SabreProfileLoadProfilesTask";
    }

    @Override
    public Configurator createConfigurator() {
        return new Configurator();
    }

    @Override
    public Serializable getConfiguration(Configurator configurator) {
        return configurator.createConfiguration();
    }

    private static SabreProfilesProfileInfo createItem(String uniqueId, String name, String description, String type, String pcc) {
        SabreProfilesProfileInfo item = new SabreProfilesProfileInfo();
        item.setUniqueId(uniqueId);
        item.setName(name);
        item.setDescription(description);
        if (TextUtil.nonBlank((String)type)) {
            item.setType(SabreProfilesProfileType.valueOf((String)type));
        }
        item.setPcc(pcc);
        return item;
    }

    private static class IdPccTableVM {
        private String uniqueId;
        private String pcc;

        private IdPccTableVM() {
        }

        public String getUniqueId() {
            return this.uniqueId;
        }

        public void setUniqueId(String uniqueId) {
            this.uniqueId = uniqueId;
        }

        public String getPcc() {
            return this.pcc;
        }

        public void setPcc(String pcc) {
            this.pcc = pcc;
        }
    }

    static final class Configurator
    extends GridContainer {
        private final FileChooserWidget fileChooserWidget = new FileChooserWidget(false);
        private final BooleanValueWidget updateExistProfilesWidget;
        private TableWidgetController<TableWidget<IdPccTableVM>, IdPccTableVM> idPccController;
        private final TableWidget<IdPccTableVM> idPccTable;

        Configurator() {
            super(3);
            this.fileChooserWidget.setMode(FileChooserWidget.ChoosingMode.OPEN_SINGLE);
            this.fileChooserWidget.setExtensionFiltersSupplier(() -> Arrays.asList(new FileChooser.ExtensionFilter("csv", new String[]{"*.csv"})));
            this.updateExistProfilesWidget = new BooleanValueWidget(false, false);
            this.idPccTable = new TableWidget(false);
            this.idPccTable.setItemsProvider(() -> new IdPccTableVM());
            this.idPccTable.setControlButtonsAvailability(ControlsPane.ADD_REMOVE);
            ArrayList<TextWidgetColumn> columns = new ArrayList<TextWidgetColumn>();
            TextWidgetColumn column = new TextWidgetColumn(IdPccTableVM::getUniqueId, IdPccTableVM::setUniqueId);
            column.setId("uniqueId");
            column.setCaption("uniqueId");
            columns.add(column);
            column = new ComboBoxWidgetColumn(IdPccTableVM::getPcc, IdPccTableVM::setPcc);
            column.setId("pcc");
            column.setCaption("PCC");
            column.setPrefWidth(Double.valueOf(50.0));
            column.setSortItems(false);
            column.setItemsSupplier(() -> Prefetched.getData().getSabreProfilesSettings().getDefaultPccSettings().stream().map(SabreProfilesPccSettings::getPcc).filter(TextUtil::nonBlank).collect(Collectors.toList()));
            columns.add(column);
            this.idPccTable.setColumns(columns);
            this.idPccController = new TableWidgetController<TableWidget<IdPccTableVM>, IdPccTableVM>(){

                public TableWidget<IdPccTableVM> getView() {
                    return idPccTable;
                }
            };
            this.idPccController.readData(Collections.singletonList(new IdPccTableVM()));
            GridCell customCell = new GridCell(Messages.CustomCSV, this.idPccTable);
            customCell.setColSpan(3);
            this.getCells().addAll((Object[])new GridCell[]{new GridCell(Messages.CSVFile, (Node)this.fileChooserWidget), new GridCell(Messages.UpdateExistProfiles, (Node)this.updateExistProfilesWidget), GridCell.NEW_ROW_MARKER, customCell});
        }

        SabreProfileLoadProfilesTaskConfiguration createConfiguration() {
            SabreProfileLoadProfilesTaskConfiguration result = new SabreProfileLoadProfilesTaskConfiguration();
            result.setUpdateExistProfiles(this.updateExistProfilesWidget.getValue());
            try {
                File file;
                if (!this.fileChooserWidget.getFiles().isEmpty() && (file = (File)this.fileChooserWidget.getFiles().get(0)) != null && file.isFile()) {
                    String content = new String(Files.readAllBytes(Paths.get(file.getPath(), new String[0])), StandardCharsets.UTF_8);
                    CSVParser parser = new CSVParser((Reader)new StringReader(content), CSVFormat.DEFAULT.withTrim().withDelimiter(',').withRecordSeparator(SabreProfileLoadProfilesTaskHandler.RECORDS_DELIMETER));
                    result.getProfiles().addAll(parser.getRecords().parallelStream().filter(record -> record.getRecordNumber() != 1L).map(record -> SabreProfileLoadProfilesTaskHandler.createItem(record.get(0), record.get(1), record.get(2), record.get(3), record.get(4))).collect(Collectors.toList()));
                }
                ArrayList vmList = new ArrayList();
                this.idPccController.writeData(vmList);
                vmList.stream().filter(vm -> !TextUtil.isBlank((String)vm.getUniqueId()) && !TextUtil.isBlank((String)vm.getPcc())).map(vm -> SabreProfileLoadProfilesTaskHandler.createItem(vm.getUniqueId(), null, null, SabreProfilesProfileType.TVL.name(), vm.getPcc())).forEach(result.getProfiles()::add);
            }
            catch (IOException e) {
                ErrorHandler.handle((Throwable)e);
            }
            return result;
        }
    }
}

