/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.lrt.handlers;

import com.gridnine.xtrip.client.fx.core.lib.components.QuickHelp;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DateValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.lrt.LrtHandler;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.finance.ShipmentAppliedRulesMigrateTaskConfiguration;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Date;
import java.util.Optional;
import javafx.scene.Node;

public class ShipmentAppliedRulesMigrateTaskHandler
implements LrtHandler<Configurator> {
    public String getId() {
        return "ShipmentAppliedRulesMigrateTask";
    }

    @Override
    public String getTaskClassName() {
        return "com.gridnine.xtrip.server.model.tasks.standard.ShipmentAppliedRulesMigrateTask";
    }

    @Override
    public Configurator createConfigurator() {
        return new Configurator();
    }

    @Override
    public Serializable getConfiguration(Configurator configurator) {
        return configurator.createConfiguration();
    }

    static final class Configurator
    extends GridContainer {
        private final DateValueWidget startDateNode = new DateValueWidget(false);
        private final DateValueWidget endDateNode = new DateValueWidget(false);
        private final EntityBoxWidget<Organization> customerNode = new EntityBoxWidget(Organization.class, false);

        Configurator() {
            super(3);
            GridCell startDateCell = new GridCell(Messages.shipmentAppliedRulesMigrateTaskStartDate, (Node)this.startDateNode);
            GridCell endDateCell = new GridCell(Messages.shipmentAppliedRulesMigrateTaskEndDate, (Node)this.endDateNode);
            GridCell customerCell = new GridCell(Messages.shipmentAppliedRulesMigrateTaskCustomer, this.customerNode);
            startDateCell.setHelp(() -> new QuickHelp(Messages.shipmentAppliedRulesMigrateTaskStartDateHelp));
            endDateCell.setHelp(() -> new QuickHelp(Messages.shipmentAppliedRulesMigrateTaskEndDateHelp));
            customerCell.setHelp(() -> new QuickHelp(Messages.shipmentAppliedRulesMigrateTaskCustomerHelp));
            this.getCells().add((Object)startDateCell);
            this.getCells().add((Object)endDateCell);
            this.getCells().add((Object)customerCell);
        }

        ShipmentAppliedRulesMigrateTaskConfiguration createConfiguration() {
            ShipmentAppliedRulesMigrateTaskConfiguration configuration = new ShipmentAppliedRulesMigrateTaskConfiguration();
            Date startDate = Optional.ofNullable(DateUtils.asDate((LocalDate)this.startDateNode.getValue())).map(MiscUtil::clearTime).orElse(null);
            Date endDate = Optional.ofNullable(DateUtils.asDate((LocalDate)this.endDateNode.getValue())).map(MiscUtil::setDayEndTime).orElse(null);
            EntityReference customer = this.customerNode.getValue();
            configuration.setStartDate(startDate);
            configuration.setEndDate(endDate);
            configuration.setCustomer(customer);
            return configuration;
        }
    }
}

