/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.lrt.handlers;

import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.tree.CustomCheckBoxTreeView;
import com.gridnine.xtrip.client.fx.core.lib.components.tree.SortableCheckBoxTreeItem;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.common.fx.rpc.service.AssetService;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.rpc.ModelService;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.scene.control.TreeItem;
import javafx.util.StringConverter;

public class TaskHelper {
    static CustomCheckBoxTreeView<Item> createTree() {
        ArrayList<Item> list = new ArrayList<Item>();
        list.add(new Item("PhysicalBulkDictionaryData", "com.gridnine.xtrip.server.db.storage.model.PhysicalBulkDictionaryData"));
        list.add(new Item("DBPropertiesType", "com.gridnine.xtrip.common.model.tasks.RepairTaskConfiguration.DBPropertiesType"));
        MetaRegistry metaRegistry = MetaRegistry.get();
        for (EntityType value : metaRegistry.getEntities().values()) {
            if (!MetaRegistryHelper.isRoot((EntityType)value) || value.isAbstract() || value.isHidden()) continue;
            list.add(new Item(value.getDisplayName(), value.getId()));
        }
        for (EntityType value : metaRegistry.getDictionaries().values()) {
            if (value.isAbstract()) continue;
            list.add(new Item(value.getDisplayName(), value.getId()));
        }
        Item root = new Item("\u041e\u0431\u044a\u0435\u043a\u0442\u044b", "root");
        CustomCheckBoxTreeView<Item> customTreeView = new CustomCheckBoxTreeView<Item>(root, true, Collections.emptyList()){

            protected List<Item> getNodeChildren(Item v) {
                return v.getChildren();
            }

            protected String getNodeTitle(Item v) {
                return v.getTitle();
            }

            protected String getNodeId(Item v) {
                return v.getId();
            }

            protected Comparator<TreeItem<Item>> getComparator() {
                return MiscUtil.comparator(item -> (Item)item.getValue(), (Comparator)new Comparator<Item>(){

                    @Override
                    public int compare(Item o1, Item o2) {
                        if (o1.equals(o2)) {
                            return 0;
                        }
                        if (this.getNodeId(o1) == null) {
                            return this.getNodeId(o2) == null ? 0 : -1;
                        }
                        if (this.getNodeId(o2) == null) {
                            return this.getNodeId(o1) == null ? 0 : 1;
                        }
                        return MiscUtil.compare((Comparable)((Object)this.getNodeTitle(o1).toUpperCase()), (Comparable)((Object)this.getNodeTitle(o2).toUpperCase()));
                    }
                });
            }
        };
        Notifications.get().submitTask(() -> TaskHelper.lambda$createTree$1(list, (CustomCheckBoxTreeView)customTreeView), Messages.General_Data_loading);
        return customTreeView;
    }

    static List<String> createListAndConverter(ComboBoxWidget widget) {
        final HashMap storageList = new HashMap();
        try {
            storageList.putAll(((ModelService)RpcServiceManager.get().getService(ModelService.class)).getPhysicalStorageList(ServiceInvocationContext.get()));
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
        ArrayList<String> list = new ArrayList<String>(storageList.keySet());
        widget.setConverter((StringConverter)new StringConverter<String>(){

            public String toString(String object) {
                return storageList.get(object) != null ? (String)storageList.get(object) : "(\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e)";
            }

            public String fromString(String string) {
                return null;
            }
        });
        return list;
    }

    private static /* synthetic */ void lambda$createTree$1(List list, CustomCheckBoxTreeView customTreeView) throws Exception {
        AssetService assetService = (AssetService)RpcServiceManager.get().getService(AssetService.class);
        Map assetMetadata = assetService.getMetadata(ServiceInvocationContext.get());
        assetMetadata.remove("com.gridnine.xtrip.common.model.cache.asset.ModifiedObjectReference");
        assetMetadata.remove("com.gridnine.xtrip.common.model.tasks.standard.DeletedObjectReference");
        for (Map.Entry asset : assetMetadata.entrySet()) {
            list.add(new Item((String)asset.getValue(), (String)asset.getKey()));
        }
        FxUtil.submitToFxThread(() -> customTreeView.addNewElementsToParent((SortableCheckBoxTreeItem)customTreeView.getTreeView().getRoot(), (Collection)list));
    }

    static class Item {
        private String id;
        private String title;
        private List<Item> children = new ArrayList<Item>();

        Item(String title, String id) {
            this.id = id;
            this.title = title;
        }

        String getId() {
            return this.id;
        }

        String getTitle() {
            return this.title;
        }

        private List<Item> getChildren() {
            return this.children;
        }
    }
}

