/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.maintools.alt;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.lib.container.cells.CellsContainer;
import com.gridnine.xtrip.client.fx.core.lib.container.cells.CellsContainerColumn;
import com.gridnine.xtrip.client.fx.core.lib.container.cells.ComplexCell;
import com.gridnine.xtrip.client.fx.core.lib.container.cells.SimpleCell;
import com.gridnine.xtrip.client.fx.core.registry.basic.MainTool;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.DumpDataUtil;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionGroupResources;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import java.io.File;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.DataFormat;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;

public class HeapDumpTool
implements MainTool {
    private static final AclQuery ACL_QUERY = new AclQuery(StandardRestrictionResourceOperations.USE.getId(), StandardRestrictionGroupResources.GROUP_ADMINISTRATION.getId());

    public String getId() {
        return "main-tool-heap-dump";
    }

    public String getName() {
        return "\u041e\u0442\u0447\u0451\u0442 \u043e \u043d\u0435\u0445\u0432\u0430\u0442\u043a\u0435 \u043f\u0430\u043c\u044f\u0442\u0438";
    }

    public boolean isAltTool() {
        return true;
    }

    public double getWeight() {
        return 30.0;
    }

    public AclQuery getACLQuery() {
        return ACL_QUERY;
    }

    public void execute() {
        List dumpFiles = DumpDataUtil.DataKind.HEAP_DUMP.listFiles();
        if (dumpFiles.isEmpty()) {
            Notifications.get().showFlashNotification("\u041d\u0435\u0442 \u0434\u0430\u043d\u043d\u044b\u0445 \u043e\u0431 \u043e\u0448\u0438\u0431\u043a\u0430\u0445,\n\u0441\u0432\u044f\u0437\u0430\u043d\u043d\u044b\u0445 \u0441 \u043d\u0435\u0445\u0432\u0430\u0442\u043a\u043e\u0439 \u043f\u0430\u043c\u044f\u0442\u0438.", null);
            return;
        }
        File dumpFile = (File)dumpFiles.get(0);
        CellsContainer ctr = new CellsContainer();
        ctr.getColumns().addAll((Object[])new CellsContainerColumn[]{new CellsContainerColumn(), new CellsContainerColumn()});
        ctr.getCells().add((Object)new SimpleCell("\u0414\u0430\u0442\u0430 \u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f", SimpleCell.Style.CAPTION));
        ctr.getCells().add((Object)new SimpleCell((String)StandardRenderers.DATE_TIME.apply((Object)new Date(dumpFile.lastModified())), SimpleCell.Style.VALUE));
        ctr.getCells().add((Object)new SimpleCell("\u0420\u0430\u0437\u043c\u0435\u0440 \u0434\u0430\u043d\u043d\u044b\u0445", SimpleCell.Style.CAPTION));
        ctr.getCells().add((Object)new SimpleCell((String)StandardRenderers.NUMBER_INTEGRAL.apply((Object)dumpFile.length()) + " \u0431\u0430\u0439\u0442", SimpleCell.Style.VALUE));
        Label label = new Label("\u041f\u0435\u0440\u0435\u0442\u0430\u0449\u0438\u0442\u0435 \u0434\u043b\u044f \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0434\u0430\u043d\u043d\u044b\u0445 \u043e\u0442\u0447\u0451\u0442\u0430");
        label.setStyle("-fx-padding:1.5em");
        label.setMaxWidth(Double.MAX_VALUE);
        label.setAlignment(Pos.CENTER);
        label.getStyleClass().add((Object)"draggable");
        label.setOnDragDetected(evt -> {
            Dragboard db = label.startDragAndDrop(new TransferMode[]{TransferMode.COPY});
            db.setContent(Collections.singletonMap(DataFormat.FILES, Collections.singletonList(dumpFile)));
            evt.consume();
        });
        ComplexCell cell = new ComplexCell((Node)label);
        cell.setColSpan(2);
        ctr.getCells().add((Object)cell);
        new Dialog().setTitle("\u041e\u0442\u0447\u0451\u0442 \u043e \u043d\u0435\u0445\u0432\u0430\u0442\u043a\u0435 \u043f\u0430\u043c\u044f\u0442\u0438").setBody((Node)ctr).addButton(DialogButtonStyle.ACCEPT_REGULAR).showGlobal();
    }
}

