/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.maintools.bugreport;

import com.gridnine.xtrip.client.fx.core.lib.components.tree.CustomCheckBoxTreeView;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.CardsContainer;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DateValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.FileChooserWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextAreaWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.standard.entity.actions.exporthelpers.ExportImportHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.support.BaseBugReport;
import com.gridnine.xtrip.common.model.system.exchange.ItemExportSettings;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.function.Predicate;
import javafx.scene.Node;
import javafx.stage.FileChooser;

public abstract class BaseBugReportPanel<E extends BaseBugReport>
extends CardsContainer {
    private final TextFieldWidget titleField;
    private final EntityBoxWidget<Organization> agencyField;
    private final TextAreaWidget descriptionField;
    private final FileChooserWidget fileChooserField;
    private DateValueWidget creationDateField;
    private final ItemExportSettings root;
    private final CustomCheckBoxTreeView<ItemExportSettings> treeView;
    ArrayList<Card<?>> cards = new ArrayList();
    protected BugReportPanelMode mode;

    public BaseBugReportPanel(BugReportPanelMode mode) {
        this.mode = mode;
        this.titleField = new TextFieldWidget(false);
        this.titleField.setValue("");
        this.descriptionField = new TextAreaWidget(false);
        this.descriptionField.setValue("");
        this.descriptionField.setPrefRowCount(3);
        this.agencyField = new EntityBoxWidget(Organization.class, false);
        this.agencyField.setListParametersSupplier(ControllerInterceptorsHelper::getAgencies);
        this.fileChooserField = new FileChooserWidget(false);
        this.fileChooserField.setMode(FileChooserWidget.ChoosingMode.SAVE);
        this.fileChooserField.setExtensionFiltersSupplier(() -> Collections.singletonList(new FileChooser.ExtensionFilter(Messages.Files_of_errors, new String[]{"*.zip"})));
        this.creationDateField = new DateValueWidget(false);
        this.root = ExportImportHelper.createModelExport(this.getObjectFilter());
        this.treeView = new CustomCheckBoxTreeView<ItemExportSettings>(this.root, true, Collections.emptyList()){

            protected List<ItemExportSettings> getNodeChildren(ItemExportSettings v) {
                return v.getChildren();
            }

            protected String getNodeTitle(ItemExportSettings v) {
                return ExportImportHelper.toString(v.getObjectId());
            }

            protected String getNodeId(ItemExportSettings v) {
                return v.getObjectId();
            }
        };
        this.treeView.setRootSelected(true);
    }

    protected GridContainer buildMainParametersContainer() {
        GridContainer container = new GridContainer(12);
        ArrayList<GridCell> cells = new ArrayList<GridCell>();
        GridCell cell = new GridCell(Messages.Header, (Node)this.titleField);
        cell.setColSpan(6);
        cells.add(cell);
        cell = new GridCell(Messages.Description, (Node)this.descriptionField);
        cell.setColSpan(6);
        cell.setRowSpan(3);
        cells.add(cell);
        cell = new GridCell(Messages.Agency, this.agencyField);
        cell.setColSpan(6);
        cells.add(cell);
        cells.add(GridCell.NEW_ROW_MARKER);
        if (this.mode == BugReportPanelMode.DIALOG) {
            cell = new GridCell(Messages.File_for_uploading, (Node)this.fileChooserField);
            cell.setColSpan(6);
            cells.add(cell);
        } else if (this.mode == BugReportPanelMode.EDITOR) {
            cell = new GridCell(Messages.Date_of_creation, (Node)this.creationDateField);
            cell.setColSpan(6);
            cells.add(cell);
        }
        cells.add(GridCell.NEW_ROW_MARKER);
        container.getCells().addAll(cells);
        return container;
    }

    protected GridContainer buildTreeParametersContainer() {
        GridContainer container = new GridContainer(8);
        ArrayList<GridCell> cells = new ArrayList<GridCell>();
        GridCell cell = new GridCell((Node)this.treeView.getTreePane());
        cell.setColSpan(4);
        cells.add(cell);
        container.getCells().addAll(cells);
        return container;
    }

    protected abstract Predicate<String> getObjectFilter();

    protected void readData(E model) {
        this.agencyField.setValue(model.getAgency());
        this.descriptionField.setValue(model.getDescription());
        this.titleField.setValue(model.getTitle());
        this.treeView.setNodesSelection(this.getSelectedIds(model.getExportSettings()));
        this.creationDateField.setValue(DateUtils.asLocalDate((Date)model.getCreateDate()));
    }

    protected void setReadonly(boolean readonly) {
        this.agencyField.getViewState().setReadonly(readonly);
        this.descriptionField.getViewState().setReadonly(readonly);
        this.titleField.getViewState().setReadonly(readonly);
        this.treeView.setReadonly(readonly);
        this.creationDateField.getViewState().setReadonly(readonly);
    }

    protected void setNotEditable(boolean notEditable) {
        this.agencyField.getViewState().setNotEditable(notEditable);
        this.descriptionField.getViewState().setNotEditable(notEditable);
        this.titleField.getViewState().setNotEditable(notEditable);
        this.treeView.setNotEditable(notEditable);
        this.creationDateField.getViewState().setNotEditable(notEditable);
    }

    protected void setAclNotEditable(boolean aclNotEditable) {
        this.agencyField.getViewState().setAclNotEditable(aclNotEditable);
        this.descriptionField.getViewState().setAclNotEditable(aclNotEditable);
        this.titleField.getViewState().setAclNotEditable(aclNotEditable);
        this.treeView.setAclNotEditable(aclNotEditable);
        this.creationDateField.getViewState().setAclNotEditable(aclNotEditable);
    }

    private List<String> getSelectedIds(ItemExportSettings exportSettings) {
        ArrayList<String> res = new ArrayList<String>();
        res.add(exportSettings.getObjectId());
        this.getSelectedIds(exportSettings.getChildren(), res);
        return res;
    }

    private void getSelectedIds(List<ItemExportSettings> settings, List<String> res) {
        for (ItemExportSettings setting : settings) {
            res.add(setting.getObjectId());
            this.getSelectedIds(setting.getChildren(), res);
        }
    }

    public String getTitle() {
        return this.titleField != null ? this.titleField.getValue() : null;
    }

    public String getDescription() {
        return this.descriptionField != null ? this.descriptionField.getValue() : null;
    }

    public File getFile() {
        return this.fileChooserField.getFiles().size() > 0 ? (File)this.fileChooserField.getFiles().get(0) : null;
    }

    public EntityReference<Organization> getAgency() {
        return this.agencyField != null ? this.agencyField.getValue() : null;
    }

    public List<String> getSelectedTreeItems() {
        return this.treeView.getSelectedItemsIds();
    }

    public ItemExportSettings getTreeRoot() {
        return this.root;
    }

    public static enum BugReportPanelMode {
        DIALOG,
        EDITOR;

    }
}

