/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.maintools.cir;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.lib.components.dialog.MessagePane;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.model.profile.PCIDSSServerExchangeSettingsClaimDataContainer;
import com.gridnine.xtrip.client.fx.model.profile.PCIDSSServerExchangeSettingsClaimDialogContainer;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.helper.UniqueSettingsRegistry;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.cir.CirHelper;
import com.gridnine.xtrip.common.model.profile.CirToken;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.PCIDSSServerExchangeSettings;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.stage.FileChooser;

public class CIRClaimDialog {
    private static final String CIR_KEY_SELECTOR_TOOLTIP = Messages.Files_with_key;
    private static final String CIR_KEY_EXTENSION = "*.epk";

    public static void showCIRClaimDialog() {
        PCIDSSServerExchangeSettingsClaimDialogContainer claimDialog = new PCIDSSServerExchangeSettingsClaimDialogContainer(false);
        Dialog dialog = new Dialog();
        PCIDSSServerExchangeSettingsClaimDataContainer claimPanel = (PCIDSSServerExchangeSettingsClaimDataContainer)claimDialog.getClaimCard().getContent();
        Notifications.get().submitTask(() -> {
            String settingsName = ((EntityType)MetaRegistry.get().getEntities().get(PCIDSSServerExchangeSettings.class.getName())).getDisplayName();
            EntityContainer settingsContainer = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), PCIDSSServerExchangeSettings.class, UniqueSettingsRegistry.get().getUidByClassName(PCIDSSServerExchangeSettings.class.getName()));
            if (settingsContainer == null) {
                Notifications.get().showFlashNotification(Messages.Not_found + settingsName, Messages.Not_found + settingsName);
                dialog.close();
                return;
            }
            List agencyList = ((PCIDSSServerExchangeSettings)settingsContainer.getEntity()).getAgencyTokens().stream().map(CirToken::getAgencyProfile).collect(Collectors.toList());
            FxUtil.submitToFxThread(() -> {
                claimPanel.getKeyFileNode().setExtensionFiltersSupplier(() -> Collections.singletonList(new FileChooser.ExtensionFilter(CIR_KEY_SELECTOR_TOOLTIP, new String[]{CIR_KEY_EXTENSION})));
                ((PCIDSSServerExchangeSettingsClaimDataContainer)claimDialog.getClaimCard().getContent()).getAgencyNode().setItemsSupplier(() -> agencyList, false);
                dialog.setTitle(Messages.Send_CIR).setAutoClose(false).setOnCloseRequest(() -> ((Dialog)dialog).close()).setBody((Node)claimDialog).addButton(DialogButtonStyle.DECLINE, () -> ((Dialog)dialog).close()).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Send2, () -> {
                    claimDialog.getChildren().removeAll((Collection)claimDialog.getChildren().stream().filter(node -> node.getClass() == MessagePane.class).collect(Collectors.toList()));
                    String keyFilename = !claimPanel.getKeyFileNode().getFiles().isEmpty() ? ((File)claimPanel.getKeyFileNode().getFiles().get(0)).getAbsolutePath() : "";
                    String keyPassword = claimPanel.getPasswordNode().getValue();
                    String message = claimPanel.getMessageNode().getValue();
                    String email = claimPanel.getEmailNode().getValue();
                    EntityReference agency = claimPanel.getAgencyNode().getValue();
                    List<Node> listMessage = CIRClaimDialog.validateClaimData(keyFilename, keyPassword, message, email, (EntityReference<Organization>)agency);
                    if (!listMessage.isEmpty()) {
                        listMessage.forEach(error -> claimDialog.getChildren().add(0, error));
                        return;
                    }
                    dialog.close();
                    Notifications.get().submitTask(() -> {
                        try {
                            int code = CIRClaimDialog.sendCIRClaim(message, email, keyFilename, keyPassword, (EntityReference<Organization>)agency);
                            if (code == 204) {
                                String resultMessage = String.format(Messages.Application_accepted_by_CIR, " %s", code);
                                Notifications.get().showStaticNotification(resultMessage, resultMessage);
                            } else {
                                String resultMessage = String.format(Messages.Error_sending, " %s", code);
                                Notifications.get().showStaticNotification(resultMessage, resultMessage);
                            }
                        }
                        catch (Exception e) {
                            ErrorHandler.handle((Throwable)e);
                        }
                    }, Messages.CIR_sending);
                }).showGlobal();
            });
        }, Messages.Loading_parameters_PCI);
    }

    private static int sendCIRClaim(String message, String email, String keyFileName, String keyPassword, EntityReference<Organization> agency) throws Exception {
        PCIDSSServerExchangeSettings settings = (PCIDSSServerExchangeSettings)((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), PCIDSSServerExchangeSettings.class, "pci-dss-server-exchange-settings-uid").getEntity();
        return CirHelper.sendCIRClaimToTheServer((String)message, (String)email, (String)keyFileName, (String)keyPassword, (PCIDSSServerExchangeSettings)settings, agency);
    }

    private static List<Node> validateClaimData(String keyFileName, String keyPassword, String message, String email, EntityReference<Organization> agency) {
        ArrayList<Node> result = new ArrayList<Node>();
        if (TextUtil.isBlank((String)keyPassword)) {
            result.add((Node)MessagePane.error((String)Messages.Enter_password_CIR));
        }
        if (TextUtil.isBlank((String)keyFileName)) {
            result.add((Node)MessagePane.error((String)Messages.Specify_file_CIR));
        }
        if (TextUtil.isBlank((String)email)) {
            result.add((Node)MessagePane.error((String)Messages.Enter_mail));
        }
        if (TextUtil.isBlank((String)message)) {
            result.add((Node)MessagePane.error((String)Messages.Enter_message));
        }
        if (agency == null) {
            result.add((Node)MessagePane.error((String)Messages.Enter_agency));
        }
        return result;
    }
}

