/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.parsers;

import com.gridnine.xtrip.client.fx.core.entity.EntityIndexHandler;
import com.gridnine.xtrip.client.fx.core.entity.RootEntityHandler;
import com.gridnine.xtrip.client.fx.core.lib.container.cells.BaseCell;
import com.gridnine.xtrip.client.fx.core.lib.container.cells.CellsContainer;
import com.gridnine.xtrip.client.fx.core.lib.container.cells.CellsContainerColumn;
import com.gridnine.xtrip.client.fx.core.lib.container.cells.ComplexCell;
import com.gridnine.xtrip.client.fx.core.lib.container.cells.SimpleCell;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.BooleanValueWidget;
import com.gridnine.xtrip.client.fx.core.util.Converters;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.parsers.model.BaseExchangeDocument;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javafx.scene.Node;
import javafx.util.Pair;
import javafx.util.StringConverter;

class ExchangeDocumentClassesPane
extends CellsContainer {
    private Set<String> data = Collections.emptySet();

    ExchangeDocumentClassesPane() {
        this.getColumns().add((Object)new CellsContainerColumn());
        this.getColumns().add((Object)new CellsContainerColumn());
        this.getColumns().add((Object)new CellsContainerColumn());
        this.getColumns().add((Object)new CellsContainerColumn());
    }

    void setAll(boolean value) {
        for (BaseCell cell : this.getCells()) {
            if (!(cell instanceof ComplexCell)) continue;
            BooleanValueWidget widget = (BooleanValueWidget)((ComplexCell)cell).getPayload();
            widget.setValue(value);
        }
    }

    boolean isDataChanged() {
        for (BaseCell cell : this.getCells()) {
            if (!(cell instanceof ComplexCell)) continue;
            BooleanValueWidget widget = (BooleanValueWidget)((ComplexCell)cell).getPayload();
            Class cls = (Class)widget.getUserData();
            if (!(!widget.getValue() ? !this.data.contains(cls.getName()) : this.data.contains(cls.getName()))) continue;
            return true;
        }
        return false;
    }

    void readData(Set<String> hiddenClasses) {
        this.data = hiddenClasses;
        for (BaseCell cell : this.getCells()) {
            BooleanValueWidget widget;
            if (!(cell instanceof ComplexCell)) continue;
            Class cls = (Class)(widget = (BooleanValueWidget)((ComplexCell)cell).getPayload()).getUserData();
            widget.setValue(!this.data.contains(cls.getName()));
        }
    }

    void writeData(Set<String> hiddenClasses) {
        hiddenClasses.clear();
        for (BaseCell cell : this.getCells()) {
            if (!(cell instanceof ComplexCell)) continue;
            BooleanValueWidget widget = (BooleanValueWidget)((ComplexCell)cell).getPayload();
            Class cls = (Class)widget.getUserData();
            if (widget.getValue()) continue;
            hiddenClasses.add(cls.getName());
        }
        this.data = hiddenClasses;
    }

    void populate(List<Class<? extends BaseExchangeDocument>> classes) {
        StringConverter converter = Converters.boolConverter((String)Messages.Parsers_manager_show_class, (String)Messages.Parsers_manager_hide_class);
        ArrayList cells = new ArrayList();
        classes.stream().map(cls -> {
            String name = null;
            RootEntityHandler entityHandler = RootEntityHandler.forEntityClass((Class)cls);
            if (entityHandler != null) {
                EntityIndexHandler indexHandler = EntityIndexHandler.forIndexClass((Class)entityHandler.getStandardIndexClass());
                name = indexHandler != null ? EntityIndexHandler.format((EntityIndexHandler)indexHandler) : RootEntityHandler.format((RootEntityHandler)entityHandler);
            }
            return new Pair(name, cls);
        }).filter(pair -> pair.getKey() != null).sorted((lhs, rhs) -> ((String)lhs.getKey()).compareTo((String)rhs.getKey())).forEach(pair -> {
            cells.add(new SimpleCell((String)pair.getKey(), SimpleCell.Style.BASIC));
            BooleanValueWidget widget = new BooleanValueWidget(true, false);
            widget.setUserData(pair.getValue());
            widget.setConverter(converter);
            widget.setValue(!this.data.contains(((Class)pair.getValue()).getName()));
            cells.add(new ComplexCell((Node)widget));
        });
        this.getCells().addAll(cells);
    }
}

