/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.person.handlers;

import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.model.profile.CardVM;
import com.gridnine.xtrip.client.fx.model.profile.CardsMainPanelVM;
import com.gridnine.xtrip.client.fx.standard.person.handlers.BasePersonTileHelperTest;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.CardVendor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.LocalDate;
import java.util.Date;
import java.util.Iterator;
import org.junit.Assert;

public class PersonCardsTileHelperTest
extends BasePersonTileHelperTest<CardsMainPanelVM, Person> {
    @Override
    public void testToVM() {
        try {
            Method[] methods;
            CardsMainPanelVM full = new CardsMainPanelVM();
            Person model = new Person();
            this.fillModel(model);
            Class<?> helper = Class.forName("com.gridnine.xtrip.client.fx.standard.entity.handlers.person.PersonCardsTileHelper");
            block8: for (Method m : methods = helper.getDeclaredMethods()) {
                switch (m.getName()) {
                    case "toVM": {
                        m.setAccessible(true);
                        m.invoke(helper, model, full);
                        continue block8;
                    }
                }
            }
            Assert.assertEquals((long)model.getCards().size(), (long)full.getCards().size());
            Iterator fullIterator = full.getCards().iterator();
            model.getCards().forEach(card -> {
                if (fullIterator.hasNext()) {
                    CardVM next = (CardVM)fullIterator.next();
                    Assert.assertEquals((Object)card.getNameOnCard(), (Object)next.getOwner());
                    Assert.assertEquals((Object)card.getVendor().name(), (Object)next.getCardType().name());
                    BasePersonTileHelperTest.assertDates(card.getExpiration(), (LocalDate)next.getExpirationDate().get());
                    Assert.assertEquals((Object)card.isSof(), (Object)next.isSof());
                    Assert.assertEquals((Object)next.getComment(), (Object)card.getRemarks());
                } else {
                    Assert.assertTrue((boolean)false);
                }
            });
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            Assert.assertTrue((boolean)false);
        }
    }

    @Override
    public void testFromVM() {
        try {
            Method[] methods;
            CardsMainPanelVM full = new CardsMainPanelVM();
            Person model = new Person();
            this.fillVM(full);
            Class<?> helper = Class.forName("com.gridnine.xtrip.client.fx.standard.entity.handlers.person.PersonCardsTileHelper");
            block8: for (Method m : methods = helper.getDeclaredMethods()) {
                switch (m.getName()) {
                    case "fromVM": {
                        m.setAccessible(true);
                        m.invoke(helper, full, model);
                        continue block8;
                    }
                }
            }
            Assert.assertEquals((long)model.getCards().size(), (long)full.getCards().size());
            Iterator fullIterator = full.getCards().iterator();
            model.getCards().forEach(card -> {
                if (fullIterator.hasNext()) {
                    CardVM next = (CardVM)fullIterator.next();
                    Assert.assertEquals((Object)card.getNameOnCard(), (Object)next.getOwner());
                    Assert.assertEquals((Object)card.getVendor().name(), (Object)next.getCardType().name());
                    BasePersonTileHelperTest.assertDates(card.getExpiration(), (LocalDate)next.getExpirationDate().get());
                    Assert.assertEquals((Object)card.isSof(), (Object)next.isSof());
                    Assert.assertEquals((Object)next.getComment(), (Object)card.getRemarks());
                } else {
                    Assert.assertTrue((boolean)false);
                }
            });
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            Assert.assertTrue((boolean)false);
        }
    }

    @Override
    protected void fillVM(CardsMainPanelVM full) {
        CardVM fullVM = new CardVM();
        fullVM.setOwner("TestOwner001");
        fullVM.setCardType(CardVendor.VISA);
        fullVM.setNumber("TestNumber001");
        fullVM.getExpirationDate().set((Object)DateUtils.asLocalDate((Date)new Date()));
        fullVM.setSof(true);
        fullVM.setComment("TestComment001");
        full.getCards().add(fullVM);
    }

    @Override
    protected void fillModel(Person model) {
        Card card = new Card();
        card.setNameOnCard("TestOwner002");
        card.setVendor(CardVendor.MASTERCARD);
        card.setNumber("TestNumber002");
        card.setExpiration(new Date());
        card.setSof(true);
        card.setRemarks("TestComment002");
        model.getCards().add(card);
    }
}

