/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.prefetched;

import com.gridnine.xtrip.client.fx.core.util.ClientSettings;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.client.fx.standard.worklog.Workplace;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.fx.model.AgentData;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.system.Worklog;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;

public class PrefetchedHelper {
    private static final String agencyUidProperty = "agencyUid";
    private static final String salesPointUidProperty = "salesPointUid";
    private static final String cashUidProperty = "cashUid";
    private static final String cashRegisterUidProperty = "cashRegisterUid";
    private static final String cashRegisterWorkplaceUidProperty = "cashRegisterWorkplaceUid";
    private static final String filePath = "settings/agent_data.properties";

    public static void saveAgentDataInfo(Worklog worklog) {
        PrefetchedHelper.saveAgentDataInfo(PrefetchedHelper.toUid(worklog.getAgency()), PrefetchedHelper.toUid(worklog.getSalesPoint()), PrefetchedHelper.toUid(worklog.getCash()), PrefetchedHelper.toUid(worklog.getCashRegister()), PrefetchedHelper.toUid(worklog.getCashRegisterWorkplace()));
    }

    private static String toUid(EntityReference ref) {
        return ref == null ? null : ref.getUid();
    }

    private static void saveAgentDataInfo(String agencyUid, String salesPointUid, String cashUid, String cashRegisterUid, String cashRegisterWorkplaceUid) {
        try {
            Path path = Paths.get(Environment.getDataFolder().getPath(), filePath);
            Properties properties = new Properties();
            if (TextUtil.nonBlank((String)agencyUid)) {
                properties.setProperty(agencyUidProperty, agencyUid);
            }
            if (TextUtil.nonBlank((String)salesPointUid)) {
                properties.setProperty(salesPointUidProperty, salesPointUid);
            }
            if (TextUtil.nonBlank((String)cashUid)) {
                properties.setProperty(cashUidProperty, cashUid);
            }
            if (TextUtil.nonBlank((String)cashRegisterUid)) {
                properties.setProperty(cashRegisterUidProperty, cashRegisterUid);
            }
            if (TextUtil.nonBlank((String)cashRegisterWorkplaceUid)) {
                properties.setProperty(cashRegisterWorkplaceUidProperty, cashRegisterWorkplaceUid);
            }
            try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                properties.store(writer, null);
            }
            catch (Exception e) {
                ErrorHandler.handle((Throwable)e);
            }
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
    }

    public static void saveAgentSalesPoint() {
        AgentData agentData;
        if (!Workplace.get().isWorklogEnabled() && (agentData = Prefetched.getData().getCurrentAgentData()).getSalesPoint() != null) {
            try {
                AgentDataInfo savedAgentData = PrefetchedHelper.getAgentDataInfo();
                PrefetchedHelper.saveAgentDataInfo(savedAgentData.getAgencyUid(), agentData.getSalesPoint().getUid(), savedAgentData.getCashUid(), savedAgentData.getCashRegisterUid(), savedAgentData.getCashRegisterWorkplaceUid());
            }
            catch (Exception e) {
                ErrorHandler.handle((Throwable)e);
            }
        }
    }

    static AgentDataInfo getAgentDataInfo() throws Exception {
        Path path = Paths.get(Environment.getDataFolder().getPath(), filePath);
        String agencyUid = null;
        String salesPointUid = null;
        String cashUid = null;
        String cashRegisterUid = null;
        String cashRegisterWorkplaceUid = null;
        if (Files.exists(path, new LinkOption[0]) && Files.isRegularFile(path, new LinkOption[0])) {
            Properties properties = new Properties();
            try (BufferedReader reader = Files.newBufferedReader(path);){
                properties.load(reader);
                agencyUid = properties.getProperty(agencyUidProperty);
                salesPointUid = properties.getProperty(salesPointUidProperty);
                cashUid = properties.getProperty(cashUidProperty);
                cashRegisterUid = properties.getProperty(cashRegisterUidProperty);
                cashRegisterWorkplaceUid = properties.getProperty(cashRegisterWorkplaceUidProperty);
            }
        }
        if (agencyUid == null) {
            agencyUid = ClientSettings.get().getProperty(agencyUidProperty);
        }
        if (salesPointUid == null) {
            salesPointUid = ClientSettings.get().getProperty(salesPointUidProperty);
        }
        AgentDataInfo agentDataInfo = new AgentDataInfo();
        agentDataInfo.setAgencyUid(agencyUid);
        agentDataInfo.setSalesPointUid(salesPointUid);
        agentDataInfo.setCashUid(cashUid);
        agentDataInfo.setCashRegisterUid(cashRegisterUid);
        agentDataInfo.setCashRegisterWorkplaceUid(cashRegisterWorkplaceUid);
        return agentDataInfo;
    }

    static class AgentDataInfo {
        private String agencyUid;
        private String salesPointUid;
        private String cashUid;
        private String cashRegisterUid;
        private String cashRegisterWorkplaceUid;

        AgentDataInfo() {
        }

        public String getAgencyUid() {
            return this.agencyUid;
        }

        public void setAgencyUid(String agencyUid) {
            this.agencyUid = agencyUid;
        }

        public String getSalesPointUid() {
            return this.salesPointUid;
        }

        public void setSalesPointUid(String salesPointUid) {
            this.salesPointUid = salesPointUid;
        }

        public String getCashUid() {
            return this.cashUid;
        }

        public void setCashUid(String cashUid) {
            this.cashUid = cashUid;
        }

        public String getCashRegisterUid() {
            return this.cashRegisterUid;
        }

        public void setCashRegisterUid(String cashRegisterUid) {
            this.cashRegisterUid = cashRegisterUid;
        }

        public String getCashRegisterWorkplaceUid() {
            return this.cashRegisterWorkplaceUid;
        }

        public void setCashRegisterWorkplaceUid(String cashRegisterWorkplaceUid) {
            this.cashRegisterWorkplaceUid = cashRegisterWorkplaceUid;
        }
    }
}

