/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.processing;

import com.gridnine.xtrip.client.fx.core.util.ClientSettings;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.parsers.register.ExchageDocumentResourceProvider;
import com.gridnine.xtrip.common.parsers.register.ExchangeDocumentFileResource;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.input.BOMInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExchangeDocumentFileResourceProvider
implements ExchageDocumentResourceProvider<ExchangeDocumentFileResource> {
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());
    protected final File directory;
    protected final FileFilter fileFilter;

    public ExchangeDocumentFileResourceProvider(String clientConfigProperty, String defaultFolderName, FileFilter filter) {
        File result;
        String value = ClientSettings.get().getProperty(clientConfigProperty);
        File file = result = TextUtil.isBlank((String)value) ? new File(Environment.getDataFolder(), String.format("import/%s", defaultFolderName)) : new File(value);
        if (!result.isDirectory()) {
            result.mkdirs();
        }
        this.log.debug("data folder is " + result);
        this.directory = result;
        this.fileFilter = filter;
    }

    public ExchangeDocumentFileResourceProvider(String clientConfigProperty, String defaultFolderName, final String ... suffixes) {
        this(clientConfigProperty, defaultFolderName, new FileFilter(){
            private final List<String> extensions = new ArrayList<String>();
            {
                for (String item : suffixes) {
                    if (TextUtil.isBlank((String)item)) continue;
                    if (item.indexOf(44) == -1) {
                        this.extensions.add(item);
                        continue;
                    }
                    for (String ext : item.split(",")) {
                        if (TextUtil.isBlank((String)ext)) continue;
                        this.extensions.add(ext);
                    }
                }
            }

            @Override
            public boolean accept(File file) {
                if (!file.isFile()) {
                    return false;
                }
                if (file.getName().startsWith(".")) {
                    return false;
                }
                if (this.extensions.contains("*")) {
                    return true;
                }
                for (String ext : this.extensions) {
                    if (!file.getName().toLowerCase().endsWith(ext)) continue;
                    return true;
                }
                return false;
            }
        });
    }

    public List<ExchangeDocumentFileResource> getResources() {
        ArrayList<ExchangeDocumentFileResource> result = new ArrayList<ExchangeDocumentFileResource>();
        for (File item : this.directory.listFiles(this.fileFilter)) {
            ExchangeDocumentFileResource resource;
            block5: {
                if (!item.isFile()) continue;
                resource = new ExchangeDocumentFileResource(item);
                if (this.isContentVerificationNeeded()) {
                    try {
                        if (!this.isContentCorrect(this.getContent(resource))) {
                            this.log.error(String.format("content of file %s is not correct", resource.getName()));
                        }
                        break block5;
                    }
                    catch (Exception e) {
                        this.log.error("unable to verify content of file " + resource.getName(), (Throwable)e);
                    }
                    continue;
                }
            }
            result.add(resource);
        }
        return result;
    }

    protected boolean isContentCorrect(byte[] content) throws Exception {
        return true;
    }

    protected boolean isContentVerificationNeeded() {
        return false;
    }

    public void moveTo(ExchangeDocumentFileResource item, String targetFolder) {
        if (!item.getFile().exists()) {
            return;
        }
        File folder = new File(item.getFile().getParentFile(), targetFolder);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        File targetFile = new File(folder, item.getName());
        try {
            IoUtil.copyFile((File)item.getFile(), (File)targetFile, (boolean)false);
            if (!item.getFile().delete()) {
                this.log.error(String.format("failed deleting file " + item.getFile(), new Object[0]));
            }
        }
        catch (IOException ioe) {
            this.log.error(String.format("failed moving file %s to %s", item.getFile(), targetFile), (Throwable)ioe);
        }
    }

    public byte[] getContent(ExchangeDocumentFileResource resource) throws Exception {
        if (!resource.getFile().canRead()) {
            throw new Exception(String.format("file %s cannot be read", resource.getFile().getAbsolutePath()));
        }
        try (BOMInputStream is = new BOMInputStream((InputStream)new BufferedInputStream(new FileInputStream(resource.getFile())), new ByteOrderMark[]{ByteOrderMark.UTF_8, ByteOrderMark.UTF_16LE, ByteOrderMark.UTF_16BE});){
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IoUtil.copyStream((InputStream)is, (OutputStream)baos, (int)256);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }
}

