/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.rules;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.lib.components.text.RichTextFlow;
import com.gridnine.xtrip.client.fx.core.lib.components.text.TextHandler;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.tasks.ServerTaskHandler;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.rules.FullRulesWidget;
import com.gridnine.xtrip.client.fx.standard.rules.RuleSettingsWrapper;
import com.gridnine.xtrip.common.fx.rpc.RulesExportProperties;
import com.gridnine.xtrip.common.fx.rpc.RulesImportProperties;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javafx.scene.Node;
import javafx.scene.control.Control;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class ExchangeRulesHelper {
    private static Logger log = LoggerFactory.getLogger(ExchangeRulesHelper.class);

    public static MiscUtil.Pair<RulesImportProperties.FileType, byte[]> getContent(List<File> files, List<Message> messages) {
        File file = files.get(0);
        if (file.isDirectory() || !file.exists()) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.File_does_not_exist, (Object[])new Object[0]));
            return null;
        }
        RulesImportProperties.FileType type = null;
        try {
            type = ExchangeRulesHelper.getFileType(file);
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
            return null;
        }
        if (type == null) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.Unknown_data_type, (Object[])new Object[0]));
            return null;
        }
        byte[] content = null;
        try (FileInputStream fis = new FileInputStream(file);){
            content = IOUtils.toByteArray((InputStream)fis);
        }
        catch (FileNotFoundException e) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.File_does_not_exist, (Object[])new Object[0]));
        }
        catch (IOException e) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.Error_reading_file, (Object[])new Object[0]));
        }
        if (content != null) {
            return new MiscUtil.Pair((Object)type, (Object)content);
        }
        return null;
    }

    public static void importRulesOnClient(RulesImportProperties properties, FullRulesWidget widget, List<Message> messages, Control source) {
        RuleSet oldRules = properties.getRuleSet();
        RuleSet newRules = ExchangeRulesHelper.importXtripZipRules(properties.getContent(), messages);
        if (newRules == null) {
            return;
        }
        ExchangeRulesHelper.replaceOldRules(newRules.getRules());
        if (newRules.getRules().size() == 0) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.No_rules_for_import, (Object[])new Object[0]));
            return;
        }
        if (properties.getImportType() == RulesImportProperties.ImportType.SUBSTITUTE) {
            oldRules.getRules().clear();
            messages.add(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)(Messages.Import_completed + "<br>" + Messages.Rules_All_rules_replaced), (Object[])new Object[]{Integer.toString(newRules.getRules().size())}));
        }
        oldRules.getRules().addAll(newRules.getRules());
        ExchangeRulesHelper.addLog(messages);
        ExchangeRulesHelper.updateRulesEditor(oldRules, widget);
        Dialog summaryDialog = new Dialog();
        summaryDialog.setTitle(Messages.Import_Result).setAutoClose(false).setBody((Node)ExchangeRulesHelper.createMessagesPanel(messages)).setExpandToParent().addButton(DialogButtonStyle.ACCEPT_REGULAR, () -> ((Dialog)summaryDialog).close()).setOnCloseRequest(() -> ((Dialog)summaryDialog).close()).show((Node)source);
    }

    private static void addLog(List<Message> messages) {
        StringBuilder details = new StringBuilder("<HTML>");
        for (Message msg : messages) {
            details.append("<br>");
            details.append("<b>").append(msg.getType()).append(":</b> ");
            details.append(LocaleManager.get().getL10nResourceManager().getMessage(msg.getMessage()));
            if (msg.getDetails() == null) continue;
            details.append("<br>\r\n").append(msg.getDetails());
        }
        Message message = new Message();
        message.setType(MessageType.MESSAGE);
        message.setMessage(L10nResourcesManager.createL10nMessage((String)Messages.Imported_commissions_from_a_file, (Object[])new Object[0]));
        message.setDetails(details.toString());
    }

    private static RulesImportProperties.FileType getFileType(File file) throws Exception {
        if (file.getName().endsWith(".tch")) {
            return RulesImportProperties.FileType.TCH_EXCEL;
        }
        if (!file.getName().endsWith(".zip")) {
            return null;
        }
        try (ZipInputStream strm = new ZipInputStream(new FileInputStream(file));){
            ZipEntry entry = strm.getNextEntry();
            if (entry == null) {
                RulesImportProperties.FileType fileType = null;
                return fileType;
            }
            RulesImportProperties.FileType fileType = entry.getName().equals("tcomexp.xml") ? RulesImportProperties.FileType.TCH_XML : RulesImportProperties.FileType.XTRIP;
            return fileType;
        }
    }

    private static void replaceOldRules(List<RuleSettings> rulesToImport) {
        Iterator<RuleSettings> it = rulesToImport.iterator();
        block0: while (it.hasNext()) {
            RuleSettings rs = it.next();
            for (RuleResult rr : rs.getResults()) {
                RuleAction action = rr.getAction();
                if (action != null && !TextUtil.isBlank((String)action.getId()) && rr.getValue() != null) continue;
                it.remove();
                continue block0;
            }
        }
    }

    static void updateRulesEditor(RuleSet ruleSet, FullRulesWidget widget) {
        ArrayList<RuleSettingsWrapper> newRules = new ArrayList<RuleSettingsWrapper>();
        int count = widget.getData().size();
        for (RuleSettings rs : ruleSet.getRules()) {
            RuleSettingsWrapper wrapper = new RuleSettingsWrapper(rs, count);
            newRules.add(wrapper);
            ++count;
        }
        widget.reloadRules(newRules);
    }

    public static void importRulesOnServer(final RulesImportProperties options, final FullRulesWidget widget, final Runnable closeStub) {
        Notifications.get().enqueueAsyncTask(new ServerTaskHandler(){

            protected String getTitle() {
                return Messages.Import_Rules;
            }

            protected void onCompleted(Object result, List<Message> messages) {
                try {
                    FxUtil.waitForFxThread(() -> {
                        if (result != null) {
                            ExchangeRulesHelper.updateRulesEditor((RuleSet)result, widget);
                        }
                        Dialog summaryDialog = new Dialog();
                        summaryDialog.setTitle(Messages.Import_Result).setAutoClose(false).setExpandToParent(true).setBody((Node)ExchangeRulesHelper.createMessagesPanel(messages)).addButton(DialogButtonStyle.ACCEPT_REGULAR, () -> ((Dialog)summaryDialog).close()).setOnCloseRequest(() -> ((Dialog)summaryDialog).close()).showGlobal();
                        closeStub.run();
                    });
                }
                catch (Exception e) {
                    ErrorHandler.handle((Throwable)e);
                }
            }

            protected void onInterrupted(List<Message> messages) {
                FxUtil.submitToFxThread((Runnable)closeStub);
            }

            protected Serializable getTaskParameters() {
                return options;
            }

            protected String getTaskClassName() {
                return "com.gridnine.xtrip.server.fx.async.entityactions.contract.ContractRulesImportAsyncTask";
            }
        });
    }

    static RichTextFlow createMessagesPanel(List<Message> messages) {
        RichTextFlow richTextFlow = new RichTextFlow(TextHandler.SIMPLE_HTML, MessageHelper.toHtmlString(messages));
        return richTextFlow;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static RuleSet importXtripZipRules(byte[] content, List<Message> messages) {
        RuleSet result = new RuleSet();
        try (ZipInputStream strm = new ZipInputStream(new ByteArrayInputStream(content));){
            ZipEntry entry = strm.getNextEntry();
            if (entry == null) {
                messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.File_does_not_contain_XML_data, (Object[])new Object[0]));
                RuleSet ruleSet = null;
                return ruleSet;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IoUtil.copyStream((InputStream)strm, (OutputStream)baos, (int)256);
            byte[] arr = baos.toByteArray();
            if (arr.length == 0) {
                messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)(Messages.File_does_not_contain_data + entry), (Object[])new Object[0]));
                RuleSet ruleSet = null;
                return ruleSet;
            }
            Element rdElm = XmlUtil.getElement((Element)DocumentBuilderHelper.parse((InputStream)new ByteArrayInputStream(arr)).getDocumentElement(), (String)"rulesData");
            result.fromXML(rdElm);
            RuleSet ruleSet = (RuleSet)XCloneHelper.clone((XCloneable)result, (boolean)true);
            return ruleSet;
        }
        catch (Exception e) {
            log.error("Could not read file", (Throwable)e);
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.Error_while_importing_rules, (Throwable)e, (Object[])new Object[0]));
            return null;
        }
    }

    public static void exportRulesOnServer(final File file, final RulesExportProperties exportProperties) {
        Notifications.get().enqueueAsyncTask(new ServerTaskHandler(){

            protected String getTitle() {
                return Messages.Export_Data;
            }

            protected void onCompleted(Object result, List<Message> log) {
                if (result == null) {
                    return;
                }
                FxUtil.saveToFile((File)file, (byte[])((byte[])result));
            }

            protected Serializable getTaskParameters() {
                return exportProperties;
            }

            protected String getTaskClassName() {
                return "com.gridnine.xtrip.server.fx.async.entityactions.contract.ContractRulesExportAsyncTask";
            }
        });
    }
}

