/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.rules;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.LightDialog;
import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.components.FilteringPane;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SimpleSuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.components.table.CustomTableView;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.CustomWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.IntValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.res.Styles;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.rules.RuleSettingsDialog;
import com.gridnine.xtrip.client.fx.standard.rules.RuleSettingsWrapper;
import com.gridnine.xtrip.client.fx.standard.rules.RulesColumn;
import com.gridnine.xtrip.client.fx.standard.rules.RulesFilter;
import com.gridnine.xtrip.client.fx.standard.rules.RulesViewConfiguration;
import com.gridnine.xtrip.client.fx.standard.rules.renderers.RulesCustomProperties;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.rules.RuleFilteringCategory;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.RulesEnvironment;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Region;
import javafx.scene.shape.Rectangle;
import javafx.util.Callback;
import javafx.util.StringConverter;

public class FullRulesWidget
extends CustomWidget<RuleSet> {
    static final ObservableValue<Object> NULL_OBJECT_WRAPPER = new ReadOnlyObjectWrapper();
    private FilteringPane<Node> filteringPane;
    protected final CustomTableView<RuleSettingsWrapper> rulesTable = new CustomTableView();
    private final TableColumn<RuleSettingsWrapper, Object> controlsColumn;
    private final Callback<TableColumn<RuleSettingsWrapper, Object>, TableCell<RuleSettingsWrapper, Object>> controlsCellFactory = new Callback<TableColumn<RuleSettingsWrapper, Object>, TableCell<RuleSettingsWrapper, Object>>(){

        public TableCell<RuleSettingsWrapper, Object> call(TableColumn<RuleSettingsWrapper, Object> column) {
            return new TableCell<RuleSettingsWrapper, Object>(){
                private ControlsPane graphics;

                private RuleSettingsWrapper getRowValue() {
                    int idx = this.getIndex();
                    ObservableList items = this.getTableView().getItems();
                    return items.isEmpty() || idx < 0 || idx > items.size() - 1 ? null : (RuleSettingsWrapper)items.get(idx);
                }

                protected void updateItem(Object item, boolean empty) {
                    super.updateItem(item, empty);
                    if (empty) {
                        this.setGraphic(null);
                        return;
                    }
                    if (this.graphics == null) {
                        this.graphics = new ControlsPane();
                        this.graphics.addButton(ControlsPane.ButtonType.DOWN, evt -> {
                            evt.consume();
                            RuleSettingsWrapper rowValue = Objects.requireNonNull(this.getRowValue());
                            FullRulesWidget.this.moveToIndex(rowValue, FullRulesWidget.this.findNextActiveRuleIndex(rowValue.getIndex()));
                        }, (ObservableValue)new BooleanBinding(){
                            {
                                this.bind(new Observable[]{FullRulesWidget.this.rulesTable.getItems(), this.indexProperty()});
                            }

                            protected boolean computeValue() {
                                return !FullRulesWidget.this.isMoveDownAvailable(this.getRowValue(), true);
                            }
                        });
                        this.graphics.addButton(ControlsPane.ButtonType.UP, evt -> {
                            evt.consume();
                            RuleSettingsWrapper rowValue = Objects.requireNonNull(this.getRowValue());
                            FullRulesWidget.this.moveToIndex(rowValue, FullRulesWidget.this.findPrevActiveRuleIndex(rowValue.getIndex()));
                        }, (ObservableValue)new BooleanBinding(){
                            {
                                this.bind(new Observable[]{FullRulesWidget.this.rulesTable.getItems(), this.indexProperty()});
                            }

                            protected boolean computeValue() {
                                return !FullRulesWidget.this.isMoveUpAvailable(this.getRowValue(), true);
                            }
                        });
                        this.graphics.addButton(ControlsPane.ButtonType.REMOVE, evt -> FullRulesWidget.this.removeRule(this.getRowValue()));
                        this.graphics.addButton(ControlsPane.ButtonType.ADD, evt -> FullRulesWidget.this.addRule((Region)evt.getSource(), this.getRowValue()));
                    }
                    this.setGraphic((Node)this.graphics);
                }
            };
        }
    };
    private final ViewState viewState = new ViewState();
    protected final ObservableList<RuleSettingsWrapper> data = FXCollections.observableArrayList();
    private final Set<String> filteredOutUids = new HashSet<String>();
    private boolean dataChanged;
    private Predicate<RuleSettingsWrapper> filtersPredicate = rule -> true;
    private RulesViewConfiguration configuration;
    ComboBoxWidget<RuleFilteringCategory> categoryWidget;
    ComboBoxWidget<RuleTarget> ruleTargetWidget;
    private final BorderPane pane;
    private boolean collapsible;

    public FullRulesWidget(boolean ro) {
        this.controlsColumn = new TableColumn();
        this.controlsColumn.setCellFactory(this.controlsCellFactory);
        this.controlsColumn.setCellValueFactory(param -> NULL_OBJECT_WRAPPER);
        this.controlsColumn.setMinWidth(110.0);
        this.controlsColumn.setPrefWidth(110.0);
        this.controlsColumn.setMaxWidth(110.0);
        this.controlsColumn.setSortable(false);
        this.controlsColumn.getStyleClass().add((Object)"controls-column");
        Styles.addStyle((Styleable)this, (String)"full-rules-widget");
        this.rulesTable.getStyleClass().add((Object)"xtrip-rules-list");
        this.rulesTable.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.rulesTable.setMaxHeight(Double.MAX_VALUE);
        this.rulesTable.getColumns().addAll((Collection)Stream.of(RulesColumn.values()).map(RulesColumn::createColumn).collect(Collectors.toList()));
        this.rulesTable.getColumns().add(this.controlsColumn);
        this.rulesTable.addEventHandler(MouseEvent.MOUSE_CLICKED, evt -> {
            boolean isTargetRectangle = evt.getTarget().getClass().isAssignableFrom(Rectangle.class);
            if (evt.getClickCount() > 1 && !isTargetRectangle) {
                this.viewOrEdit((RuleSettingsWrapper)this.rulesTable.getSelectionModel().getSelectedItem());
            }
        });
        this.rulesTable.addEventHandler(KeyEvent.KEY_RELEASED, evt -> {
            if (evt.getCode() == KeyCode.ENTER) {
                this.viewOrEdit((RuleSettingsWrapper)this.rulesTable.getSelectionModel().getSelectedItem());
            }
        });
        this.rulesTable.setInterlacingHighlight(true);
        this.pane = new BorderPane(this.rulesTable);
        this.getChildren().add((Object)this.pane);
        this.setMaxHeight(Double.MAX_VALUE);
        this.data.addListener(src -> {
            this.dataChanged = true;
        });
        this.viewState.stateProperty().addListener((s, o, n) -> this.updateState());
        this.viewState.setReadonly(ro);
    }

    private Node createFiltersPane() {
        ArrayList cells = new ArrayList();
        if (this.configuration != null) {
            ArrayList<RulesFilter> filters = new ArrayList<RulesFilter>(this.configuration.getFilters());
            if (this.configuration.getCategories().size() > 1) {
                filters.add(new RulesFilter(){

                    @Override
                    public Predicate<RuleSettingsWrapper> build(RulesViewConfiguration configLocal, List<GridCell<?>> cellsLocal, Runnable runnable) {
                        FullRulesWidget.this.categoryWidget = new ComboBoxWidget(false);
                        FullRulesWidget.this.categoryWidget.setItemsSupplier(configLocal::getCategories);
                        if (!configLocal.getCategories().isEmpty()) {
                            FullRulesWidget.this.categoryWidget.setValue((Object)configLocal.getCategories().get(0));
                        }
                        FullRulesWidget.this.categoryWidget.setConverter((StringConverter)new StringConverter<RuleFilteringCategory>(){

                            public String toString(RuleFilteringCategory object) {
                                if (object == null) {
                                    return "";
                                }
                                String result = object.getDisplayName();
                                return TextUtil.isBlank((String)result) ? object.getId() : result;
                            }

                            public RuleFilteringCategory fromString(String string) {
                                return null;
                            }
                        });
                        FullRulesWidget.this.categoryWidget.setSuggestionsHandler((SuggestionsHandler)new SimpleSuggestionsHandler(FullRulesWidget.this.categoryWidget.getConverter(), FullRulesWidget.this.categoryWidget.getItemsSupplier(), FullRulesWidget.this.categoryWidget.isSortItems()));
                        GridCell cell = new GridCell(Messages.Category, FullRulesWidget.this.categoryWidget);
                        cell.setColSpan(2);
                        cellsLocal.add(cell);
                        if (!FullRulesWidget.this.collapsible) {
                            FullRulesWidget.this.categoryWidget.valueProperty().addListener((obj, newValue, oldValue) -> {
                                FullRulesWidget.this.applyFilters();
                                FullRulesWidget.this.updateRules();
                            });
                        }
                        return ruleSettings -> {
                            RuleFilteringCategory category = (RuleFilteringCategory)FullRulesWidget.this.categoryWidget.getValue();
                            if (category == null) {
                                return true;
                            }
                            RuleFilteringCategory ruleCategory = ruleSettings.getSource().getFilteringCategory();
                            if (ruleCategory != null) {
                                return category.equals(ruleCategory);
                            }
                            Collection targets = RulesEnvironment.get().getTargets(category);
                            return targets.contains(ruleSettings.getSource().getTarget());
                        };
                    }
                });
            }
            if (this.configuration.getTargetsSupplier().get().size() > 1) {
                filters.add(new RulesFilter(){

                    @Override
                    public Predicate<RuleSettingsWrapper> build(RulesViewConfiguration configLocal, List<GridCell<?>> cellsLocal, Runnable runnable) {
                        FullRulesWidget.this.ruleTargetWidget = new ComboBoxWidget(false);
                        FullRulesWidget.this.ruleTargetWidget.setItemsSupplier(configLocal.getTargetsSupplier());
                        FullRulesWidget.this.ruleTargetWidget.setConverter((StringConverter)new StringConverter<RuleTarget>(){

                            public String toString(RuleTarget object) {
                                if (object == null) {
                                    return "";
                                }
                                String result = object.getDisplayName();
                                return TextUtil.isBlank((String)result) ? object.getId() : result;
                            }

                            public RuleTarget fromString(String string) {
                                return null;
                            }
                        });
                        FullRulesWidget.this.ruleTargetWidget.setSuggestionsHandler((SuggestionsHandler)new SimpleSuggestionsHandler(FullRulesWidget.this.ruleTargetWidget.getConverter(), FullRulesWidget.this.ruleTargetWidget.getItemsSupplier(), FullRulesWidget.this.ruleTargetWidget.isSortItems()));
                        GridCell cell = new GridCell(Messages.RuleTarget, FullRulesWidget.this.ruleTargetWidget);
                        cellsLocal.add(cell);
                        if (!FullRulesWidget.this.collapsible) {
                            FullRulesWidget.this.ruleTargetWidget.valueProperty().addListener((obj, newValue, oldValue) -> {
                                FullRulesWidget.this.applyFilters();
                                FullRulesWidget.this.updateRules();
                            });
                        }
                        return ruleSettings -> {
                            RuleTarget target = (RuleTarget)FullRulesWidget.this.ruleTargetWidget.getValue();
                            if (target == null) {
                                return true;
                            }
                            RuleTarget ruleTarget = ruleSettings.getSource().getTarget();
                            return Objects.equals(target, ruleTarget);
                        };
                    }
                });
            }
            if (!filters.isEmpty()) {
                Predicate<RuleSettingsWrapper> predicate = null;
                for (RulesFilter filter : filters) {
                    Predicate<RuleSettingsWrapper> pred = filter.build(this.configuration, cells, () -> {
                        this.applyFilters();
                        this.updateRules();
                    });
                    if (predicate == null) {
                        predicate = pred;
                        continue;
                    }
                    predicate = predicate.and(pred);
                }
                this.filtersPredicate = predicate;
            }
        }
        GridContainer result = new GridContainer(6);
        result.getCells().addAll(cells);
        return result;
    }

    void init(RulesViewConfiguration config) {
        this.collapsible = config.isCollapsible();
        this.filteringPane = new FilteringPane(this::createFiltersPane, config.isCollapsible());
        this.filteringPane.setOnApply(filtersPane -> {
            this.applyFilters();
            this.updateRules();
        });
        this.pane.setTop(this.filteringPane);
        this.configuration = config;
        this.filteringPane.reset();
        this.getProperties().put((Object)RulesCustomProperties.PROPS_KEY, (Object)this.configuration.getCustomProperties());
    }

    ObservableList<RuleSettingsWrapper> getData() {
        return this.data;
    }

    public void scrollToSelected() {
        this.rulesTable.scrollTo(this.rulesTable.getSelectionModel().getSelectedIndex());
    }

    public void setFieldName(String value) {
    }

    public void readData(RuleSet model) {
        List list;
        if (model == null) {
            list = Collections.emptyList();
        } else {
            list = new ArrayList(model.getRules().size());
            for (RuleSettings rs : model.getRules()) {
                list.add(new RuleSettingsWrapper(rs, list.size()));
            }
        }
        this.data.setAll(list);
        this.applyFilters();
        this.updateRules();
        this.dataChanged = false;
    }

    public void writeData(RuleSet model) {
        model.getRules().clear();
        this.data.stream().map(RuleSettingsWrapper::getSource).collect(Collectors.toCollection(() -> ((RuleSet)model).getRules()));
        this.dataChanged = false;
    }

    public ViewState getViewState() {
        return this.viewState;
    }

    private void updateState() {
        if (this.viewState.isImmutable()) {
            this.rulesTable.getColumns().remove(this.controlsColumn);
            this.rulesTable.refresh();
        } else if (!this.rulesTable.getColumns().contains(this.controlsColumn)) {
            this.rulesTable.getColumns().add(this.controlsColumn);
            this.rulesTable.refresh();
        }
    }

    public boolean isDataChanged() {
        if (this.viewState.isImmutable()) {
            return false;
        }
        return this.dataChanged;
    }

    public void selectRule(String uid) {
        this.getData().forEach(wrapper -> {
            if (uid.equals(wrapper.getUid())) {
                if (this.categoryWidget != null && wrapper.getSource() != null && wrapper.getSource().getFilteringCategory() != null) {
                    this.categoryWidget.setValue((Object)wrapper.getSource().getFilteringCategory());
                    this.applyFilters();
                    this.updateRules();
                }
                this.rulesTable.getSelectionModel().select(wrapper);
                this.rulesTable.scrollTo(wrapper);
            }
        });
    }

    ObservableList<RuleSettingsWrapper> getSelectedRules() {
        return this.rulesTable.getSelectionModel().getSelectedItems();
    }

    void cloneRule(RuleSettingsWrapper sourceRule) {
        RuleSettingsWrapper newRule;
        if (sourceRule == null) {
            return;
        }
        try {
            newRule = new RuleSettingsWrapper((RuleSettings)XCloneHelper.clone((XCloneable)sourceRule.getSource(), (boolean)true), sourceRule.getIndex() + 1);
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
            return;
        }
        newRule.getSource().setName(Messages.Duplicate + newRule.getSource().getName());
        RuleSettingsDialog.edit((Node)this, this.configuration.getRuleParametersHandler(), this.configuration.getActionsSupplier(), newRule.getSource(), () -> {
            this.data.add(newRule.getIndex(), (Object)newRule);
            this.reindex();
            newRule.rebuild();
            this.updateRules();
            this.rulesTable.getSelectionModel().select((Object)newRule);
        }, true, this.configuration.getCustomProperties());
    }

    void addRule(Region source, RuleSettingsWrapper after) {
        RuleFilteringCategory category;
        if (this.categoryWidget != null) {
            category = (RuleFilteringCategory)this.categoryWidget.getValue();
            if (category == null) {
                this.filteringPane.setExpanded(true);
                Dialog.info((Node)this, (String)Messages.Select_a_category);
                return;
            }
        } else {
            category = null;
        }
        List targets = this.configuration.getTargetsSupplier().get().stream().filter(RuleTarget::isAvailableToCreate).collect(Collectors.toList());
        if (category != null) {
            Set set = RulesEnvironment.get().getTargets(category).stream().map(RuleTarget::getId).collect(Collectors.toSet());
            targets.removeIf(ruleTarget -> !set.contains(ruleTarget.getId()));
        }
        if (targets.size() == 1) {
            this.createRule(after, (RuleTarget)targets.get(0), category);
            return;
        }
        ComboBoxWidget widget = new ComboBoxWidget(false);
        widget.setItemsSupplier(() -> targets);
        widget.setConverter((StringConverter)new StringConverter<RuleTarget>(){

            public String toString(RuleTarget object) {
                return object == null ? "" : object.getDisplayName();
            }

            public RuleTarget fromString(String string) {
                return null;
            }
        });
        widget.setNoNulls(true);
        widget.guessPrefWidth();
        widget.setSuggestionsHandler((SuggestionsHandler)new SimpleSuggestionsHandler(widget.getConverter(), widget.getItemsSupplier(), widget.isSortItems()));
        new LightDialog().setTitle(Messages.Select_the_object_for_rule).setBody((Node)widget).setActionHandler(() -> {
            RuleTarget target = (RuleTarget)widget.getValue();
            if (target == null) {
                return;
            }
            this.createRule(after, target, category);
        }).setActionAvailability((BooleanExpression)Bindings.isNotNull((ObservableObjectValue)widget.valueProperty())).show(source);
    }

    public void reloadRules(List<RuleSettingsWrapper> rules) {
        this.data.clear();
        this.data.addAll(rules);
        this.reindex();
        this.updateRules();
    }

    private void createRule(RuleSettingsWrapper after, RuleTarget target, RuleFilteringCategory category) {
        RuleSettings src = new RuleSettings();
        src.setTarget(target);
        src.setFilteringCategory(category);
        int idx = after == null ? this.data.size() : after.getIndex() + 1;
        RuleSettingsWrapper rule = new RuleSettingsWrapper(src, idx);
        RuleSettingsDialog.edit((Node)this, this.configuration.getRuleParametersHandler(), this.configuration.getActionsSupplier(), rule.getSource(), () -> {
            this.data.add(idx, (Object)rule);
            rule.rebuild();
            this.reindex();
            this.updateRules();
            this.rulesTable.getSelectionModel().select((Object)rule);
        }, true, this.configuration.getCustomProperties());
    }

    void removeRule(RuleSettingsWrapper rule) {
        if (rule == null) {
            return;
        }
        Dialog.confirm((Node)this, (String)(Messages.Delete_rule + (rule.getIndex() + 1) + " ?"), (String)rule.getName(), (String)Messages.Delete, () -> {
            this.data.remove((Object)rule);
            this.reindex();
            this.updateRules();
        }, null);
    }

    void removeRules(List<RuleSettingsWrapper> rules) {
        if (rules.isEmpty()) {
            return;
        }
        if (rules.size() == 1) {
            this.removeRule(rules.get(0));
            return;
        }
        Dialog.confirm((Node)this, (String)Messages.Delete_selected_rule, null, (String)Messages.Delete, () -> {
            this.data.removeAll((Collection)rules);
            this.reindex();
            this.updateRules();
        }, null);
    }

    boolean isMoveUpAvailable(RuleSettingsWrapper rule) {
        return this.isMoveUpAvailable(rule, false);
    }

    boolean isMoveUpAvailable(RuleSettingsWrapper rule, boolean allowMovingThoughInactiveElements) {
        if (rule == null) {
            return false;
        }
        ObservableList items = this.rulesTable.getItems();
        int pos = items.indexOf(rule);
        if (pos <= 0) {
            return false;
        }
        if (allowMovingThoughInactiveElements) {
            return true;
        }
        RuleSettingsWrapper upRule = (RuleSettingsWrapper)items.get(pos - 1);
        return rule.getIndex() - upRule.getIndex() == 1;
    }

    void moveUp(RuleSettingsWrapper rule) {
        this.moveToIndex(rule, rule.getIndex() - 1);
    }

    void moveToIndex(RuleSettingsWrapper rule, int index) {
        FxUtil.swap(this.data, (int)rule.getIndex(), (int)index);
        this.reindex();
        this.updateRules();
        this.rulesTable.getSelectionModel().select((Object)rule);
    }

    int findNextActiveRuleIndex(int currentRuleIndex) {
        ObservableList items = this.rulesTable.getItems();
        int nextRuleIndex = items.indexOf(this.data.get(currentRuleIndex)) + 1;
        if (nextRuleIndex >= items.size()) {
            return currentRuleIndex;
        }
        return ((RuleSettingsWrapper)items.get(nextRuleIndex)).getIndex();
    }

    int findPrevActiveRuleIndex(int currentRuleIndex) {
        ObservableList items = this.rulesTable.getItems();
        int prevRuleIndex = items.indexOf(this.data.get(currentRuleIndex)) - 1;
        if (prevRuleIndex < 0) {
            return currentRuleIndex;
        }
        return ((RuleSettingsWrapper)items.get(prevRuleIndex)).getIndex();
    }

    boolean isMoveDownAvailable(RuleSettingsWrapper rule) {
        return this.isMoveDownAvailable(rule, false);
    }

    boolean isMoveDownAvailable(RuleSettingsWrapper rule, boolean allowMovingThroughInactiveElements) {
        if (rule == null) {
            return false;
        }
        ObservableList items = this.rulesTable.getItems();
        int pos = items.indexOf(rule);
        if (pos >= items.size() - 1) {
            return false;
        }
        if (allowMovingThroughInactiveElements) {
            return true;
        }
        RuleSettingsWrapper downRule = (RuleSettingsWrapper)items.get(pos + 1);
        return downRule.getIndex() - rule.getIndex() == 1;
    }

    void moveDown(RuleSettingsWrapper rule) {
        FxUtil.swap(this.data, (int)rule.getIndex(), (int)(rule.getIndex() + 1));
        this.reindex();
        this.updateRules();
        this.rulesTable.getSelectionModel().select((Object)rule);
    }

    void move(Region source, RuleSettingsWrapper rule) {
        if (rule == null) {
            return;
        }
        final IntValueWidget widget = new IntValueWidget(false);
        final int initialValue = rule.getIndex() + 1;
        new LightDialog().setTitle(Messages.Enter_a_new_rule_position + this.data.size()).setActionAvailability((BooleanExpression)new BooleanBinding(){
            {
                this.bind(new Observable[]{widget.valueProperty()});
            }

            protected boolean computeValue() {
                Integer val = (Integer)widget.getValue();
                return val != null && val != initialValue && val > 0 && val < FullRulesWidget.this.data.size();
            }
        }).setBody((Node)widget).setActionHandler(() -> {
            int pos = rule.getIndex();
            Integer newPos = (Integer)widget.valueProperty().get();
            if (newPos == null || newPos < 1 || newPos > this.data.size() || newPos - 1 == pos) {
                return;
            }
            FxUtil.move(this.data, (int)pos, (int)(newPos - 1));
            this.reindex();
            this.updateRules();
            this.selectRule(rule.getUid());
            this.scrollToSelected();
        }).show(source);
    }

    private void reindex() {
        int idx = 0;
        for (RuleSettingsWrapper item : this.data) {
            item.setIndex(idx++);
        }
    }

    private void applyFilters() {
        this.filteredOutUids.clear();
        this.data.stream().filter(rule -> !this.filtersPredicate.test((RuleSettingsWrapper)rule)).map(RuleSettingsWrapper::getUid).collect(Collectors.toCollection(() -> this.filteredOutUids));
    }

    private void updateRules() {
        List<Object> filteredData = !this.filteredOutUids.isEmpty() ? this.data.stream().filter(rule -> !this.filteredOutUids.contains(rule.getUid())).collect(Collectors.toList()) : this.data;
        String caption = Messages.FullRulesWidget_Rules;
        caption = caption + L10n.replace((String)Messages.A_Of_B, (Object[])new Object[]{filteredData.size(), this.data.size()});
        this.rulesTable.getItems().setAll((Collection)filteredData);
        this.rulesTable.refresh();
        this.filteringPane.setCaption(caption);
    }

    void viewOrEdit(RuleSettingsWrapper rule) {
        if (rule == null) {
            return;
        }
        if (this.viewState.isImmutable()) {
            RuleSettingsDialog.view((Node)this, this.configuration.getRuleParametersHandler(), this.configuration.getActionsSupplier(), rule.getSource(), this.configuration.getCustomProperties());
            return;
        }
        RuleSettingsDialog.edit((Node)this, this.configuration.getRuleParametersHandler(), this.configuration.getActionsSupplier(), rule.getSource(), () -> {
            this.dataChanged = true;
            rule.rebuild();
            this.reindex();
            this.updateRules();
        }, false, this.configuration.getCustomProperties());
    }

    public void setSingleSelectionMode() {
        this.rulesTable.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
    }

    public RuleSettingsWrapper getSelectedRule() {
        return (RuleSettingsWrapper)this.rulesTable.getSelectionModel().getSelectedItem();
    }
}

