/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.rules;

import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCellAction;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.rules.ExportRulesDialog;
import com.gridnine.xtrip.client.fx.standard.rules.FullRulesWidget;
import com.gridnine.xtrip.client.fx.standard.rules.ImportRulesDialog;
import com.gridnine.xtrip.client.fx.standard.rules.RuleSettingsWrapper;
import java.util.List;
import javafx.scene.control.Control;
import javafx.scene.layout.Region;

enum GridCellTools implements GridCellAction<FullRulesWidget>
{
    EDIT{

        public String getName(GridCell<FullRulesWidget> cell) {
            return ((FullRulesWidget)cell.getPayload()).getViewState().isImmutable() ? Messages.Look : Messages.Edit;
        }

        public String getDescription(GridCell<FullRulesWidget> cell) {
            return Messages.Edit_selected_rule;
        }

        public boolean isEnabled(GridCell<FullRulesWidget> cell) {
            return ((FullRulesWidget)cell.getPayload()).getSelectedRules().size() == 1;
        }

        public void execute(Control source, GridCell<FullRulesWidget> cell, boolean alt) {
            ((FullRulesWidget)cell.getPayload()).viewOrEdit((RuleSettingsWrapper)((FullRulesWidget)cell.getPayload()).getSelectedRules().get(0));
        }
    }
    ,
    ADD{

        public String getName(GridCell<FullRulesWidget> cell) {
            return Messages.Dialog_add;
        }

        public String getDescription(GridCell<FullRulesWidget> cell) {
            return Messages.Add_new_rule;
        }

        public boolean isEnabled(GridCell<FullRulesWidget> cell) {
            return !((FullRulesWidget)cell.getPayload()).getViewState().isImmutable();
        }

        public void execute(Control source, GridCell<FullRulesWidget> cell, boolean alt) {
            ((FullRulesWidget)cell.getPayload()).addRule((Region)source, ((FullRulesWidget)cell.getPayload()).getSelectedRules().size() != 1 ? null : (RuleSettingsWrapper)((FullRulesWidget)cell.getPayload()).getSelectedRules().get(0));
        }
    }
    ,
    REMOVE{

        public String getName(GridCell<FullRulesWidget> cell) {
            return Messages.Delete;
        }

        public String getDescription(GridCell<FullRulesWidget> cell) {
            return Messages.Delete_selected_rules;
        }

        public boolean isEnabled(GridCell<FullRulesWidget> cell) {
            return !((FullRulesWidget)cell.getPayload()).getViewState().isImmutable() && !((FullRulesWidget)cell.getPayload()).getSelectedRules().isEmpty();
        }

        public void execute(Control source, GridCell<FullRulesWidget> cell, boolean alt) {
            ((FullRulesWidget)cell.getPayload()).removeRules((List<RuleSettingsWrapper>)((FullRulesWidget)cell.getPayload()).getSelectedRules());
        }
    }
    ,
    CLONE{

        public String getName(GridCell<FullRulesWidget> cell) {
            return Messages.Copy;
        }

        public String getDescription(GridCell<FullRulesWidget> cell) {
            return Messages.Add_a_new_rule_based_on_the_selected;
        }

        public boolean isEnabled(GridCell<FullRulesWidget> cell) {
            return !((FullRulesWidget)cell.getPayload()).getViewState().isImmutable() && ((FullRulesWidget)cell.getPayload()).getSelectedRules().size() == 1;
        }

        public void execute(Control source, GridCell<FullRulesWidget> cell, boolean alt) {
            ((FullRulesWidget)cell.getPayload()).cloneRule((RuleSettingsWrapper)((FullRulesWidget)cell.getPayload()).getSelectedRules().get(0));
        }
    }
    ,
    MOVE_UP{

        public String getName(GridCell<FullRulesWidget> cell) {
            return Messages.Up;
        }

        public String getDescription(GridCell<FullRulesWidget> cell) {
            return Messages.Move_Up_one_position;
        }

        public boolean isEnabled(GridCell<FullRulesWidget> cell) {
            if (((FullRulesWidget)cell.getPayload()).getSelectedRules().size() != 1) {
                return false;
            }
            return !((FullRulesWidget)cell.getPayload()).getViewState().isImmutable() && ((FullRulesWidget)cell.getPayload()).isMoveUpAvailable((RuleSettingsWrapper)((FullRulesWidget)cell.getPayload()).getSelectedRules().get(0));
        }

        public void execute(Control source, GridCell<FullRulesWidget> cell, boolean alt) {
            ((FullRulesWidget)cell.getPayload()).moveUp((RuleSettingsWrapper)((FullRulesWidget)cell.getPayload()).getSelectedRules().get(0));
        }
    }
    ,
    MOVE_DOWN{

        public String getName(GridCell<FullRulesWidget> cell) {
            return Messages.Down;
        }

        public String getDescription(GridCell<FullRulesWidget> cell) {
            return Messages.Move_Down_one_position;
        }

        public boolean isEnabled(GridCell<FullRulesWidget> cell) {
            if (((FullRulesWidget)cell.getPayload()).getSelectedRules().size() != 1) {
                return false;
            }
            return !((FullRulesWidget)cell.getPayload()).getViewState().isImmutable() && ((FullRulesWidget)cell.getPayload()).isMoveDownAvailable((RuleSettingsWrapper)((FullRulesWidget)cell.getPayload()).getSelectedRules().get(0));
        }

        public void execute(Control source, GridCell<FullRulesWidget> cell, boolean alt) {
            ((FullRulesWidget)cell.getPayload()).moveDown((RuleSettingsWrapper)((FullRulesWidget)cell.getPayload()).getSelectedRules().get(0));
        }
    }
    ,
    MOVE{

        public String getName(GridCell<FullRulesWidget> cell) {
            return Messages.Move;
        }

        public String getDescription(GridCell<FullRulesWidget> cell) {
            return Messages.Move_to_the_specified_position;
        }

        public boolean isEnabled(GridCell<FullRulesWidget> cell) {
            return !((FullRulesWidget)cell.getPayload()).getViewState().isImmutable() && ((FullRulesWidget)cell.getPayload()).getSelectedRules().size() == 1;
        }

        public void execute(Control source, GridCell<FullRulesWidget> cell, boolean alt) {
            ((FullRulesWidget)cell.getPayload()).move((Region)source, (RuleSettingsWrapper)((FullRulesWidget)cell.getPayload()).getSelectedRules().get(0));
        }
    }
    ,
    IMPORT{

        public String getName(GridCell<FullRulesWidget> cell) {
            return Messages.To_Import;
        }

        public String getDescription(GridCell<FullRulesWidget> cell) {
            return Messages.Import_rules;
        }

        public boolean isEnabled(GridCell<FullRulesWidget> cell) {
            return !((FullRulesWidget)cell.getPayload()).getViewState().isImmutable();
        }

        public void execute(Control source, GridCell<FullRulesWidget> cell, boolean alt) {
            ImportRulesDialog dialog = new ImportRulesDialog();
            dialog.showDialog(source, (FullRulesWidget)cell.getPayload());
        }
    }
    ,
    EXPORT{

        public String getName(GridCell<FullRulesWidget> cell) {
            return Messages.Export;
        }

        public String getDescription(GridCell<FullRulesWidget> cell) {
            return Messages.Export_rules;
        }

        public boolean isEnabled(GridCell<FullRulesWidget> cell) {
            return !((FullRulesWidget)cell.getPayload()).getData().isEmpty();
        }

        public void execute(Control source, GridCell<FullRulesWidget> cell, boolean alt) {
            ExportRulesDialog dialog = new ExportRulesDialog();
            dialog.showDialog(source, (FullRulesWidget)cell.getPayload());
        }
    };


    public double getWeight() {
        return this.ordinal();
    }
}

