/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.rules;

import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.ExpandableColumn;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.scene.layout.Pane;

public class RulesEditorExpandableColumn<M, I, V extends Pane>
extends ExpandableColumn<M, V> {
    private final Function<M, I> getter;
    private final Supplier<ViewController<V, I>> controllerSupplier;

    public RulesEditorExpandableColumn(Function<M, I> aGgetter, Supplier<ViewController<V, I>> cs) {
        this.getter = aGgetter;
        this.controllerSupplier = cs;
    }

    protected V createView() {
        ViewController<V, I> controller = this.controllerSupplier.get();
        Pane result = (Pane)controller.getView();
        result.getProperties().put((Object)"controller", controller);
        return (V)result;
    }

    public void readData(M model, ExpandableColumn.ViewHolder<V> node) {
        ViewController controller = (ViewController)((Pane)node.getView()).getProperties().get((Object)"controller");
        controller.readData(this.getter.apply(model));
        boolean viewIsEmpty = node.getView() == null || ((Pane)node.getView()).getChildren().isEmpty();
        node.visibilityProperty().set(!viewIsEmpty);
    }

    public void writeData(M model, ExpandableColumn.ViewHolder<V> node) {
        ViewController controller = (ViewController)((Pane)node.getView()).getProperties().get((Object)"controller");
        controller.writeData(this.getter.apply(model));
    }

    public void setReadonly(ExpandableColumn.ViewHolder<V> node, boolean readonly) {
        ViewController controller = (ViewController)((Pane)node.getView()).getProperties().get((Object)"controller");
        controller.setReadonly(readonly);
    }

    public void setAclNotEditable(ExpandableColumn.ViewHolder<V> node) {
        ViewController controller = (ViewController)((Pane)node.getView()).getProperties().get((Object)"controller");
        controller.setAclNotEditable(this.isAclNotEditable());
    }

    public boolean isDataChanged(M model, ExpandableColumn.ViewHolder<V> node) {
        ViewController controller = (ViewController)((Pane)node.getView()).getProperties().get((Object)"controller");
        return controller.isDataChanged();
    }
}

