/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.rules.renderers;

import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.widgets.NodeRenderer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.RendererWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.Suppliers;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.RendererWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.TextWidgetColumn;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.rules.renderers.RuleValueRenderer;
import com.gridnine.xtrip.client.fx.standard.rules.renderers.StandardRuleValueRenderers;
import com.gridnine.xtrip.common.model.rules.standard.SegmentRestrictions;
import com.gridnine.xtrip.common.model.rules.standard.ValueTypes;
import com.gridnine.xtrip.common.rules.RuleRestriction;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javafx.scene.Node;

public class SegmentRestrictionValueRenderer
implements RuleValueRenderer {
    protected static final String DISABLED_CELL_STYLE = "xtrip-cell-disabled";

    public String getId() {
        return ValueTypes.SEGMENT.name();
    }

    public Node createNode(boolean readonly) {
        Node node = StandardRuleValueRenderers.NULL.createNode(readonly);
        node.setUserData((Object)new SegmentTable());
        return node;
    }

    public TableWidget<RuleRestriction> getPropertiesTable(Node node) {
        return (TableWidget)node.getUserData();
    }

    public Object getValue(Node node) {
        SegmentTable table = (SegmentTable)this.getPropertiesTable(node);
        if (table == null) {
            return null;
        }
        return new SegmentRestrictions(table.airlineCodes, table.routeCodes, table.tariffType == null ? null : table.tariffType.name(), table.firstInBranch == null ? null : table.firstInBranch.name(), table.lastInBranch == null ? null : table.lastInBranch.name());
    }

    public void setValue(Node node, Object value) {
        if (value == null) {
            return;
        }
        SegmentRestrictions restrictions = (SegmentRestrictions)value;
        SegmentTable table = (SegmentTable)this.getPropertiesTable(node);
        table.airlineCodes = restrictions.getAirlineCodes();
        table.routeCodes = restrictions.getRouteCodes();
        table.tariffType = restrictions.getTariffType();
        table.firstInBranch = restrictions.getFirstInBranch();
        table.lastInBranch = restrictions.getLastInBranch();
        table.refreshWidgets();
    }

    @Override
    public boolean isValueEmpty(Node node) {
        SegmentTable table = (SegmentTable)this.getPropertiesTable(node);
        return TextUtil.isBlank((String)table.airlineCodes) && TextUtil.isBlank((String)table.routeCodes) && SegmentRestrictions.TariffType.ALL.equals((Object)table.tariffType) && SegmentRestrictions.BranchPositionRestrictionType.NONE.equals((Object)table.firstInBranch) && SegmentRestrictions.BranchPositionRestrictionType.NONE.equals((Object)table.lastInBranch);
    }

    @Override
    public void buildRestrictionsInfo(Consumer<String> out, RuleRestriction ruleRestriction) {
        StringBuilder buf = new StringBuilder();
        SegmentRestrictions value = (SegmentRestrictions)ruleRestriction.getValue();
        SegmentRestrictions.buildInfo((StringBuilder)buf, (RuleCondition)ruleRestriction.getCondition(), (SegmentRestrictions)value);
        out.accept(buf.toString());
    }

    public void setReadonly(boolean readonly, Node node) {
        this.getPropertiesTable(node).getViewState().setReadonly(readonly);
    }

    class SegmentTable
    extends TableWidget<RuleRestriction> {
        protected static final String PROPERTY_ID = "property";
        protected static final String VALUE_ID = "value";
        private String routeCodes;
        private String airlineCodes;
        private SegmentRestrictions.TariffType tariffType;
        private SegmentRestrictions.BranchPositionRestrictionType firstInBranch;
        private SegmentRestrictions.BranchPositionRestrictionType lastInBranch;

        SegmentTable() {
            super(false);
            this.tariffType = SegmentRestrictions.TariffType.ALL;
            this.firstInBranch = SegmentRestrictions.BranchPositionRestrictionType.NONE;
            this.lastInBranch = SegmentRestrictions.BranchPositionRestrictionType.NONE;
            this.setItemsProvider(() -> new RuleRestriction());
            this.setColumns(this.createColumns());
            this.setControlButtonsAvailability(ControlsPane.NONE);
            this.fillTable();
        }

        void refreshWidgets() {
            RendererWidgetColumn column2 = (RendererWidgetColumn)this.getColumn(VALUE_ID);
            int idx = 0;
            RendererWidget widget = (RendererWidget)column2.getWidget(idx++);
            widget.setValue((Object)this.airlineCodes);
            widget = (RendererWidget)column2.getWidget(idx++);
            widget.setValue((Object)this.routeCodes);
            widget = (RendererWidget)column2.getWidget(idx++);
            widget.setValue((Object)this.tariffType);
            widget = (RendererWidget)column2.getWidget(idx++);
            widget.setValue((Object)this.firstInBranch);
            widget = (RendererWidget)column2.getWidget(idx++);
            widget.setValue((Object)this.lastInBranch);
        }

        private List<TableWidgetColumn<RuleRestriction, ?>> createColumns() {
            ArrayList tableColumns = new ArrayList();
            TextWidgetColumn column1 = new TextWidgetColumn(rr -> null, (rr, value) -> rr.setProperty(null));
            column1.setId(PROPERTY_ID);
            column1.setCaption(Messages.SegmentRestrictionValueRenderer_property);
            tableColumns.add((TableWidgetColumn<RuleRestriction, ?>)column1);
            RendererWidgetColumn column2 = new RendererWidgetColumn(rr -> rr.getValue(), (rr, value) -> rr.setValue(value));
            column2.setId(VALUE_ID);
            column2.setCaption(Messages.SegmentRestrictionValueRenderer_value);
            column2.setPrefWidth(Double.valueOf(55.0));
            tableColumns.add((TableWidgetColumn<RuleRestriction, ?>)column2);
            return tableColumns;
        }

        private void fillTable() {
            int row = 0;
            this.stringValueRow(row++, Messages.Airlines, () -> this.airlineCodes, v -> {
                this.airlineCodes = v;
            });
            this.stringValueRow(row++, Messages.Route, () -> this.routeCodes, v -> {
                this.routeCodes = v;
            });
            this.enumValueRow(row++, SegmentRestrictions.TariffType.class, Messages.Type_of_tariff, () -> this.tariffType, v -> {
                this.tariffType = v;
            });
            this.enumValueRow(row++, SegmentRestrictions.BranchPositionRestrictionType.class, Messages.Shoulder_Start, () -> this.firstInBranch, v -> {
                this.firstInBranch = v;
            });
            this.enumValueRow(row++, SegmentRestrictions.BranchPositionRestrictionType.class, Messages.Shoulder_End, () -> this.lastInBranch, v -> {
                this.lastInBranch = v;
            });
        }

        private void stringValueRow(int idx, String rowCaption, Supplier<String> valueGetter, Consumer<String> valueSetter) {
            this.addRow(idx);
            TextWidgetColumn column1 = (TextWidgetColumn)this.getColumn(PROPERTY_ID);
            TextFieldWidget node1 = (TextFieldWidget)column1.getWidget(idx);
            node1.getViewState().setNotEditable(true);
            node1.setValue(rowCaption);
            node1.getStyleClass().add((Object)SegmentRestrictionValueRenderer.DISABLED_CELL_STYLE);
            RendererWidgetColumn column2 = (RendererWidgetColumn)this.getColumn(VALUE_ID);
            RendererWidget node2 = (RendererWidget)column2.getWidget(idx);
            node2.setValue((Object)valueGetter.get());
            node2.setRenderer((NodeRenderer)StandardRuleValueRenderers.STRING);
            ((TextFieldWidget)node2.getValueNode()).valueProperty().addListener((p, o, v) -> valueSetter.accept((String)v));
        }

        private <T extends Enum> void enumValueRow(int idx, final Class<T> type, String rowCaption, Supplier<T> valueGetter, final Consumer<T> valueSetter) {
            this.addRow(idx);
            TextWidgetColumn column1 = (TextWidgetColumn)this.getColumn(PROPERTY_ID);
            TextFieldWidget node1 = (TextFieldWidget)column1.getWidget(idx);
            node1.getViewState().setNotEditable(true);
            node1.setValue(rowCaption);
            node1.getStyleClass().add((Object)SegmentRestrictionValueRenderer.DISABLED_CELL_STYLE);
            RendererWidgetColumn column2 = (RendererWidgetColumn)this.getColumn(VALUE_ID);
            RendererWidget node2 = (RendererWidget)column2.getWidget(idx);
            node2.setValue(valueGetter.get());
            node2.setRenderer(new NodeRenderer(){

                public Node createNode(boolean readonly) {
                    ComboBoxWidget widget = new ComboBoxWidget(readonly);
                    widget.setItemsSupplier(Suppliers.createEnumSupplier((Class)type));
                    widget.valueProperty().addListener((p, o, v) -> valueSetter.accept(v));
                    return widget;
                }

                public void setValue(Node node, Object value) {
                    ComboBoxWidget widget = (ComboBoxWidget)node;
                    widget.setValue((Object)((Enum)value));
                    valueSetter.accept((Enum)value);
                }

                public Object getValue(Node node) {
                    ComboBoxWidget widget = (ComboBoxWidget)node;
                    return widget.getValue();
                }

                public void setReadonly(boolean readonly, Node node) {
                    ComboBoxWidget widget = (ComboBoxWidget)node;
                    widget.getViewState().setReadonly(readonly);
                }
            });
        }
    }
}

